/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat;

import org.apfloat.Apcomplex;
import org.apfloat.ApcomplexMath;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatArithmeticException;
import org.apfloat.ApfloatHelper;
import org.apfloat.ApfloatMath;
import org.apfloat.Apint;
import org.apfloat.Aprational;
import org.apfloat.AprationalMath;
import org.apfloat.InfiniteExpansionException;
import org.apfloat.OverflowException;
import org.apfloat.spi.Util;

class ZetaHelper {
    private int radix;
    private long workingPrecision;
    private long v;
    private Apfloat NN;
    private Apint one;
    private Apint two;
    private Apfloat pi;
    private Apcomplex i;
    private Apcomplex oneS;
    private Apcomplex s1;
    private Apcomplex iTwoPiN;
    private Apcomplex gammaS;

    ZetaHelper() {
    }

    public static Apcomplex zeta(Apcomplex s) {
        int radix = s.radix();
        Apint one = Apint.ONES[radix];
        if (s.equals(one)) {
            throw new ApfloatArithmeticException("Zeta of one", "zeta.ofOne", new Object[0]);
        }
        Apint two = new Apint(2L, radix);
        if (s.isZero()) {
            return new Aprational(one, two).negate();
        }
        long precision = s.precision();
        if (s.isInteger() && s.real().signum() < 0) {
            if (s.real().truncate().mod(two).signum() == 0) {
                return Apcomplex.ZEROS[radix];
            }
            if (precision == Long.MAX_VALUE) {
                try {
                    long n1 = one.subtract(s.real()).longValueExact();
                    return AprationalMath.bernoulli(n1, radix).divide(new Apint(n1, radix)).negate();
                }
                catch (ArithmeticException n1) {
                    // empty catch block
                }
            }
        }
        if (precision == Long.MAX_VALUE) {
            throw new InfiniteExpansionException("Cannot calculate zeta function to infinite precision", "zeta.infinitePrecision", new Object[0]);
        }
        if (s.real().signum() < 0) {
            long extraPrecision = ApfloatHelper.getSmallExtraPrecision(radix);
            s = ApfloatHelper.extendPrecision(s, extraPrecision);
            Apcomplex result = ZetaHelper.chi(s).multiply(ZetaHelper.zeta(one.subtract(s)));
            return ApfloatHelper.reducePrecision(result, extraPrecision);
        }
        if (s.imag().signum() < 0) {
            return ZetaHelper.zeta(s.conj()).conj();
        }
        if (s.imag().doubleValue() == Double.POSITIVE_INFINITY) {
            throw new OverflowException("Imaginary part too large", "imag.overflow", new Object[0]);
        }
        if (s.real().compareTo(one) < 0 && s.imag().compareTo(new Apint(50000L, radix)) > 0) {
            return new ZetaHelper().zetafast(s);
        }
        return ZetaHelper.alternatingSum(s);
    }

    private static Apcomplex chi(Apcomplex s) {
        int radix = s.radix();
        Apint one = Apint.ONES[radix];
        Apint two = new Apint(2L, radix);
        Apfloat pi = ApfloatMath.pi(s.precision(), radix);
        Apcomplex s1 = s.subtract(one);
        return ApcomplexMath.pow((Apcomplex)two, s).multiply(ApcomplexMath.pow((Apcomplex)pi, s1)).multiply(ApcomplexMath.sin(pi.multiply(s).divide(two))).multiply(ApcomplexMath.gamma(s1.negate()));
    }

    public static Apcomplex alternatingSum(Apcomplex s) {
        int radix = s.radix();
        long doublePrecision = ApfloatHelper.getDoublePrecision(radix);
        long extraPrecision = ApfloatHelper.getSmallExtraPrecision(radix);
        long workingPrecision = ApfloatHelper.extendPrecision(s.precision(), extraPrecision);
        s = ApfloatHelper.extendPrecision(s, extraPrecision);
        Apint one = Apint.ONES[radix];
        Apint two = new Apint(2L, radix);
        Apint four = new Apint(4L, radix);
        double t = Math.abs(s.imag().doubleValue());
        double s12 = ApcomplexMath.abs(one.subtract(ApcomplexMath.pow((Apcomplex)two, one.subtract(s.precision(doublePrecision))))).doubleValue();
        long n = (long)(((double)workingPrecision * Math.log(radix) + t * Math.PI / 2.0 + Math.log((1.0 + 2.0 * t) / s12)) / Math.log(3.0 + Math.sqrt(8.0)));
        long n2 = Util.multiplyExact(n, 2L);
        Apfloat denominator = ApfloatMath.factorial(n2, workingPrecision, radix);
        Apfloat numerator = new Apint(n, radix).multiply(denominator).multiply(ApfloatMath.pow(four.precision(workingPrecision), n));
        Apfloat d = Apfloat.ZERO;
        Apcomplex sum = Apcomplex.ZERO;
        for (long k = n; k > 0L; --k) {
            numerator = numerator.divide(new Apint(n + k, radix));
            d = d.add(numerator.divide(denominator));
            numerator = numerator.divide(four);
            denominator = denominator.multiply(new Apint(n - k + 1L, radix)).divide(new Apint(2L * k, radix)).divide(new Apint(2L * k - 1L, radix));
            sum = sum.add(((k & 1L) == 0L ? d.negate() : d).multiply(ApcomplexMath.pow((Apcomplex)new Apint(k, radix), s.negate())));
        }
        d = d.add(numerator.divide(denominator));
        Apcomplex result = one.divide(d.multiply(one.subtract(ApcomplexMath.pow((Apcomplex)two, one.subtract(s))))).multiply(sum);
        if (s.imag().signum() == 0 && s.real().compareTo(one) > 0 && result.real().compareTo(one) < 0) {
            result = one.precision(workingPrecision);
        }
        return ApfloatHelper.reducePrecision(result, extraPrecision);
    }

    public Apcomplex zetafast(Apcomplex s) {
        this.radix = s.radix();
        s = ApfloatHelper.extendPrecision(s);
        this.workingPrecision = s.precision();
        double t = s.imag().doubleValue();
        this.v = ZetaHelper.findRoot(s, t, this.radix, this.workingPrecision);
        double N = 1.11 * Math.sqrt(1.0 + (0.5 + t) / (double)this.v);
        this.NN = new Apfloat(N, this.workingPrecision, this.radix);
        long M = (long)Math.ceil(N);
        this.one = Apint.ONES[this.radix];
        this.two = new Apint(2L, this.radix);
        this.pi = ApfloatMath.pi(this.workingPrecision, this.radix);
        this.i = new Apcomplex(Apcomplex.ZERO, this.one);
        this.s1 = s.subtract(this.one);
        this.oneS = this.s1.negate();
        this.iTwoPiN = this.i.divide(this.two.multiply(this.pi).multiply(this.NN));
        this.gammaS = ApcomplexMath.gamma(s);
        Apint vv = new Apint(this.v, this.radix);
        Apcomplex result = this.D(N, s).add(this.E1(M, s)).subtract(ApcomplexMath.gamma(this.oneS.add(vv)).divide(this.oneS.multiply(ApcomplexMath.gamma(vv))).multiply(ApcomplexMath.pow((Apcomplex)this.NN, this.oneS)));
        result = ApfloatHelper.reducePrecision(result);
        return result;
    }

    private static long findRoot(Apcomplex s, double t, int radix, long workingPrecision) {
        double p;
        double m = Math.max(1.0 - s.real().doubleValue(), 0.0) / 2.0;
        double x = 0.0;
        do {
            p = x;
        } while (Math.ceil(x = Math.log(8.0) + (double)workingPrecision * Math.log(radix) + m * Math.log(0.5 + x + t)) != Math.ceil(p));
        return (long)Math.ceil(x);
    }

    private Apcomplex D(double N, Apcomplex s) {
        double lambda = 3.151;
        long limit = (long)Math.ceil(lambda * (double)this.v * N);
        Apcomplex sum = Apcomplex.ZERO;
        for (long n = 1L; n <= limit; ++n) {
            Apint nn = new Apint(n, this.radix);
            sum = sum.add(ApcomplexMath.pow((Apcomplex)nn, s.negate()).multiply(this.Q(this.v, nn.divide(this.NN))));
        }
        return sum;
    }

    private Apcomplex Q(long v, Apfloat m) {
        Apfloat numerator;
        Apfloat denominator = numerator = new Apfloat(1L, this.workingPrecision, this.radix);
        Apcomplex sum = Apcomplex.ZERO;
        for (long w = 0L; w < v; ++w) {
            sum = sum.add(numerator.divide(denominator));
            numerator = numerator.multiply(m);
            denominator = denominator.multiply(new Apint(w + 1L, this.radix));
        }
        Apcomplex result = sum.multiply(ApcomplexMath.exp(m.negate()));
        return result;
    }

    private Apcomplex E1(long M, Apcomplex s) {
        Apcomplex sum = Apcomplex.ZERO;
        for (long m = 1L; m <= M; ++m) {
            sum = sum.add(this.E1(new Apint(m, this.radix), s));
        }
        Apcomplex result = ApcomplexMath.pow((Apcomplex)this.two.multiply(this.pi), this.s1).multiply(ApcomplexMath.gamma(this.oneS)).multiply(ApcomplexMath.exp(this.i.multiply(this.pi).divide(this.two).multiply(this.oneS))).multiply(sum);
        return result;
    }

    private Apcomplex E1(Apcomplex m, Apcomplex s) {
        Apcomplex miTwoPiN = m.add(this.iTwoPiN);
        Apcomplex denominator = this.gammaS;
        Apcomplex numerator = denominator.multiply(ApcomplexMath.pow(miTwoPiN, this.s1));
        Apcomplex sum = Apcomplex.ZERO;
        for (long w = 0L; w < this.v; ++w) {
            Apint ww = new Apint(w, this.radix);
            sum = sum.add(numerator.divide(denominator));
            Apint w1 = ww.add(this.one);
            numerator = numerator.multiply(this.iTwoPiN.negate());
            denominator = denominator.multiply(w1).divide(s.subtract(w1)).multiply(miTwoPiN);
        }
        Apcomplex result = ApcomplexMath.pow(m, this.s1).subtract(sum);
        return result;
    }
}

