/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.math.BigInteger;
import org.apfloat.internal.LongBaseMath;
import org.apfloat.internal.LongRadixConstants;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class LongCRTMath
extends LongBaseMath {
    private static final long serialVersionUID = 7400961005627736773L;
    private static final long BASE_MASK = 0x1FFFFFFFFFFFFFFL;
    private static final long[] INVERSE_BASE = new long[37];
    private long base;
    private double inverseBase;
    private transient long inverseBaseLong;

    public LongCRTMath(int radix) {
        super(radix);
        this.base = LongRadixConstants.BASE[radix];
        this.inverseBase = 1.0 / (double)LongRadixConstants.BASE[radix];
        this.inverseBaseLong = INVERSE_BASE[radix];
    }

    public final void multiply(long[] src, long factor, long[] dst) {
        long tmp = src[1] * factor;
        long carry = Math.multiplyHigh(src[1], factor) << 7 | tmp >>> 57;
        dst[2] = tmp & 0x1FFFFFFFFFFFFFFL;
        tmp = src[0] * factor;
        long tmp2 = (tmp & 0x1FFFFFFFFFFFFFFL) + carry;
        carry = (Math.multiplyHigh(src[0], factor) << 7) + (tmp >>> 57) + (tmp2 >>> 57);
        dst[1] = tmp2 & 0x1FFFFFFFFFFFFFFL;
        dst[0] = carry;
    }

    public final long compare(long[] src1, long[] src2) {
        long result = src1[0] - src2[0];
        if (result != 0L) {
            return result;
        }
        result = src1[1] - src2[1];
        if (result != 0L) {
            return result;
        }
        return src1[2] - src2[2];
    }

    public final long add(long[] src, long[] srcDst) {
        long result = srcDst[2] + src[2];
        long carry = result >= 0x200000000000000L ? 1 : 0;
        srcDst[2] = result = result >= 0x200000000000000L ? result - 0x200000000000000L : result;
        result = srcDst[1] + src[1] + carry;
        carry = result >= 0x200000000000000L ? 1 : 0;
        srcDst[1] = result = result >= 0x200000000000000L ? result - 0x200000000000000L : result;
        result = srcDst[0] + src[0] + carry;
        carry = result >= 0x200000000000000L ? 1 : 0;
        srcDst[0] = result = result >= 0x200000000000000L ? result - 0x200000000000000L : result;
        return carry;
    }

    public final void subtract(long[] src, long[] srcDst) {
        long result = srcDst[2] - src[2];
        long carry = result < 0L ? 1 : 0;
        srcDst[2] = result = result < 0L ? result + 0x200000000000000L : result;
        result = srcDst[1] - src[1] - carry;
        carry = result < 0L ? 1 : 0;
        srcDst[1] = result = result < 0L ? result + 0x200000000000000L : result;
        result = srcDst[0] - src[0] - carry;
        srcDst[0] = result = result < 0L ? result + 0x200000000000000L : result;
    }

    public final long divide(long[] srcDst) {
        long tmp = srcDst[0] << 7 | srcDst[1] >> 57;
        long result = Math.multiplyHigh(tmp, this.inverseBaseLong);
        long carry = (srcDst[0] << 57 | srcDst[1]) - result * this.base;
        tmp = Math.multiplyHigh(carry, this.inverseBaseLong) >> 50;
        result += tmp;
        int n = (carry -= tmp * this.base) >= this.base ? 1 : 0;
        long l = carry >= this.base ? this.base : 0L;
        srcDst[0] = 0L;
        srcDst[1] = result += (long)n;
        tmp = (carry -= l) << 7 | srcDst[2] >> 57;
        result = Math.multiplyHigh(tmp, this.inverseBaseLong) + (tmp < 0L ? this.inverseBaseLong : 0L);
        carry = (carry << 57 | srcDst[2]) - result * this.base;
        tmp = Math.multiplyHigh(carry, this.inverseBaseLong) >> 50;
        result += tmp;
        int n2 = (carry -= tmp * this.base) >= this.base ? 1 : 0;
        long l2 = carry >= this.base ? this.base : 0L;
        srcDst[2] = result += (long)n2;
        return carry -= l2;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.inverseBaseLong = INVERSE_BASE[this.radix()];
    }

    static {
        for (int radix = 2; radix <= 36; ++radix) {
            LongCRTMath.INVERSE_BASE[radix] = BigInteger.ONE.shiftLeft(114).divide(BigInteger.valueOf(LongRadixConstants.BASE[radix])).longValueExact();
        }
    }
}

