/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.runtime.tooling;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.IMuleProjectEventListener;
import org.mule.tooling.core.event.resource.FileChangedEvent;
import org.mule.tooling.core.event.resource.FileChangedEventListener;
import org.mule.tooling.core.io.EditingScope;
import org.mule.tooling.core.io.MuleResourceUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.module.ExternalContributionMuleModule;
import org.mule.tooling.core.packageManager.IExportPackageManager;
import org.mule.tooling.core.utils.EclipseContextHelper;
import org.mule.tooling.core.utils.ProjectStructureContributionManager;
import org.mule.tooling.core.utils.ProjectUtils;
import org.mule.tooling.runtime.tooling.ToolingApplicationTypeFile;
import org.mule.tooling.runtime.tooling.ToolingProject;
import org.mule.tooling.runtime.tooling.ToolingProjectFile;
import org.mule.tooling.runtime.tooling.ToolingProjectsCache;
import org.mule.tooling.runtime.tooling.ToolingResourceFile;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.EventBusHelper;
import org.mule.tooling.utils.eventbus.IEventHandler;
import org.mule.tooling.utils.lang.CallableWithArgument;

public class ToolingWorkspace
implements IMuleProjectEventListener,
FileChangedEventListener {
    private static final Set<EditingScope> ALL_SCOPES = new HashSet<EditingScope>();
    private static boolean TOOLING_WORKSPACE_LOG = Boolean.getBoolean("tooling.workspace.log");
    private static final String[] EXCLUSIONS_FOR_DEPENDENCY_RESOURCES = new String[]{"META-INF", "log4j2.xml", "application-types.xml"};
    private final Path toolingWorkspacePath;
    private final ToolingProjectsCache toolingProjectsCache;
    private final Map<File, IMuleProject> toolingProjectFoldersCache;
    private final EventBusHelper eventBusHelper;
    private ExecutorService executorService;

    static {
        ALL_SCOPES.add(EditingScope.APP);
        ALL_SCOPES.add(EditingScope.TEST);
    }

    public static ToolingWorkspace getInstance() {
        ToolingWorkspace fromStudioContext = (ToolingWorkspace)EclipseContextHelper.getFromStudioContext(ToolingWorkspace.class);
        return Optional.ofNullable(fromStudioContext).orElseGet(() -> Singleton.instance);
    }

    public ToolingWorkspace(Path toolingWorkspacePath, ToolingProjectsCache toolingProjectsCache, EventBus eventBus) {
        this.toolingWorkspacePath = toolingWorkspacePath;
        this.toolingProjectsCache = toolingProjectsCache;
        this.toolingProjectFoldersCache = new ConcurrentHashMap<File, IMuleProject>();
        this.clean();
        this.eventBusHelper = new EventBusHelper();
        this.eventBusHelper.registerListener(eventBus, CoreEventTypes.ResourceEvents.ON_MULE_PROJECT_EVENT, (IEventHandler)this);
        this.eventBusHelper.registerListener(eventBus, CoreEventTypes.ResourceEvents.ON_FILE_RESOURCE_CHANGED, (IEventHandler)this);
        this.executorService = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("ToolingWorkspace synchronizer").setDaemon(true).build());
    }

    public void dispose() {
        this.eventBusHelper.unregister();
        this.toolingProjectFoldersCache.clear();
        this.executorService.shutdown();
    }

    public Optional<IMuleProject> getMuleProjectFromToolingFolder(File toolingArtifact) {
        return Optional.ofNullable(this.toolingProjectFoldersCache.get(toolingArtifact));
    }

    public ToolingProject install(IMuleProject muleProject) throws IOException, CoreException {
        EditingScope scope = this.getScope();
        ToolingProject toolingProject = (ToolingProject)this.toolingProjectsCache.runWithToolingArtifact(muleProject, scope, toolingArtifactFile -> {
            Path toolingProjectPath = this.toolingWorkspacePath.resolve(muleProject.getName() + UUID.randomUUID().toString());
            Optional.ofNullable(toolingProjectPath).ifPresent(p -> ToolingWorkspace.deleteOnExit(p.toFile()));
            try {
                long start = System.currentTimeMillis();
                this.copyAppToToolingWorkspace(toolingProjectPath, (File)toolingArtifactFile);
                if (ProjectUtils.shouldResolveDataSenseWithDependencyResources((IMuleProject)muleProject)) {
                    this.copyDependenciesResourcesToToolingWorkspace(toolingProjectPath, ProjectUtils.getDependenciesForExperimentalDataSense((IMuleProject)muleProject));
                }
                ToolingWorkspace.log("Copying project from tooling workspace: " + (System.currentTimeMillis() - start));
                this.toolingProjectFoldersCache.put(toolingProjectPath.toFile(), muleProject);
                return new ToolingProject(muleProject, scope, toolingProjectPath, toolingProjectFile -> {
                    IMuleProject iMuleProject = this.toolingProjectFoldersCache.remove(toolingProjectFile);
                });
            }
            catch (IOException e) {
                throw new CoreException((IStatus)ToolingProjectsCache.getFailureStatus(muleProject, e));
            }
        });
        return toolingProject;
    }

    public ToolingProject heavyweightInstall(IMuleProject muleProject) throws IOException, CoreException {
        EditingScope scope = this.getScope();
        ToolingProject toolingProject = (ToolingProject)this.toolingProjectsCache.runWithToolingArtifact(muleProject, scope, toolingArtifactFile -> {
            Path toolingProjectPath = this.toolingWorkspacePath.resolve(muleProject.getName() + UUID.randomUUID().toString());
            Optional.ofNullable(toolingProjectPath).ifPresent(p -> ToolingWorkspace.deleteOnExit(p.toFile()));
            try {
                long start = System.currentTimeMillis();
                this.copyAppToToolingWorkspace(toolingProjectPath, (File)toolingArtifactFile);
                ToolingWorkspace.log("Copying project from tooling workspace: " + (System.currentTimeMillis() - start));
                this.toolingProjectFoldersCache.put(toolingProjectPath.toFile(), muleProject);
                return new ToolingProject(muleProject, scope, toolingProjectPath, toolingProjectFile -> {
                    IMuleProject iMuleProject = this.toolingProjectFoldersCache.remove(toolingProjectFile);
                });
            }
            catch (IOException e) {
                throw new CoreException((IStatus)ToolingProjectsCache.getFailureStatus(muleProject, e));
            }
        }, false);
        return toolingProject;
    }

    private EditingScope getScope() {
        return EditingScope.getRootScope((EditingScope)EditingScope.getCurrent());
    }

    public void onFileChanged(FileChangedEvent event) {
        event.getMuleProject().ifPresent(muleProject -> this.executorService.execute(() -> {
            if (!event.isInOutputLocation()) {
                IFile file = event.getFile();
                EditingScope scope = EditingScope.getRootScope((EditingScope)ProjectStructureContributionManager.getDefault().getScope((IResource)file));
                Set<EditingScope> scopesToUpdate = this.getScopesToUpdate(scope);
                if (this.shouldRemoveCachedProject(event)) {
                    this.toolingProjectsCache.remove(muleProject.getProject(), scopesToUpdate);
                } else if (this.shouldUpdateCachedProject(event)) {
                    this.updateCachedProject((IMuleProject)muleProject, file, scopesToUpdate);
                }
            }
        }));
    }

    private void updateCachedProject(IMuleProject muleProject, IFile file, Set<EditingScope> scopesToUpdate) {
        try {
            this.toolingProjectsCache.runWithToolingArtifactIfPresent(muleProject, scopesToUpdate, this.getUpdateFunction((IResource)file, muleProject));
        }
        catch (CoreException e) {
            MuleCorePlugin.logProblem((String)("updating the cached project for tooling services for project " + String.valueOf(muleProject)), (Throwable)e);
        }
    }

    private boolean shouldUpdateCachedProject(FileChangedEvent event) {
        IFile file = event.getFile();
        return event.isEventType(FileChangedEvent.ChangeType.CHANGED) && this.isUpdatableFile(file) && file.isAccessible();
    }

    private boolean shouldRemoveCachedProject(FileChangedEvent event) {
        return event.isEventType(FileChangedEvent.ChangeType.CREATED) || event.isEventType(FileChangedEvent.ChangeType.DELETED) || event.isEventType(FileChangedEvent.ChangeType.CHANGED) && !MuleResourceUtils.isDesignInfoFile((IResource)event.getFile()) && !this.isUpdatableFile(event.getFile());
    }

    private boolean isUpdatableFile(IFile file) {
        return MuleResourceUtils.isConfigFile((IResource)file) || MuleResourceUtils.isApplicationTypesFile((IResource)file) || MuleResourceUtils.isResource((IResource)file);
    }

    private CallableWithArgument<File, Void, CoreException> getUpdateFunction(IResource resource, IMuleProject muleProject) {
        CallableWithArgument updateFunction = null;
        if (MuleResourceUtils.isConfigFile((IResource)resource)) {
            updateFunction = toolingProjectFolder -> {
                try {
                    this.updateConfigFile(muleProject, (File)toolingProjectFolder, (IFile)resource);
                }
                catch (Exception e) {
                    MuleCorePlugin.logProblem((String)("updating the cached tooling project for " + String.valueOf(muleProject) + ". Removing from cache."), (Throwable)e);
                    this.removeCached(resource.getProject());
                }
                return null;
            };
        } else if (MuleResourceUtils.isApplicationTypesFile((IResource)resource)) {
            updateFunction = toolingProjectFolder -> {
                try {
                    this.updateApplicationType(muleProject, (File)toolingProjectFolder, (IFile)resource);
                }
                catch (Exception e) {
                    MuleCorePlugin.logProblem((String)("updating the cached tooling project for " + String.valueOf(muleProject) + ". Removing from cache."), (Throwable)e);
                    this.removeCached(resource.getProject());
                }
                return null;
            };
        } else if (MuleResourceUtils.isResource((IResource)resource)) {
            updateFunction = toolingProjectFolder -> {
                try {
                    this.updateResource(muleProject, (File)toolingProjectFolder, (IFile)resource);
                }
                catch (Exception e) {
                    MuleCorePlugin.logProblem((String)("updating the cached tooling project for " + String.valueOf(muleProject) + ". Removing from cache."), (Throwable)e);
                    this.removeCached(resource.getProject());
                }
                return null;
            };
        } else {
            throw new IllegalStateException("should have been able to define a return value if isUpdatableFile() returned true");
        }
        return updateFunction;
    }

    private Set<EditingScope> getScopesToUpdate(EditingScope scope) {
        if (EditingScope.APP.equals(scope)) {
            return ALL_SCOPES;
        }
        return Collections.singleton(scope);
    }

    public void onMuleProjectClosed(IProject project) {
        this.removeCached(project);
    }

    public void onMuleProjectOpened(IProject project) {
    }

    private void copyAppToToolingWorkspace(Path pathToTempToolingPath, File packageZipFile) throws IOException {
        long start = System.currentTimeMillis();
        if (Files.exists(pathToTempToolingPath, new LinkOption[0])) {
            ToolingWorkspace.log("Deleting: " + String.valueOf(pathToTempToolingPath));
            FileUtils.cleanDirectory((File)pathToTempToolingPath.toFile());
        } else {
            Files.createDirectories(pathToTempToolingPath, new FileAttribute[0]);
        }
        FileUtils.copyDirectory((File)packageZipFile, (File)pathToTempToolingPath.toFile());
        ToolingWorkspace.log("Copying base project from tooling workspace: " + (System.currentTimeMillis() - start));
    }

    private void copyDependenciesResourcesToToolingWorkspace(Path toolingWorkspacePath, List<ExternalContributionMuleModule> externalModules) throws IOException {
        long start = System.currentTimeMillis();
        boolean shouldLogWarning = false;
        for (ExternalContributionMuleModule module : externalModules) {
            Throwable throwable = null;
            Object var9_9 = null;
            try (ZipFile jarFile = new ZipFile(module.getContributionJarFile());){
                shouldLogWarning = this.copyResourcesFromZipFile(jarFile, toolingWorkspacePath) || shouldLogWarning;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        if (shouldLogWarning) {
            MuleCorePlugin.logWarning((String)"One or more modules have resources with the same name, DataSense metadata resolution could be inaccurate.");
        }
        ToolingWorkspace.log("Copying project dependencies resources from tooling workspace: " + (System.currentTimeMillis() - start));
    }

    private boolean copyResourcesFromZipFile(ZipFile zipFile, Path destPath) throws IOException {
        boolean duplicatesFound = false;
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            Path tempPathToEntry = Paths.get(destPath.toString(), entry.getName());
            if (!this.shouldEntryBeCopied(entry.getName())) continue;
            if (Files.notExists(tempPathToEntry, new LinkOption[0])) {
                if (entry.isDirectory()) {
                    Files.createDirectories(tempPathToEntry, new FileAttribute[0]);
                    continue;
                }
                Files.copy(zipFile.getInputStream(entry), tempPathToEntry, new CopyOption[0]);
                continue;
            }
            duplicatesFound = true;
        }
        return duplicatesFound;
    }

    private boolean shouldEntryBeCopied(String name) {
        return !Arrays.stream(EXCLUSIONS_FOR_DEPENDENCY_RESOURCES).anyMatch(name::contains);
    }

    private void updateConfigFile(IMuleProject muleProject, File toolingProjectFolder, IFile resource) throws IOException, CoreException {
        block11: {
            try {
                ToolingProject toolingProject = new ToolingProject(muleProject, Paths.get(toolingProjectFolder.toURI()));
                Optional<ToolingProjectFile> maybeToolingProjectFile = toolingProject.getProjectFile(muleProject.getConfigurationsCache().getConfiguration(resource));
                if (!maybeToolingProjectFile.isPresent()) break block11;
                ToolingProjectFile toolingProjectFile = maybeToolingProjectFile.get();
                Throwable throwable = null;
                Object var8_10 = null;
                try (InputStream newContents = resource.getContents();){
                    String newContentsString = IOUtils.readLines((InputStream)newContents).stream().collect(Collectors.joining(System.lineSeparator()));
                    toolingProjectFile.saveContents(newContentsString);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new CoreException((IStatus)ToolingProjectsCache.getFailureStatus(muleProject, e));
            }
        }
    }

    private void updateResource(IMuleProject muleProject, File toolingProjectFolder, IFile resource) throws Exception {
        block11: {
            try {
                ToolingProject toolingProject = new ToolingProject(muleProject, Paths.get(toolingProjectFolder.toURI()));
                Optional<ToolingResourceFile> toolingResourceFile = toolingProject.getResourceFile(resource);
                if (!toolingResourceFile.isPresent()) break block11;
                Throwable throwable = null;
                Object var7_9 = null;
                try (InputStream newContents = resource.getContents();){
                    toolingResourceFile.get().saveContents(newContents);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new CoreException((IStatus)ToolingProjectsCache.getFailureStatus(muleProject, e));
            }
        }
    }

    private void updateApplicationType(IMuleProject muleProject, File toolingProjectFolder, IFile resource) throws Exception {
        try {
            ToolingProject toolingProject = new ToolingProject(muleProject, Paths.get(toolingProjectFolder.toURI()));
            ToolingApplicationTypeFile toolingApplicationTypeFile = toolingProject.getApplicationTypeFile();
            Throwable throwable = null;
            Object var7_9 = null;
            try (InputStream newContents = resource.getContents();){
                String newContentsString = IOUtils.readLines((InputStream)newContents).stream().collect(Collectors.joining(System.lineSeparator()));
                toolingApplicationTypeFile.saveContents(newContentsString);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)ToolingProjectsCache.getFailureStatus(muleProject, e));
        }
    }

    private void removeCached(IProject project) {
        this.toolingProjectsCache.remove(project, ALL_SCOPES);
        HashSet<File> keys = new HashSet<File>();
        for (Map.Entry<File, IMuleProject> entry : this.toolingProjectFoldersCache.entrySet()) {
            if (!Objects.equals(project.getName(), entry.getValue().getName())) continue;
            keys.add(entry.getKey());
        }
        for (File file : keys) {
            this.toolingProjectFoldersCache.remove(file);
        }
    }

    static void log(String string) {
        if (TOOLING_WORKSPACE_LOG) {
            MuleCorePlugin.logInfo((String)string);
        }
    }

    private void clean() {
        try {
            if (Files.exists(this.toolingWorkspacePath, new LinkOption[0])) {
                FileUtils.cleanDirectory((File)this.toolingWorkspacePath.toFile());
            }
        }
        catch (IOException e) {
            MuleCorePlugin.logError((String)"Error cleaning tooling workspace area", (Throwable)e);
        }
    }

    static void deleteOnExit(File file) {
        file.deleteOnExit();
        if (file.isDirectory()) {
            File[] files;
            File[] fileArray = files = file.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                ToolingWorkspace.deleteOnExit(f);
                ++n2;
            }
        }
    }

    public void awaitTermination(int seconds) throws InterruptedException {
        this.executorService.awaitTermination(seconds, TimeUnit.SECONDS);
    }

    private static class Singleton {
        private static final String TOOLING_WORKSPACE_FOLDER = ".tooling";
        private static final String APPS_CACHE_FOLDER = ".tooling-apps-cache";
        private static final ToolingWorkspace instance = Singleton.createDefault();

        private Singleton() {
        }

        private static ToolingWorkspace createDefault() {
            Path workspacePath = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile().toPath();
            Path resolve = workspacePath.resolve(APPS_CACHE_FOLDER);
            MuleCorePlugin.getLog().log((IStatus)new Status(1, "org.mule.tooling.core", "Tooling workspace is " + resolve.toAbsolutePath().toString()));
            ToolingProjectsCache cache = new ToolingProjectsCache(resolve, IExportPackageManager.get());
            Path toolingWorkspacePath = workspacePath.resolve(TOOLING_WORKSPACE_FOLDER);
            toolingWorkspacePath.toFile().deleteOnExit();
            return new ToolingWorkspace(toolingWorkspacePath, cache, MuleCorePlugin.getEventBus());
        }
    }
}

