/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.runtime.tooling;

import java.io.File;
import java.io.IOException;
import java.io.PipedOutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.deployer.DefaultPackagingRequest;
import org.mule.tooling.core.deployer.PackagingRequest;
import org.mule.tooling.core.io.EditingScope;
import org.mule.tooling.core.io.MuleResourceUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.packageManager.IExportPackageManager;
import org.mule.tooling.core.packageManager.MuleExportStatus;
import org.mule.tooling.maven.export.MavenExportManager;
import org.mule.tooling.maven.runner.MavenExecutionException;
import org.mule.tooling.runtime.tooling.ToolingWorkspace;
import org.mule.tooling.utils.lang.CallableWithArgument;

public class ToolingProjectsCache {
    private static final String PACKAGE_FAILED_MESSAGE = "Cannot package application \"{0}\" for interacting with Mule''s tooling APIs";
    private final Path toolingAppsCachePath;
    private final IExportPackageManager exportPackageManager;
    private final Map<ToolingProjectCacheKey, File> cache = new HashMap<ToolingProjectCacheKey, File>();

    public ToolingProjectsCache(Path toolingAppsCachePath, IExportPackageManager exportPackageManager) {
        this.toolingAppsCachePath = toolingAppsCachePath;
        this.exportPackageManager = exportPackageManager;
        this.clean();
        toolingAppsCachePath.toFile().deleteOnExit();
    }

    public synchronized void remove(IProject project, Set<EditingScope> scopes) {
        List<ToolingProjectCacheKey> keysToRemove = this.cache.keySet().stream().filter(key -> key.getMuleProject().getProject().equals((Object)project) && scopes.contains(key.getScope())).collect(Collectors.toList());
        keysToRemove.forEach(this::remove);
    }

    private void remove(ToolingProjectCacheKey key) {
        File projectCacheFolder = this.cache.remove(key);
        if (projectCacheFolder != null) {
            ToolingWorkspace.log("Removing cached tooling project " + String.valueOf(key.getMuleProject()));
            FileUtils.deleteQuietly((File)projectCacheFolder);
        }
    }

    public synchronized Collection<IMuleProject> getCachedProjects() {
        return this.cache.keySet().stream().map(ToolingProjectCacheKey::getMuleProject).collect(Collectors.toList());
    }

    public synchronized void runWithToolingArtifactIfPresent(IMuleProject muleProject, Set<EditingScope> scopes, CallableWithArgument<File, Void, CoreException> callableWithArgument) throws CoreException {
        for (EditingScope scope : scopes) {
            ToolingProjectCacheKey key = ToolingProjectCacheKey.create(muleProject, scope);
            if (!this.cache.containsKey(key)) continue;
            File file = this.cache.get(key);
            callableWithArgument.call((Object)file);
        }
    }

    public synchronized <T> T runWithToolingArtifact(IMuleProject muleProject, EditingScope scope, CallableWithArgument<File, T, CoreException> callable) throws CoreException {
        return this.runWithToolingArtifact(muleProject, scope, callable, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized <T> T runWithToolingArtifact(IMuleProject muleProject, EditingScope scope, CallableWithArgument<File, T, CoreException> callable, boolean asLightWeight) throws CoreException {
        File cachedAppFolder = null;
        ToolingProjectCacheKey key = ToolingProjectCacheKey.create(muleProject, scope);
        cachedAppFolder = this.cache.get(key);
        if (cachedAppFolder == null || !cachedAppFolder.exists()) {
            cachedAppFolder = this.packageAndExpand(muleProject, scope, asLightWeight);
            if (cachedAppFolder == null) throw new CoreException((IStatus)ToolingProjectsCache.getFailureStatus(muleProject));
            this.cache.put(key, cachedAppFolder);
            return (T)callable.call((Object)cachedAppFolder);
        }
        ToolingWorkspace.log("Using cached tooling app for project " + String.valueOf(muleProject));
        try {
            MavenExportManager.installDomainProjectIfNecessary((IMuleProject)muleProject, (PipedOutputStream)new PipedOutputStream());
            return (T)callable.call((Object)cachedAppFolder);
        }
        catch (InterruptedException | MavenExecutionException e) {
            throw new CoreException((IStatus)new Status(4, "org.mule.tooling.runtime", "There was a problem installing the domain associated with project " + muleProject.getLabel(), e));
        }
    }

    public File packageAndExpand(IMuleProject muleProject, EditingScope scope, boolean asLightWeight) {
        File file;
        MuleExportStatus exportStatus = null;
        File cachedAppFolder = null;
        File exportFile = null;
        try {
            Path projectCachePath;
            ToolingWorkspace.log("Packaging app to use in tooling workspace: " + String.valueOf(muleProject));
            DefaultPackagingRequest offlinePackagingRequest = this.getOfflinePackagingRequest(muleProject, scope, asLightWeight);
            exportStatus = this.exportPackageManager.export((PackagingRequest)offlinePackagingRequest, null);
            if (!exportStatus.isOk().booleanValue()) {
                DefaultPackagingRequest onlinePackagingRequest = this.getOnlinePackagingRequest(muleProject, scope, asLightWeight);
                exportStatus = this.exportPackageManager.export((PackagingRequest)onlinePackagingRequest, null);
            }
            if (exportStatus.isOk().booleanValue()) {
                exportFile = (File)exportStatus.getExportedProject().get();
                projectCachePath = this.toolingAppsCachePath.resolve(scope.getName()).resolve(muleProject.getName());
                try {
                    MuleResourceUtils.unzip((Path)Paths.get(exportFile.getAbsolutePath(), new String[0]), (Path)projectCachePath);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                throw new RuntimeException(exportStatus.getErrorMessage());
            }
            cachedAppFolder = projectCachePath.toFile();
            file = cachedAppFolder;
            Optional.ofNullable(cachedAppFolder).ifPresent(ToolingWorkspace::deleteOnExit);
        }
        catch (Throwable throwable) {
            Optional.ofNullable(cachedAppFolder).ifPresent(ToolingWorkspace::deleteOnExit);
            FileUtils.deleteQuietly(exportFile);
            throw throwable;
        }
        FileUtils.deleteQuietly((File)exportFile);
        return file;
    }

    protected DefaultPackagingRequest getOnlinePackagingRequest(IMuleProject muleProject, EditingScope scope, boolean asLightWeight) {
        return this.getPackagingRequestBuilder(muleProject, scope, asLightWeight).build();
    }

    protected DefaultPackagingRequest getOfflinePackagingRequest(IMuleProject muleProject, EditingScope scope, boolean asLightWeight) {
        return this.getPackagingRequestBuilder(muleProject, scope, asLightWeight).withOption("maven.export.offline", (Object)true).build();
    }

    private DefaultPackagingRequest.Builder getPackagingRequestBuilder(IMuleProject muleProject, EditingScope scope, boolean asLightWeight) {
        DefaultPackagingRequest.Builder builder = new DefaultPackagingRequest.Builder(muleProject).checkMavenVersion(false).withOption("maven.export.snapshots_update", (Object)false).withOption("maven.export.skip_validation", (Object)true).withOption("maven.export.skip_all_tests", (Object)true).withOption("maven.export.skip_ast", (Object)true);
        if (asLightWeight) {
            builder.asLightWeight();
        }
        if (scope.belongsTo(EditingScope.TEST)) {
            builder = builder.withOption("export.test_jar", (Object)true);
        } else if (scope.belongsTo(EditingScope.APP)) {
            builder = builder.useLocalRepo();
        }
        return builder;
    }

    private void clean() {
        try {
            if (this.toolingAppsCachePath.toFile().exists()) {
                FileUtils.cleanDirectory((File)this.toolingAppsCachePath.toFile());
            }
        }
        catch (IOException e) {
            MuleCorePlugin.logError((String)"Error cleaning tooling workspace area", (Throwable)e);
        }
    }

    public static Status getFailureStatus(IMuleProject muleProject) {
        Throwable exception = new IllegalStateException().fillInStackTrace();
        return ToolingProjectsCache.getFailureStatus(muleProject, exception);
    }

    static Status getFailureStatus(IMuleProject muleProject, Throwable exception) {
        return new Status(4, "org.mule.tooling.runtime", MessageFormat.format(PACKAGE_FAILED_MESSAGE, muleProject.getName()), exception);
    }

    private static class ToolingProjectCacheKey {
        private final IMuleProject muleProject;
        private final EditingScope scope;

        public static ToolingProjectCacheKey create(IMuleProject muleProject, EditingScope scope) {
            return new ToolingProjectCacheKey(muleProject, scope);
        }

        public EditingScope getScope() {
            return this.scope;
        }

        private ToolingProjectCacheKey(IMuleProject muleProject, EditingScope scope) {
            this.muleProject = muleProject;
            this.scope = scope;
        }

        public IMuleProject getMuleProject() {
            return this.muleProject;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.muleProject == null ? 0 : this.muleProject.hashCode());
            result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ToolingProjectCacheKey other = (ToolingProjectCacheKey)obj;
            if (this.muleProject == null ? other.muleProject != null : !this.muleProject.equals(other.muleProject)) {
                return false;
            }
            return !(this.scope == null ? other.scope != null : !this.scope.equals(other.scope));
        }
    }
}

