/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.runtime.tooling;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.mule.tooling.core.cache.IXmlConfigurationProvider;
import org.mule.tooling.core.cache.MuleConfigurationUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.model.messageflow.GlobalElement;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.IReadOnlyPropertyCollection;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.decorator.MuleConfigurationDecorator;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.model.messageflow.path.MulePath;

public class ToolingProjectFile {
    private static final String XML_EXCEPTION_MESSAGE = "There was an error retrieving the current XML configuration for performing a DataSense operation";
    private IMuleProject project;
    private MuleConfiguration muleConfiguration;
    private ToolingInfo toolingInfo;

    private ToolingProjectFile(IMuleProject project, MuleConfiguration muleConfiguration, File destFile, Charset charset, String updatedXmlContent) throws IOException, CoreException {
        this.project = project;
        this.muleConfiguration = muleConfiguration;
        this.toolingInfo = this.initializeToolingInfo(destFile, charset, updatedXmlContent);
    }

    public static Optional<ToolingProjectFile> create(IMuleProject project, MuleConfiguration muleConfiguration, File destFile, Charset charset) throws IOException, CoreException {
        Optional<String> updatedXmlContent = ToolingProjectFile.getCurrentXmlContents(project, muleConfiguration);
        if (updatedXmlContent.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new ToolingProjectFile(project, muleConfiguration, destFile, charset, updatedXmlContent.get()));
    }

    public File getXmlFile() {
        return this.toolingInfo.getXmlFile();
    }

    public IMessageFlowNode saveElement(IMessageFlowNode messageFlowNode, Supplier<IMessageFlowNode> newMessageFlowNodeSupplier, Function<IMessageFlowNode, PropertyCollectionMap> updatedPropertiesProvider) throws Exception {
        IMessageFlowNode currentMessageFlowNode = null;
        String nameProperty = CoreUtils.getNameProperty((IMessageFlowNode)messageFlowNode);
        if (StringUtils.isNotEmpty((String)nameProperty)) {
            MulePath mulePath = new MulePath(nameProperty);
            currentMessageFlowNode = this.findMessageFlowNode(mulePath, this.toolingInfo.getMuleConfiguration());
        }
        if (currentMessageFlowNode == null) {
            currentMessageFlowNode = this.findOrCreateMessageFlowNode(messageFlowNode, newMessageFlowNodeSupplier, this.toolingInfo.getMuleConfiguration());
        }
        PropertyCollectionMap updatedProperties = updatedPropertiesProvider.apply(currentMessageFlowNode);
        this.updateMessageFlowNode(currentMessageFlowNode, updatedProperties);
        this.generateToolingXML();
        return currentMessageFlowNode;
    }

    public void updateElement(MulePath mulePath, PropertyCollectionMap updatedProperties) throws Exception {
        IMessageFlowNode currentMessageFlowNode = this.findMessageFlowNode(mulePath, this.toolingInfo.getMuleConfiguration());
        this.updateMessageFlowNode(currentMessageFlowNode, updatedProperties);
        this.generateToolingXML();
    }

    public void saveContents(String newContents) throws IOException {
        FileUtils.writeStringToFile((File)this.toolingInfo.getXmlFile(), (String)newContents);
    }

    public Optional<MulePath> getPathFor(IMessageFlowEntity messageFlowEntity) {
        Optional<MulePath> maybeMulePath = Optional.ofNullable(this.muleConfiguration.getPathFor(messageFlowEntity));
        return maybeMulePath.isPresent() ? maybeMulePath : Optional.ofNullable(this.toolingInfo.getMuleConfiguration().getPathFor(messageFlowEntity));
    }

    private IMessageFlowNode findMessageFlowNode(MulePath mulePath, MuleConfiguration toolingConfiguration) {
        return (IMessageFlowNode)toolingConfiguration.getEntityFor(mulePath);
    }

    private IMessageFlowNode findOrCreateMessageFlowNode(IMessageFlowNode messageFlowNode, Supplier<IMessageFlowNode> newMessageFlowNodeSupplier, MuleConfiguration toolingConfiguration) {
        MulePath originalMulePath = this.muleConfiguration.getPathFor((IMessageFlowEntity)((MessageFlowEntity)messageFlowNode));
        IMessageFlowNode tempMessageFlowNode = this.findMessageFlowNode(originalMulePath, toolingConfiguration);
        if (tempMessageFlowNode == null && messageFlowNode instanceof GlobalElement) {
            tempMessageFlowNode = newMessageFlowNodeSupplier.get();
            MuleConfigurationDecorator muleConfigurationDecorator = new MuleConfigurationDecorator(toolingConfiguration);
            muleConfigurationDecorator.addGlobal((GlobalElement)tempMessageFlowNode);
        }
        return tempMessageFlowNode;
    }

    private PropertyCollection updateElements(IMessageFlowNode currentElement, PropertyCollectionMap updated) {
        IReadOnlyPropertyCollection oldPropertyCollections = currentElement.getProperties();
        PropertyCollection newPropertyCollections = updated.asPropertyCollection();
        for (PropertyCollection newPropertyCollection : newPropertyCollections.getPropertyCollections()) {
            for (IReadOnlyPropertyCollection oldPropertyCollection : oldPropertyCollections.getPropertyCollections()) {
                String oldPropertyCollectionName = oldPropertyCollection.getName();
                String newPropertyCollectionName = newPropertyCollection.getName();
                if (oldPropertyCollectionName == null || newPropertyCollectionName == null) continue;
                int oldLastIndexOf = oldPropertyCollectionName.lastIndexOf(";");
                int newLastIndexOf = newPropertyCollectionName.lastIndexOf(";");
                if (!(oldPropertyCollectionName = oldPropertyCollectionName.substring(0, oldLastIndexOf != -1 ? oldLastIndexOf : oldPropertyCollectionName.length())).equals(newPropertyCollectionName = newPropertyCollectionName.substring(0, newLastIndexOf != -1 ? newLastIndexOf : newPropertyCollectionName.length()))) continue;
                newPropertyCollection.setElement(oldPropertyCollection.getElement());
            }
        }
        return newPropertyCollections;
    }

    private ToolingInfo initializeToolingInfo(File toolingXMLFile, Charset charset, String updatedXmlContent) throws IOException, CoreException {
        FileUtils.writeStringToFile((File)toolingXMLFile, (String)updatedXmlContent, (String)charset.name());
        String configurationName = this.muleConfiguration.getName();
        IDOMModel domModel = MuleConfigurationUtils.getDomModel((String)updatedXmlContent, (String)configurationName, (Charset)charset);
        MuleConfiguration toolingMuleConfiguration = MuleConfigurationUtils.createTemporaryNewMuleConfiguration((IMuleProject)this.project, (String)configurationName, (IDOMModel)domModel);
        return new ToolingInfo(toolingXMLFile, domModel, toolingMuleConfiguration);
    }

    private static Optional<String> getCurrentXmlContents(IMuleProject project, MuleConfiguration muleConfiguration) throws CoreException {
        try {
            IFile muleConfigurationFile = project.getConfigurationsCache().getConfigurationFile(muleConfiguration);
            if (!muleConfigurationFile.isAccessible()) {
                return Optional.empty();
            }
            IXmlConfigurationProvider xmlProvider = project.getConfigurationsCache().getXmlConfigurationProvider(muleConfigurationFile);
            if (xmlProvider == null) {
                return Optional.empty();
            }
            return Optional.of(xmlProvider.getXml());
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.mule.tooling.runtime", XML_EXCEPTION_MESSAGE, (Throwable)e));
        }
    }

    private void updateMessageFlowNode(IMessageFlowNode currentMessageFlowNode, PropertyCollectionMap updatedProperties) {
        PropertyCollection newPropertyCollections = this.updateElements(currentMessageFlowNode, updatedProperties);
        currentMessageFlowNode.setProperties(newPropertyCollections);
    }

    private void generateToolingXML() throws IOException, CoreException {
        IDOMModel model = this.toolingInfo.getDomModel();
        String content = model.getStructuredDocument().get();
        File xmlFile = this.toolingInfo.getXmlFile();
        FileUtils.writeStringToFile((File)xmlFile, (String)content);
    }

    public MuleConfiguration getMuleConfiguration() {
        return this.muleConfiguration;
    }

    public MuleConfiguration createTemporaryMuleConfiguration() throws CoreException {
        return MuleConfigurationUtils.createTemporaryNewMuleConfiguration((IMuleProject)this.project, (String)this.project.getName(), (IDOMModel)this.toolingInfo.getDomModel());
    }

    private static class ToolingInfo {
        private File xmlFile;
        private IDOMModel model;
        private MuleConfiguration muleConfiguration;

        public ToolingInfo(File xmlFile, IDOMModel domModel, MuleConfiguration muleConfiguration) {
            this.xmlFile = xmlFile;
            this.model = domModel;
            this.muleConfiguration = muleConfiguration;
        }

        public File getXmlFile() {
            return this.xmlFile;
        }

        public IDOMModel getDomModel() {
            return this.model;
        }

        public MuleConfiguration getMuleConfiguration() {
            return this.muleConfiguration;
        }
    }
}

