/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.runtime.tooling;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.jobs.Job;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.ToolingJobsManager;
import org.mule.tooling.core.io.EditingScope;
import org.mule.tooling.core.io.IMuleResources;
import org.mule.tooling.core.io.MuleResourceUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.runtime.tooling.ToolingApplicationTypeFile;
import org.mule.tooling.runtime.tooling.ToolingProjectFile;
import org.mule.tooling.runtime.tooling.ToolingResourceFile;

public class ToolingProject
implements AutoCloseable {
    private Path path;
    private IMuleProject muleProject;
    private Map<MuleConfiguration, ToolingProjectFile> files;
    private static final boolean PRESERVE_TOOLING_PROJECT = Boolean.getBoolean("tooling.project.preserve");
    private Consumer<File> onCloseCallback;
    private EditingScope scope;

    public IMuleProject getProject() {
        return this.muleProject;
    }

    public Path getPath() {
        return this.path;
    }

    public EditingScope getScope() {
        return this.scope;
    }

    public ToolingProject(IMuleProject project, Path path) throws IOException, CoreException {
        this(project, EditingScope.APP, path, Function.identity()::apply);
    }

    public ToolingProject(IMuleProject project, EditingScope scope, Path path, Consumer<File> onCloseCallback) throws IOException, CoreException {
        this.path = path;
        this.scope = scope;
        this.muleProject = project;
        this.files = new HashMap<MuleConfiguration, ToolingProjectFile>();
        this.onCloseCallback = onCloseCallback;
        this.updateOpenFiles();
    }

    public ToolingApplicationTypeFile getApplicationTypeFile() {
        return new ToolingApplicationTypeFile(this.path.resolve("application-types.xml"));
    }

    public Optional<ToolingResourceFile> getResourceFile(IFile file) throws IOException, CoreException {
        IPath muleResourcesFolderPath = IMuleResources.MULE_RESOURCES_FOLDER_PATH;
        IPath projectRelativePath = file.getProjectRelativePath();
        if (muleResourcesFolderPath.isPrefixOf(projectRelativePath)) {
            Path relativizedPathToFile = projectRelativePath.makeRelativeTo(muleResourcesFolderPath).toFile().toPath();
            return Optional.of(new ToolingResourceFile(this.path.resolve(relativizedPathToFile)));
        }
        return Optional.empty();
    }

    public Optional<ToolingProjectFile> getProjectFile(MuleConfiguration muleConfiguration) throws IOException, CoreException {
        if (!this.files.containsKey(muleConfiguration)) {
            this.initializeProjectFile(muleConfiguration);
        }
        return Optional.ofNullable(this.files.get(muleConfiguration));
    }

    private void initializeProjectFile(MuleConfiguration muleConfiguration) throws IOException, CoreException {
        Optional<File> destXmlFile = this.resolveDestinationXmlFile(muleConfiguration);
        if (destXmlFile.isPresent() && this.muleProject.isAccessible()) {
            Optional<ToolingProjectFile> toolingFile = ToolingProjectFile.create(this.muleProject, muleConfiguration, destXmlFile.get(), this.getCharset(muleConfiguration));
            toolingFile.ifPresent(f -> {
                ToolingProjectFile toolingProjectFile = this.files.put(muleConfiguration, (ToolingProjectFile)f);
            });
        }
    }

    private Charset getCharset(MuleConfiguration muleConfiguration) {
        IFile configurationFile = this.muleProject.getConfigurationsCache().getConfigurationFile(muleConfiguration);
        if (configurationFile != null) {
            return MuleResourceUtils.getCharset((IFile)configurationFile);
        }
        return IMuleResources.DEFAULT_CHARSET;
    }

    private void updateOpenFiles() throws IOException, CoreException {
        List notSavedConfigurations = this.muleProject.getConfigurationsCache().getNotSavedConfigurations();
        for (MuleConfiguration muleConfiguration : notSavedConfigurations) {
            this.initializeProjectFile(muleConfiguration);
        }
    }

    private Optional<File> resolveDestinationXmlFile(MuleConfiguration muleConfiguration) {
        IFile configurationFile = this.muleProject.getConfigurationsCache().getConfigurationFile(muleConfiguration);
        if (configurationFile == null) {
            return Optional.empty();
        }
        return MuleResourceUtils.getConfigurationFileInDeploymentFolder((IResource)configurationFile, (File)this.path.toFile(), (IMuleProject)this.muleProject);
    }

    @Override
    public void close() {
        Job job = Job.create((String)"Closing tooling project", monitor -> {
            try {
                try {
                    this.files.clear();
                    if (!PRESERVE_TOOLING_PROJECT && Files.exists(this.path, new LinkOption[0])) {
                        FileUtils.deleteDirectory((File)this.path.toFile());
                    }
                    this.onCloseCallback.accept(this.path.toFile());
                }
                catch (IOException e) {
                    MuleCorePlugin.logWarning((String)("Cannot delete tooling application " + String.valueOf(this.path)), (Throwable)e);
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
        });
        job.setJobGroup(ToolingJobsManager.getDisposeJobGroup());
        job.schedule();
    }
}

