/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.runtime.service;

import com.google.gson.Gson;
import jakarta.inject.Inject;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.mule.tooling.core.net.ConnectionManager;
import org.mule.tooling.core.utils.EclipseContextHelper;
import org.mule.tooling.runtime.service.ApplicationInfo;
import org.mule.tooling.runtime.service.AuthorizationHeaderFilter;
import org.mule.tooling.runtime.service.DomainInfo;

public class MuleAgentServices {
    private static final String BASE_URL_FORMAT = "http://" + InetAddress.getLoopbackAddress().getHostAddress() + ":{0}/mule";
    private static Map<String, MuleAgentServices> instances = new HashMap<String, MuleAgentServices>();
    private WebTarget tooling;
    private WebTarget isAlive;
    private WebTarget stopRuntime;
    private WebTarget applications;
    private WebTarget domains;

    public static MuleAgentServices getInstance(int agentPort, String tokenAuth) {
        String url = MuleAgentServices.urlForPort(agentPort);
        return instances.computeIfAbsent(url, agentUrl -> Builder.create().withUrl((String)agentUrl).withToken(tokenAuth).build());
    }

    public static void release(int agentPort) {
        String url = MuleAgentServices.urlForPort(agentPort);
        instances.remove(url);
    }

    private static String urlForPort(int agentPort) {
        return MessageFormat.format(BASE_URL_FORMAT, Integer.toString(agentPort));
    }

    private MuleAgentServices(ConnectionManager connectionManager, String baseUrl, String token) {
        Client client = connectionManager.createJerseyClientForUri(URI.create(baseUrl));
        client.property("jersey.config.client.readTimeout", (Object)1000);
        client.property("jersey.config.client.connectTimeout", (Object)1000);
        client.register((Object)new AuthorizationHeaderFilter(token));
        WebTarget baseResource = client.target(baseUrl);
        this.tooling = baseResource.path("tooling");
        this.applications = baseResource.path("applications");
        this.domains = baseResource.path("domains");
        WebTarget studio = baseResource.path("studio");
        this.isAlive = studio.path("runtime/alive");
        this.stopRuntime = studio.path("runtime/stop");
    }

    public boolean isAlive() {
        try {
            Response clientResponse = this.isAlive.request().get();
            int status = clientResponse.getStatus();
            clientResponse.close();
            return status == Response.Status.OK.getStatusCode();
        }
        catch (ProcessingException processingException) {
            return false;
        }
    }

    public boolean stopRuntime() {
        try {
            int status = this.stopRuntime.request().post(null).getStatus();
            return status == Response.Status.OK.getStatusCode();
        }
        catch (ProcessingException processingException) {
            return true;
        }
    }

    public boolean isToolingUp() {
        try {
            Response clientResponse = this.tooling.request().get();
            clientResponse.close();
            return true;
        }
        catch (Exception e) {
            if (e.getCause() instanceof ConnectException || e.getCause() instanceof SocketTimeoutException) {
                return false;
            }
            throw e;
        }
    }

    public List<ApplicationInfo> listApplications() {
        String response;
        try {
            response = (String)this.applications.request().header("Content-type", (Object)"application/json").get(String.class);
        }
        catch (WebApplicationException e) {
            if (e.getResponse().getStatus() == 204) {
                return Collections.emptyList();
            }
            throw e;
        }
        catch (ProcessingException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ConnectException && cause.getMessage().contains("Connection refused")) {
                return Collections.emptyList();
            }
            throw e;
        }
        List appList = this.artifactInfofromJson(response);
        ArrayList<ApplicationInfo> result = new ArrayList<ApplicationInfo>(appList.size());
        for (Map<String, String> map : appList) {
            result.add(ApplicationInfo.create(map));
        }
        return result;
    }

    public List<DomainInfo> listDomains() {
        String response;
        try {
            response = (String)this.domains.request().header("Content-type", (Object)"application/json").get(String.class);
        }
        catch (WebApplicationException e) {
            if (e.getResponse().getStatus() == 204) {
                return Collections.emptyList();
            }
            throw e;
        }
        catch (ProcessingException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ConnectException && cause.getMessage().contains("Connection refused")) {
                return Collections.emptyList();
            }
            throw e;
        }
        List artifactList = this.artifactInfofromJson(response);
        return artifactList.stream().map(DomainInfo::create).collect(Collectors.toList());
    }

    private <V> List<Map<String, V>> artifactInfofromJson(String json) {
        Gson gson = new Gson();
        return (List)gson.fromJson(json, List.class);
    }

    public static class Builder {
        @Inject
        private ConnectionManager connectionManager;
        private String url;
        private String authToken;

        public Builder withUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder withToken(String token) {
            this.authToken = token;
            return this;
        }

        public MuleAgentServices build() {
            return new MuleAgentServices(this.connectionManager, this.url, this.authToken);
        }

        public static Builder create() {
            return (Builder)EclipseContextHelper.createFromStudioContext(Builder.class);
        }
    }
}

