/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.runtime.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.mule.tooling.runtime.service.ApplicationInfo;

public class DomainInfo {
    public static final String PARAM_NAME = "name";
    public static final String PARAM_APPLICATIONS = "applications";
    private String name;
    private List<ApplicationInfo> applicationsInDomain;

    public DomainInfo(String domainName, List<ApplicationInfo> applicationsInDomain) {
        this.name = domainName;
        this.applicationsInDomain = applicationsInDomain;
    }

    public static DomainInfo create(Map<String, Object> domainJsonMap) {
        String domainName = (String)domainJsonMap.get(PARAM_NAME);
        ArrayList applicationsStringArray = (ArrayList)domainJsonMap.get(PARAM_APPLICATIONS);
        ArrayList<ApplicationInfo> apps = new ArrayList<ApplicationInfo>(applicationsStringArray.size());
        for (Map appInfo : applicationsStringArray) {
            apps.add(ApplicationInfo.create(appInfo));
        }
        return new DomainInfo(domainName, apps);
    }

    public String getName() {
        return this.name;
    }

    public List<ApplicationInfo> getApplicationsInDomain() {
        return this.applicationsInDomain;
    }

    public String toString() {
        StringBuilder toStringBuffer = new StringBuilder("[Domain Name: " + this.getName() + " - Applications: ");
        if (this.applicationsInDomain == null || this.applicationsInDomain.size() == 0) {
            toStringBuffer.append("None");
        } else {
            for (ApplicationInfo appInfo : this.applicationsInDomain) {
                toStringBuffer.append(appInfo.toString());
                toStringBuffer.append(", ");
            }
        }
        toStringBuffer.append("]");
        return toStringBuffer.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.applicationsInDomain == null ? 0 : this.applicationsInDomain.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DomainInfo other = (DomainInfo)obj;
        if (this.applicationsInDomain == null ? other.applicationsInDomain != null : !this.applicationsInDomain.equals(other.applicationsInDomain)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

