/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.runtime.service;

import java.util.Map;
import org.mule.tooling.runtime.service.ApplicationState;

public class ApplicationInfo {
    public static final String PARAM_NAME = "name";
    public static final String PARAM_DOMAIN = "domain";
    public static final String PARAM_STATE = "state";
    private final String name;
    private final ApplicationState state;
    private final String domain;

    public ApplicationInfo(String name, String domain, ApplicationState state) {
        this.name = name;
        this.domain = domain;
        this.state = state;
    }

    public static ApplicationInfo create(Map<String, String> params) {
        String name = params.get(PARAM_NAME);
        ApplicationState state = ApplicationState.valueOf(params.get(PARAM_STATE));
        String domain = params.get(PARAM_DOMAIN);
        return new ApplicationInfo(name, domain, state);
    }

    public String getName() {
        return this.name;
    }

    public ApplicationState getState() {
        return this.state;
    }

    public String getDomainName() {
        return this.domain;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.domain == null ? 0 : this.domain.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApplicationInfo other = (ApplicationInfo)obj;
        if (this.domain == null ? other.domain != null : !this.domain.equals(other.domain)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.state == other.state;
    }

    public String toString() {
        return "[Application Name: " + this.getName() + " - App Status: " + String.valueOf((Object)this.getState()) + " - App Domain: " + this.getDomainName() + "]";
    }
}

