/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.runtime.launch.termination;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import org.mule.tooling.runtime.launch.termination.CompositeTerminationCommand;
import org.mule.tooling.runtime.launch.termination.TerminationCommand;

public class TerminationCommandBuilder {
    private Callable<Boolean> runtimeChecker;
    private final List<TerminationCommand> commands = new ArrayList<TerminationCommand>();

    public TerminationCommandBuilder with(TerminationCommand ... newCommands) {
        this.commands.addAll(Arrays.asList(newCommands));
        return this;
    }

    public TerminationCommand build() {
        Preconditions.checkState((this.runtimeChecker != null ? 1 : 0) != 0, (Object)"There is not runtime checker assigned");
        Preconditions.checkState((!this.commands.isEmpty() ? 1 : 0) != 0, (Object)"No termination command");
        TerminationCommand result = this.commands.size() == 1 ? this.commands.iterator().next() : new CompositeTerminationCommand(this.commands);
        result.setRuntimeChecker(this.runtimeChecker);
        return result;
    }

    public TerminationCommandBuilder watching(Callable<Boolean> runtimeChecker) {
        this.runtimeChecker = runtimeChecker;
        return this;
    }
}

