/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.runtime.launch.termination;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.mule.tooling.runtime.MuleRuntimePlugin;
import org.mule.tooling.runtime.launch.termination.BaseTerminationCommand;
import org.mule.tooling.runtime.launch.termination.TerminationCommand;

public abstract class ShellTerminationCommand
extends BaseTerminationCommand {
    private static final int MAX_WAIT_MILLIS = 5000;
    private static final int SUCCESS_STATUS = 0;

    @Override
    protected TerminationCommand.TerminationStatus doExecute() {
        block5: {
            try {
                List<String> terminationCommand = this.getTerminationCommand();
                if (terminationCommand.isEmpty()) break block5;
                MuleRuntimePlugin.logInfo("Starting shell termination command \"" + String.valueOf(terminationCommand) + "\"");
                Process terminationProcess = new ProcessBuilder(terminationCommand).redirectError(ProcessBuilder.Redirect.INHERIT).redirectOutput(ProcessBuilder.Redirect.INHERIT).start();
                MuleRuntimePlugin.logInfo("Finished shell termination command \"" + String.valueOf(terminationCommand) + "\"");
                boolean exited = false;
                try {
                    exited = terminationProcess.waitFor(5000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {}
                if (!exited || terminationProcess.exitValue() != 0) {
                    terminationProcess.destroyForcibly();
                    return TerminationCommand.TerminationStatus.RETRY;
                }
            }
            catch (IOException iOException) {
                return TerminationCommand.TerminationStatus.RETRY;
            }
        }
        return TerminationCommand.TerminationStatus.DONE;
    }

    protected abstract List<String> getTerminationCommand() throws IOException;

    public String toString() {
        List<Object> command = Collections.emptyList();
        try {
            command = this.getTerminationCommand();
        }
        catch (IOException iOException) {}
        return "ShellTerminationCommand [getTerminationCommand()=" + String.valueOf(command) + "]";
    }
}

