/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.runtime.launch.termination;

import java.util.concurrent.Callable;
import org.mule.tooling.runtime.launch.termination.BaseTerminationCommand;
import org.mule.tooling.runtime.launch.termination.TerminationCommand;

public class RetryWithDelayTimes
extends BaseTerminationCommand {
    private final TerminationCommand command;
    private final int maxTimes;
    private final int delayMillis;

    public RetryWithDelayTimes(TerminationCommand command, int times, int delayMillis) {
        this.command = command;
        this.maxTimes = times;
        this.delayMillis = delayMillis;
    }

    @Override
    public void setRuntimeChecker(Callable<Boolean> runtimeChecker) {
        super.setRuntimeChecker(runtimeChecker);
        this.command.setRuntimeChecker(runtimeChecker);
    }

    @Override
    protected TerminationCommand.TerminationStatus doExecute() {
        int i = 0;
        while (i < this.maxTimes) {
            if (!this.isRuntimeAlive()) break;
            TerminationCommand.TerminationStatus status = this.command.execute();
            if (TerminationCommand.TerminationStatus.RETRY.equals((Object)status)) {
                try {
                    Thread.sleep(this.delayMillis);
                }
                catch (InterruptedException interruptedException) {}
            }
            ++i;
        }
        return TerminationCommand.TerminationStatus.DONE;
    }

    public String toString() {
        return "RetryWithDelayTimes [command=" + String.valueOf(this.command) + ", maxTimes=" + this.maxTimes + ", delayMillis=" + this.delayMillis + "]";
    }
}

