/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.runtime.launch.termination;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.SystemUtils;
import org.mule.tooling.runtime.launch.termination.ShellTerminationCommand;

public class KillProcessCommand
extends ShellTerminationCommand {
    private final Path pidFile;

    public KillProcessCommand(Path pidFile) {
        this.pidFile = pidFile;
    }

    @Override
    protected List<String> getTerminationCommand() throws IOException {
        List<String> mainCommandList;
        block12: {
            mainCommandList = new ArrayList<String>();
            if (Files.exists(this.pidFile, new LinkOption[0])) {
                Throwable throwable = null;
                Object var3_4 = null;
                try (InputStream is = Files.newInputStream(this.pidFile, new OpenOption[0]);){
                    String pid = IOUtils.toString((InputStream)is).trim();
                    if (SystemUtils.IS_OS_WINDOWS) {
                        mainCommandList = Arrays.asList("taskkill", "/F", "/PID", pid);
                        break block12;
                    }
                    if (SystemUtils.IS_OS_MAC || SystemUtils.IS_OS_LINUX) {
                        mainCommandList = Arrays.asList("kill", "-9", pid);
                        break block12;
                    }
                    throw new RuntimeException("Not able to find the proper process termination command for this OS");
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
        return mainCommandList;
    }
}

