/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.runtime.launch.termination;

import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.mule.tooling.runtime.MuleRuntimePlugin;
import org.mule.tooling.runtime.launch.termination.BaseTerminationCommand;
import org.mule.tooling.runtime.launch.termination.TerminationCommand;

public class CompositeTerminationCommand
extends BaseTerminationCommand {
    private final List<TerminationCommand> commands;

    public CompositeTerminationCommand(List<TerminationCommand> commands) {
        this.commands = commands;
    }

    @Override
    public void setRuntimeChecker(Callable<Boolean> runtimeChecker) {
        super.setRuntimeChecker(runtimeChecker);
        this.commands.forEach(command -> command.setRuntimeChecker(runtimeChecker));
    }

    @Override
    protected TerminationCommand.TerminationStatus doExecute() {
        for (TerminationCommand command : this.commands) {
            try {
                TerminationCommand.TerminationStatus status = command.execute();
                if (!this.isRuntimeAlive()) break;
                if (!TerminationCommand.TerminationStatus.RETRY.equals((Object)status)) continue;
                MuleRuntimePlugin.getDefault().getLog().log((IStatus)new Status(2, "org.mule.tooling.runtime", "Termination command " + String.valueOf(command) + " indicate retry action is necessary, moving on to next one"));
            }
            catch (Exception e) {
                MuleRuntimePlugin.getDefault().getLog().log((IStatus)new Status(2, "org.mule.tooling.runtime", "There was an error while terminating runtime with " + String.valueOf(command), (Throwable)e));
            }
        }
        return TerminationCommand.TerminationStatus.DONE;
    }

    public String toString() {
        return "CompositeTerminationCommand [commands=" + String.valueOf(this.commands) + "]";
    }
}

