/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.runtime.launch.termination;

import java.util.concurrent.Callable;
import org.mule.tooling.runtime.launch.termination.TerminationCommand;

public abstract class BaseTerminationCommand
implements TerminationCommand {
    private Callable<Boolean> runtimeChecker;

    @Override
    public void setRuntimeChecker(Callable<Boolean> runtimeChecker) {
        this.runtimeChecker = runtimeChecker;
    }

    @Override
    public TerminationCommand.TerminationStatus execute() {
        if (!this.isRuntimeAlive()) {
            return TerminationCommand.TerminationStatus.DONE;
        }
        return this.doExecute();
    }

    protected boolean isRuntimeAlive() {
        boolean isRuntimeAlive = false;
        try {
            isRuntimeAlive = this.runtimeChecker.call();
        }
        catch (Exception exception) {
            isRuntimeAlive = false;
        }
        return isRuntimeAlive;
    }

    protected abstract TerminationCommand.TerminationStatus doExecute();
}

