/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.runtime.launch;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchesListener;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.deployer.DeploymentHelper;
import org.mule.tooling.core.impl.model.DomainUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.runtime.IMuleApplicationsStateManager;
import org.mule.tooling.runtime.MuleRuntimePlugin;
import org.mule.tooling.runtime.events.IRuntimeActionRunningListener;
import org.mule.tooling.runtime.events.MuleRuntimeEventAdapter;
import org.mule.tooling.runtime.events.MuleRuntimeEventTypes;
import org.mule.tooling.runtime.launch.LaunchesListenerAdapter;
import org.mule.tooling.runtime.launch.MuleProjectLaunchHolder;
import org.mule.tooling.runtime.service.ApplicationInfo;
import org.mule.tooling.runtime.service.ApplicationState;
import org.mule.tooling.runtime.service.DomainInfo;
import org.mule.tooling.utils.eventbus.EventBusHelper;
import org.mule.tooling.utils.eventbus.EventType;
import org.mule.tooling.utils.eventbus.IEvent;
import org.mule.tooling.utils.eventbus.IEventHandler;

public class RuntimeUtils {
    private static final List<ApplicationState> HOT_DEPLOYABLE_STATES = Arrays.asList(ApplicationState.STARTED, ApplicationState.DEPLOYMENT_FAILED, ApplicationState.CREATED, ApplicationState.INITIALISED);

    public static void deleteApplicationDataFolder(IMuleProject muleProject) {
        DeploymentHelper deploymentHelper = new DeploymentHelper(muleProject);
        File applicationDataFolder = deploymentHelper.getApplicationDataFolder();
        FileUtils.deleteQuietly((File)applicationDataFolder);
    }

    public static void deleteMuleDataFolder(IServerDefinition serverDefinition) {
        File applicationsDataFolder = DeploymentHelper.getApplicationsDataFolder((IServerDefinition)serverDefinition);
        FileUtils.deleteQuietly((File)applicationsDataFolder);
    }

    public static boolean isMuleLaunch(ILaunch launch) {
        return Boolean.parseBoolean(launch.getAttribute("mule-launch"));
    }

    public static boolean isServerAlreadyRunningThisApp(IMuleProject muleProject) throws CoreException {
        Set<IMuleApplicationsStateManager> applicationsStateManagers = MuleRuntimePlugin.getDefault().getMuleServersStateManager().getMuleApplicationsStateManagers();
        return applicationsStateManagers.stream().anyMatch(applicationsStateManager -> {
            if (MuleProjectKind.DOMAIN.classifies(muleProject)) {
                String artifactFinalName = DomainUtils.getDeployableArtifactName((IMuleProject)muleProject);
                DomainInfo domainInfo = applicationsStateManager.getDomainInfo(artifactFinalName);
                return domainInfo != null;
            }
            ApplicationInfo applicationInfo = applicationsStateManager.getApplicationInfo(muleProject.getName());
            if (applicationInfo != null) {
                return HOT_DEPLOYABLE_STATES.contains((Object)applicationInfo.getState());
            }
            return false;
        });
    }

    public static List<ILaunch> getMuleLaunches() {
        ArrayList<ILaunch> launches = new ArrayList<ILaunch>();
        ILaunch[] iLaunchArray = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        int n = iLaunchArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            if (RuntimeUtils.isMuleLaunch(launch)) {
                launches.add(launch);
            }
            ++n2;
        }
        return launches;
    }

    public static String commandLineSafePath(String path) {
        Object safePath = null;
        if (path != null) {
            safePath = path.replace("/", File.separator);
            if (((String)safePath).length() > 1 && ((String)safePath).endsWith("\\") && !((String)safePath).matches("[\\w{1}]:\\\\")) {
                safePath = ((String)safePath).substring(0, ((String)safePath).length() - 1);
            }
            if (!((String)safePath).matches("[\\w{1}]:\\\\") && !((String)safePath).equals("\\")) {
                safePath = "\"" + (String)safePath + "\"";
            }
        }
        return safePath;
    }

    public static IServerDefinition getServerDefinition(ILaunch iLaunch) {
        if (iLaunch == null) {
            throw new IllegalStateException("The view has no launch associated yet");
        }
        String runtimeId = iLaunch.getAttribute("launch_mule_server_version");
        if (runtimeId != null) {
            return MuleCorePlugin.getServerManager().getServerDefinition(runtimeId);
        }
        throw new IllegalArgumentException("launch doesn't have the launch_mule_server_version attribute");
    }

    public static IServerDefinition getServerDefinition(ILaunchConfiguration configuration) {
        String runtimeId = null;
        try {
            runtimeId = configuration.getAttribute("launch_mule_server_version", null);
        }
        catch (CoreException e) {
            MuleCorePlugin.logError((String)"Error getting the server attribute from the launch configuration", (Throwable)e);
        }
        if (runtimeId != null) {
            IServerDefinition serverDefinition = MuleCorePlugin.getServerManager().getServerDefinition(runtimeId);
            if (serverDefinition != null) {
                return serverDefinition;
            }
            MuleCorePlugin.logWarning((String)("Server " + runtimeId + " was not found using the default one"));
            return CoreUtils.getDefaultServer();
        }
        MuleCorePlugin.logWarning((String)"launch doesn't have the launch_mule_server_version attribute");
        return CoreUtils.getDefaultServer();
    }

    public static void runWhenAgentStarts(final Runnable refreshAction, final IServerDefinition serverDefinition) {
        IMuleApplicationsStateManager applicationsStateManager = MuleRuntimePlugin.getDefault().getMuleServersStateManager().getApplicationsStateManager(serverDefinition);
        if (applicationsStateManager != null && applicationsStateManager.isServerRunning()) {
            refreshAction.run();
        } else {
            final EventBusHelper eventBusHelper = new EventBusHelper();
            DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)new LaunchesListenerAdapter(){

                @Override
                public void launchesTerminated(ILaunch[] launches) {
                    ILaunch[] iLaunchArray = launches;
                    int n = launches.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IServerDefinition launchServerDefinition;
                        ILaunch launch = iLaunchArray[n2];
                        if (RuntimeUtils.isMuleLaunch(launch) && (launchServerDefinition = RuntimeUtils.getServerDefinition(launch)).getId().equals(serverDefinition.getId())) {
                            eventBusHelper.unregister();
                            DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this);
                        }
                        ++n2;
                    }
                }
            });
            eventBusHelper.registerListener(MuleRuntimePlugin.getDefault().getEventBus(), MuleRuntimeEventTypes.ON_MULE_RUNTIME_EVENT, (IEventHandler)new MuleRuntimeEventAdapter(){

                @Override
                public void onServerPoweredUp(String serverId) {
                    if (serverId.equals(serverDefinition.getId())) {
                        refreshAction.run();
                        eventBusHelper.unregister();
                    }
                }
            });
        }
    }

    public static void notifyRuntimeActionRunning(final String muleProjectName) {
        MuleRuntimePlugin.getDefault().getEventBus().fireEvent((IEvent)new IEvent<IRuntimeActionRunningListener>(){

            public EventType<IRuntimeActionRunningListener> getAssociatedType() {
                return MuleRuntimeEventTypes.ON_RUNTIME_ACTION_RUNNING;
            }

            public void dispatch(IRuntimeActionRunningListener handler) {
                handler.runtimeViewActionRunning(muleProjectName);
            }
        });
    }

    public static boolean anyProjectContainsDataMapper(List<IMuleProject> muleProjects) {
        for (IMuleProject muleProject : muleProjects) {
            if (!RuntimeUtils.containsDataMapper(muleProject)) continue;
            return true;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    public static boolean containsDataMapper(IMuleProject muleProject) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 23[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static List<IMuleProject> getAllProjectsFromConfig(ILaunchConfiguration launchConfiguration) {
        try {
            List muleProjectNames = launchConfiguration.getAttribute("mule-project-names", new ArrayList());
            MuleProjectLaunchHolder muleProjectLaunchHolder = new MuleProjectLaunchHolder(muleProjectNames);
            return muleProjectLaunchHolder.getAllLaunchProjects();
        }
        catch (CoreException e) {
            MuleCorePlugin.logError((String)"Error getting list of muleProjects", (Throwable)e);
            return Collections.emptyList();
        }
    }
}

