/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.runtime.launch;

import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.debug.core.model.RuntimeProcess;
import org.eclipse.debug.internal.core.StreamsProxy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.launching.JavaSourceLookupDirector;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMConnector;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.core.auth.AuthUser;
import org.mule.tooling.core.deployer.DefaultPackagingRequest;
import org.mule.tooling.core.deployer.DeploymentHelper;
import org.mule.tooling.core.deployer.DeploymentStrategy;
import org.mule.tooling.core.deployer.MuleLocator;
import org.mule.tooling.core.deployer.PackagingRequest;
import org.mule.tooling.core.impl.model.ExternalMuleDomainReference;
import org.mule.tooling.core.jvm.CompatibilityResult;
import org.mule.tooling.core.jvm.JavaRuntimeResolver;
import org.mule.tooling.core.jvm.JdtJavaRuntimeResolver;
import org.mule.tooling.core.jvm.MuleRuntimeJavaCompatibilityComputer;
import org.mule.tooling.core.m2.dependency.MavenCoordinates;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.core.model.IMuleApplicationProject;
import org.mule.tooling.core.model.IMuleDomain;
import org.mule.tooling.core.model.IMuleDomainProject;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.core.model.ProjectModelState;
import org.mule.tooling.core.module.ExternalContributionMuleModule;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.core.utils.VMUtils;
import org.mule.tooling.runtime.MuleRuntimePlugin;
import org.mule.tooling.runtime.RuntimeStateChanged;
import org.mule.tooling.runtime.controller.IMuleInstance;
import org.mule.tooling.runtime.controller.MuleController;
import org.mule.tooling.runtime.controller.MuleControllerManager;
import org.mule.tooling.runtime.controller.MuleInstanceConfiguration;
import org.mule.tooling.runtime.events.IHotDeployEventHandler;
import org.mule.tooling.runtime.events.IMuleProjectsLaunchListener;
import org.mule.tooling.runtime.events.MuleRuntimeEventTypes;
import org.mule.tooling.runtime.launch.JavaRuntimeLaunchHelper;
import org.mule.tooling.runtime.launch.LaunchConfigurationPackagingRequest;
import org.mule.tooling.runtime.launch.LaunchesListenerAdapter;
import org.mule.tooling.runtime.launch.MuleLaunchArgumentsProviderManager;
import org.mule.tooling.runtime.launch.MuleProjectLaunchHolder;
import org.mule.tooling.runtime.launch.RuntimeUtils;
import org.mule.tooling.ui.MessageDialogUtils;
import org.mule.tooling.ui.MuleUIPlugin;
import org.mule.tooling.ui.launchConfiguration.MuleLaunchConfigurationTab;
import org.mule.tooling.ui.launchConfiguration.extensible.ExtensibleLaunchConfigTab;
import org.mule.tooling.ui.launchConfiguration.extensible.LaunchConfigPartExtension;
import org.mule.tooling.ui.preferences.MuleStudioPreference;
import org.mule.tooling.ui.preferences.MuleStudioPreferencePage;
import org.mule.tooling.ui.utils.UiUtils;
import org.mule.tooling.ui.widgets.CoolMessageDialogWithToggle;
import org.mule.tooling.ui.widgets.util.QuestionDialog;
import org.mule.tooling.ui.widgets.util.WidgetUtils;
import org.mule.tooling.utils.ObjectHolder;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.EventType;
import org.mule.tooling.utils.eventbus.IEvent;
import org.mule.tooling.utils.eventbus.IEventHandler;
import org.mule.tooling.utils.lang.StringUtilities;
import org.osgi.framework.Version;
import org.osgi.service.prefs.BackingStoreException;

public class MuleRuntimeProcessLaunchDelegate
extends LaunchConfigurationDelegate
implements ILaunchesListener2 {
    private static final String DEBUG_MODE = "debug";
    private static final String NO_PROJECTS_SELECTED_TITLE = "No projects selected";
    private static final String NO_PROJECTS_SELECTED_MESSAGE = "The selected Run Configuration has no projects associated and cannot be ran. \nYou can edit the Run Configuration to associate projects with it.";
    private static final String INVALID_PROJECT_MODELS_TITLE = "Cannot run application";
    private static final String INCOMPATIBLE_JAVA_VERSION_TITLE = "Incompatible Java Version";
    private static final String INCOMPATIBLE_JAVA_VERSION_FIX_HINT = "Notice: this can be fixed by changing the Java runtime in the project's Build Path settings or the Run Configuration";
    private static final String INCOMPATIBLE_JAVA_VERSION_MSG = "{0} is compatible with {1}, but the current launch is configured with {2}.\n\nNotice: this can be fixed by changing the Java runtime in the project's Build Path settings or the Run Configuration";
    private static final String ENABLE_DEBUGGER_CONNECTION_ACTIONS = "studio.enableDebuggerConnectionActions";
    private static final int WAIT_FOR_TERMINATION_TIMEOUT = 5000;
    private static final int MULE_EE_TIMEOUT = 12;
    private static final int COOL_NUMBER = 1279;
    private static final int EDIT_LAUNCH_CONFIG = 1279;
    private static final int CANCEL_LAUNCH = 1280;
    private static final int CONTINUE_LAUNCH = 1281;
    private static final int MAX_CONNECTION_ATTEMPTS = 20;
    private static final int REATTEMPT_SLEEP_TIME = 500;
    private static final int RETRY_LAUNCH = 3;
    private RuntimeCheckThread eeRuntimeCheck;
    private ILaunch thisLaunch;
    private MuleProjectLaunchHolder muleProjectsHolder;
    protected IServerDefinition serverDefinition;
    private MuleController controller;
    private JavaRuntimeLaunchHelper javaRuntimeLaunchHelper = new JavaRuntimeLaunchHelper((JavaRuntimeResolver)new JdtJavaRuntimeResolver());
    private int retryLaunch = 0;
    private IHotDeployEventHandler hotDeploylistener;
    private int redeploys = 0;

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        if (!super.preLaunchCheck(configuration, mode, monitor)) {
            return false;
        }
        this.initializeMuleProject(configuration);
        if (this.getMuleProjectsHolder().isEmpty()) {
            this.showEmptyProjectsErrorDialog(configuration, mode);
            return false;
        }
        List<IMuleProject> projectsWithInvalidModel = this.getMuleProjectsHolder().getAllLaunchProjects().stream().filter(project -> project.getProjectModelState() != ProjectModelState.VALID).collect(Collectors.toList());
        if (!projectsWithInvalidModel.isEmpty()) {
            this.showInvalidProjectModelsErrorDialog(projectsWithInvalidModel);
            return false;
        }
        this.serverDefinition = RuntimeUtils.getServerDefinition(configuration);
        if (this.serverDefinition == null) {
            Display.getDefault().asyncExec(() -> this.editLaunchConfiguration(configuration, mode, Display.getCurrent().getActiveShell()));
            return false;
        }
        List<IMuleProject> allLaunchProjects = this.getMuleProjectsHolder().getAllLaunchProjects();
        IVMInstall vmInstall = this.javaRuntimeLaunchHelper.getLaunchVMInstall(configuration, allLaunchProjects);
        CompatibilityResult compatibilityResult = this.checkJavaVersionCompatibility(this.javaRuntimeLaunchHelper.getVersion(vmInstall));
        boolean incompatible = compatibilityResult.ifIncompatible((compatibleRange, compatibilityDescription) -> this.showJavaVersionErrorDialog(configuration, (String)compatibilityDescription, vmInstall));
        if (incompatible) {
            return false;
        }
        boolean shouldWarnUserOfServerMismatch = new MuleStudioPreference().shouldWarnUserOfServerMismatch();
        boolean thereIsRuntimeMismatch = this.isThereRuntimeMismatch(allLaunchProjects, this.serverDefinition);
        if (shouldWarnUserOfServerMismatch && thereIsRuntimeMismatch && !this.solveRuntimeMismatch(configuration, mode)) {
            return false;
        }
        boolean isDebugMode = DEBUG_MODE.equals(mode) || System.getProperties().containsKey(ENABLE_DEBUGGER_CONNECTION_ACTIONS);
        boolean isPortAvailable = this.checkPortAvailable(configuration, isDebugMode);
        return !isDebugMode || isPortAvailable;
    }

    private CompatibilityResult checkJavaVersionCompatibility(Version configuredJavaVersion) {
        MuleRuntimeJavaCompatibilityComputer compatibilityComputer = MuleRuntimeJavaCompatibilityComputer.createReadingExtensions();
        return compatibilityComputer.isJavaVersionCompatible(this.serverDefinition, configuredJavaVersion);
    }

    protected MuleProjectLaunchHolder getMuleProjectsHolder() {
        return this.muleProjectsHolder;
    }

    private boolean checkPortAvailable(ILaunchConfiguration configuration, boolean isDebugMode) throws CoreException {
        int port = configuration.getAttribute("remote-debug-port", 6666);
        try {
            return this.doCheckPortAvailable(port, isDebugMode);
        }
        catch (IOException | InterruptedException e) {
            throw new CoreException((IStatus)new Status(4, "org.mule.tooling.runtime", "There was a problem trying to check if the debugger port was available", (Throwable)e));
        }
    }

    private boolean doCheckPortAvailable(int port, boolean isDebugMode) throws InterruptedException, IOException {
        ServerSocket socket = null;
        int attempts = 5;
        boolean portAvailable = false;
        do {
            try {
                try {
                    socket = new ServerSocket(port);
                    portAvailable = true;
                }
                catch (Exception exception) {
                    --attempts;
                    Thread.sleep(1000L);
                    if (socket == null) continue;
                    socket.close();
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (socket != null) {
                    socket.close();
                }
                throw throwable;
            }
            if (socket == null) continue;
            socket.close();
        } while (socket == null && attempts > 0);
        if (!portAvailable && isDebugMode) {
            this.notifyPortNotAvailable(port);
        }
        return portAvailable;
    }

    private void notifyPortNotAvailable(int port) {
        Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Mule Debugger", (String)MessageFormat.format("The local port {0} is not available. Please check if other processes are currently using that port, or change it in the Run Configuration settings.", String.valueOf(port))));
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (!this.serverDefinition.isEnterpriseRuntime() && mode.equals(DEBUG_MODE)) {
            MuleRuntimeProcessLaunchDelegate.showDebuggerInCommunityWarning();
        }
        Long startEventProcessing = System.currentTimeMillis();
        boolean areConnectorVersionsOk = this.checkConnectorVersionsOk();
        boolean conflictingLaunchesResolved = this.resolveConflictingLaunches(launch, this.serverDefinition);
        if (conflictingLaunchesResolved && areConnectorVersionsOk) {
            UiUtils.showConsoleView();
            final ILaunch correctLaunch = this.performLegacyDeployment(launch, configuration, mode, monitor);
            long endEventProcessing = System.currentTimeMillis();
            Long duration = endEventProcessing - startEventProcessing;
            this.trackRunProject(mode, this.getMuleProjectsHolder().getAllLaunchProjects().get(0), CoreUtils.getLoginManager().retrieveActiveAuthUser(), duration, correctLaunch != null);
            if (correctLaunch != null) {
                MuleRuntimePlugin.getDefault().getEventBus().fireEvent((IEvent)new IEvent<IMuleProjectsLaunchListener>(){

                    public EventType<IMuleProjectsLaunchListener> getAssociatedType() {
                        return MuleRuntimeEventTypes.ON_MULE_PROJECT_LAUNCH;
                    }

                    public void dispatch(IMuleProjectsLaunchListener handler) {
                        handler.muleProjectsLaunched(correctLaunch, MuleRuntimeProcessLaunchDelegate.this.serverDefinition, MuleRuntimeProcessLaunchDelegate.this.getMuleProjectsHolder().getAllLaunchProjects());
                    }
                });
            }
        } else {
            this.getLaunchManager().removeLaunch(launch);
        }
    }

    private void trackRunProject(String mode, IMuleProject muleProject, AuthUser currentUser, Long duration, boolean successful) {
        AnalyticsRecordsFactory single;
        if (DEBUG_MODE.equals(mode)) {
            single = AnalyticsRecordsFactory.single((String)Events.DEBUG_MULE_APPLICATION);
            single.addMetadata("debuggerVersion", this.serverDefinition.getDebuggerVersion());
        } else {
            single = AnalyticsRecordsFactory.single((String)Events.RUN_MULE_APPLICATION);
        }
        Optional dep = MavenUtils.findProjectDeclaredExtension((IMuleProject)muleProject, (String)"org.mule.modules", (String)"mule-asynckit-module");
        single.addMetadata("organizationId", currentUser != null ? currentUser.getOrganization().getId() : "").addMetadata("rootOrgName", currentUser != null ? currentUser.getOrganization().getName() : "").addMetadata("jdkVersion", VMUtils.getJreVersion((IJavaProject)muleProject.getJavaProject()).orElse("")).addMetadata("duration", duration.toString()).addMetadata("runtimeVersion", this.serverDefinition.getLabel()).addMetadata("successful", Boolean.toString(successful)).addMetadata("isHotDeploy", Boolean.FALSE.toString()).addMetadata("apikitExtensionVersion", dep.map(MavenCoordinates::getVersion).orElse("")).track();
    }

    private void trackHotdeploys(String mode, int redeploys) {
        AnalyticsRecordsFactory single = AnalyticsRecordsFactory.single((String)Events.HOTDEPLOY_MULE_APPLICATION).addMetadata("hotdeploysCount", Integer.toString(redeploys));
        if (DEBUG_MODE.equals(mode)) {
            single.addMetadata("debuggerVersion", this.serverDefinition.getDebuggerVersion());
        }
        single.addMetadata("runtimeVersion", this.serverDefinition.getLabel()).track();
    }

    private boolean solveRuntimeMismatch(ILaunchConfiguration configuration, String mode) {
        ObjectHolder retVal = new ObjectHolder((Object)false);
        Display.getDefault().syncExec(() -> {
            String[] dialogButtonLabels = new String[]{"Edit configuration...", "Cancel", "Continue with launch"};
            int[] dialogButtonIds = new int[]{1279, 1280, 1281};
            Shell activeShell = Display.getDefault().getActiveShell();
            CoolMessageDialogWithToggle mismatchRuntimeDialog = new CoolMessageDialogWithToggle(activeShell, "Mule Runtime version mismatch", null, "There is a Mule runtime version mismatch between the projects configuration and the launch configuration.\n\nWhat do you want to do?", 3, dialogButtonLabels, dialogButtonIds, 3, "Don't ask me again", false);
            switch (mismatchRuntimeDialog.open()) {
                case 1279: {
                    this.editLaunchConfiguration(configuration, mode, activeShell);
                    break;
                }
                case 1280: {
                    break;
                }
                case 1281: {
                    retVal.set((Object)true);
                    break;
                }
            }
            if (mismatchRuntimeDialog.getToggleState()) {
                IPreferenceStore preferenceStore = MuleUIPlugin.getDefault().getPreferenceStore();
                preferenceStore.setValue("warn_server_mismatch_at_launch", MuleStudioPreferencePage.ActionDialogState.NEVER.name());
            }
        });
        return (Boolean)retVal.get();
    }

    private void editLaunchConfiguration(ILaunchConfiguration configuration, String mode, Shell activeShell) {
        ILaunchGroup launchGroup = DebugUITools.getLaunchGroup((ILaunchConfiguration)configuration, (String)mode);
        DebugUITools.openLaunchConfigurationDialog((Shell)activeShell, (ILaunchConfiguration)configuration, (String)launchGroup.getIdentifier(), null);
    }

    private boolean isThereRuntimeMismatch(List<IMuleProject> allLaunchProjects, IServerDefinition launchConfigServerDefinition) {
        boolean mismatch = false;
        for (IMuleProject iMuleProject : allLaunchProjects) {
            if (iMuleProject.getServerDefinition() == launchConfigServerDefinition) continue;
            mismatch = true;
            break;
        }
        return mismatch;
    }

    protected IProject[] getProjectsForProblemSearch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return (IProject[])this.muleProjectsHolder.getAllLaunchProjects().stream().map(muleProject -> muleProject.getProject()).toArray(IProject[]::new);
    }

    protected void initializeMuleProject(ILaunchConfiguration configuration) throws CoreException {
        ArrayList<String> projectNames = new ArrayList<String>();
        List muleProjectNames = configuration.getAttribute("mule-project-names", new ArrayList());
        projectNames.addAll(muleProjectNames);
        this.muleProjectsHolder = new MuleProjectLaunchHolder(projectNames);
    }

    private ILaunch performLegacyDeployment(ILaunch launch, ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        boolean deploymentSuccessful = this.deployProjects(configuration, false, true);
        boolean launchOk = true;
        if (deploymentSuccessful) {
            this.runPreLaunchActions(configuration, launch);
            launchOk = this.doLaunch(configuration, mode, launch, monitor);
            this.runPostLaunchActions(configuration);
        }
        if (!deploymentSuccessful || !launchOk) {
            this.getLaunchManager().removeLaunch(launch);
            if (this.retryLaunch > 3) {
                this.openDeploymentErrorWindow();
                this.retryLaunch = 0;
            }
            return null;
        }
        return launch;
    }

    public void openDeploymentErrorWindow() {
        Display.getDefault().asyncExec(() -> MessageDialogUtils.openErrorWithLinkToLogView((Shell)WidgetUtils.getMainWindowShell(), (String)"Deploy fail", (String)"An error occurred trying to deploy the application."));
    }

    private void runPostLaunchActions(ILaunchConfiguration configuration) throws CoreException {
        ExtensibleLaunchConfigTab muleConfigurationLaunchTab = this.getLaunchConfigTab(configuration);
        List launchConfigExtensions = muleConfigurationLaunchTab.getExtensions();
        for (LaunchConfigPartExtension launchConfigPartExtension : launchConfigExtensions) {
            launchConfigPartExtension.runPostLaunchConfigActions(configuration);
        }
        EventBus eventBus = MuleCorePlugin.getEventBus();
        this.hotDeploylistener = new IHotDeployEventHandler(){

            @Override
            public void onRedeployedMuleApp(IMuleProject redeployedMuleProject) {
                ++MuleRuntimeProcessLaunchDelegate.this.redeploys;
            }
        };
        eventBus.registerListener(MuleRuntimeEventTypes.ON_MULE_PROJECT_REDEPLOYED, (IEventHandler)this.hotDeploylistener);
    }

    private void runPreLaunchActions(ILaunchConfiguration configuration, ILaunch launch) throws CoreException {
        launch.setAttribute("mule-launch", "true");
        ExtensibleLaunchConfigTab muleConfigurationLaunchTab = this.getLaunchConfigTab(configuration);
        List launchConfigExtensions = muleConfigurationLaunchTab.getExtensions();
        for (LaunchConfigPartExtension launchConfigPartExtension : launchConfigExtensions) {
            launchConfigPartExtension.runPreLaunchConfigActions(configuration);
        }
        this.setThisLaunch(launch);
        this.installEETimedCheck(launch, 12);
        launch.setAttribute("launch_mule_server_version", this.serverDefinition.getId());
    }

    private ExtensibleLaunchConfigTab getLaunchConfigTab(ILaunchConfiguration configuration) throws CoreException {
        return new MuleLaunchConfigurationTab();
    }

    public boolean doLaunch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (monitor.isCanceled()) {
            return false;
        }
        try {
            monitor.subTask("Starting mule instance...");
            List vmArguments = StringUtilities.splitStringRespectingQuotes((String)this.getVMArguments(configuration), (String)"\\s");
            List programArguments = StringUtilities.splitStringRespectingQuotes((String)this.getProgramArguments(configuration), (String)"\\s");
            IVMInstall launchVmInstall = this.javaRuntimeLaunchHelper.getLaunchVMInstall(configuration, this.muleProjectsHolder.getAllLaunchProjects());
            String javaHome = Optional.ofNullable(launchVmInstall).flatMap(vmInstall -> Optional.ofNullable(vmInstall.getInstallLocation())).map(File::getAbsolutePath).orElseGet(() -> System.getProperty("java.home"));
            Map<String, String> environmentVariables = this.getEnvironment(configuration);
            environmentVariables.put("JAVA_HOME", javaHome);
            boolean isDebugMode = DEBUG_MODE.equals(mode) && DebugUITools.getPreferenceStore().getBoolean("java.debugger.enabled");
            Path mulePath = Paths.get(MuleLocator.create((IServerDefinition)this.serverDefinition).getInstallationDirectoryRootPath(), new String[0]);
            this.controller = MuleControllerManager.getInstance().get(mulePath);
            MuleInstanceConfiguration instanceConfiguration = MuleInstanceConfiguration.newBuilder().withJavaHome(javaHome).withVMArguments(vmArguments).withProgramArguments(programArguments).withEnvironmentVariables(environmentVariables).withDebugMode(isDebugMode).withSuspendOnDebug(true).withCrashReport(this.serverDefinition.getLabel(), this.serverDefinition.getDebuggerVersion()).withDebugPort(Integer.parseInt(System.getProperty("mule.tooling.debugPort", Integer.toString(-1)))).build();
            IMuleInstance instance = this.controller.start(instanceConfiguration);
            ILaunchConfigurationWorkingCopy launchConfigurationWorkingCopy = configuration.getWorkingCopy();
            launchConfigurationWorkingCopy.setAttribute("mule-agent-port", String.valueOf(instance.getAgentPort()));
            launchConfigurationWorkingCopy.setAttribute("mule-agent-token-auth", String.valueOf(instanceConfiguration.getAgentToken()));
            launchConfigurationWorkingCopy.doSave();
            Process process = instance.getProcess();
            HashMap<String, String> attrs = new HashMap<String, String>();
            attrs.put(IProcess.ATTR_PROCESS_TYPE, "java");
            RuntimeProcess runtimeProcess = new RuntimeProcess(launch, process, this.serverDefinition.getLabel(), attrs){

                public void terminate() throws DebugException {
                    if (!this.isTerminated() && this.getStreamsProxy() instanceof StreamsProxy) {
                        ((StreamsProxy)this.getStreamsProxy()).kill();
                    }
                    super.terminate();
                }
            };
            launch.addProcess((IProcess)runtimeProcess);
            if (monitor.isCanceled()) {
                return false;
            }
            monitor.worked(1);
            this.setDefaultSourceLocator(launch, configuration);
            monitor.worked(1);
            if (instance.isDebugMode()) {
                boolean connected = false;
                int attempts = 0;
                while (!connected && attempts < 20) {
                    try {
                        IVMConnector connector = JavaRuntime.getVMConnector((String)"org.eclipse.jdt.launching.socketAttachConnector");
                        Map argMap = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_CONNECT_MAP, new HashMap());
                        argMap.put("hostname", "localhost");
                        argMap.put("port", String.valueOf(instance.getDebugPort().get()));
                        argMap.put("timeout", "20000");
                        if (!configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_ALLOW_TERMINATE, false)) {
                            ILaunchConfigurationWorkingCopy workingCopy = configuration.getWorkingCopy();
                            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_ALLOW_TERMINATE, true);
                            workingCopy.doSave();
                        }
                        connector.connect(argMap, monitor, launch);
                        connected = true;
                    }
                    catch (CoreException coreException) {
                        try {
                            ++attempts;
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                if (!connected) {
                    MuleCorePlugin.logError((String)"Could not connect java debugger to the mule instance", (Throwable)new RuntimeException("Java debugger could not be connected to mule server instance"));
                }
            }
            if (monitor.isCanceled()) {
                IDebugTarget[] debugTargets;
                IDebugTarget[] iDebugTargetArray = debugTargets = launch.getDebugTargets();
                int n = debugTargets.length;
                int n2 = 0;
                while (n2 < n) {
                    IDebugTarget target = iDebugTargetArray[n2];
                    if (target.canDisconnect()) {
                        target.disconnect();
                    }
                    ++n2;
                }
                return false;
            }
            this.retryLaunch = 0;
            return true;
        }
        catch (Throwable e) {
            MuleRuntimePlugin.getDefault().getLog().log((IStatus)new Status(4, "org.mule.tooling.runtime", "Error while starting mule", e));
            if (this.retryLaunch <= 3) {
                ++this.retryLaunch;
                this.retryLaunchConfiguration(configuration, mode);
            }
            if (this.eeRuntimeCheck != null && this.eeRuntimeCheck.isAlive()) {
                DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this);
                this.eeRuntimeCheck.remove();
            }
            return false;
        }
        finally {
            monitor.done();
        }
    }

    private void retryLaunchConfiguration(ILaunchConfiguration configuration, String mode) {
        try {
            DebugUITools.launch((ILaunchConfiguration)configuration.getWorkingCopy(), (String)mode);
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }

    private Map<String, String> getEnvironment(ILaunchConfiguration configuration) throws CoreException {
        Map configEnv = configuration.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, null);
        if (configEnv == null) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> env = new HashMap<String, String>();
        boolean append = configuration.getAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, true);
        if (append) {
            env.putAll(DebugPlugin.getDefault().getLaunchManager().getNativeEnvironmentCasePreserved());
        }
        boolean win32 = Platform.getOS().equals("win32");
        String key = null;
        String value = null;
        String nativeValue = null;
        String nativeKey = null;
        for (Map.Entry entry : configEnv.entrySet()) {
            key = (String)entry.getKey();
            value = (String)entry.getValue();
            if (value != null) {
                value = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(value);
            }
            boolean added = false;
            if (win32) {
                nativeValue = env.get(key);
                if (nativeValue != null) {
                    env.put(key, value);
                } else {
                    for (Map.Entry<String, String> nativeEntry : env.entrySet()) {
                        nativeKey = nativeEntry.getKey();
                        if (!nativeKey.equalsIgnoreCase(key)) continue;
                        nativeEntry.setValue(value);
                        added = true;
                        break;
                    }
                }
            }
            if (added) continue;
            env.put(key, value);
        }
        return env;
    }

    private void showJavaVersionErrorDialog(ILaunchConfiguration configuration, String compatibilityDescription, IVMInstall configuredVmInstall) {
        Display.getDefault().asyncExec(() -> this.doShowJavaVersionErrorDialog(configuration, compatibilityDescription, configuredVmInstall));
    }

    private void showInvalidProjectModelsErrorDialog(List<IMuleProject> projectsWithInvalidModel) {
        Display.getDefault().asyncExec(() -> this.doShowInvalidProjectModelsErrorDialog(projectsWithInvalidModel));
    }

    private void doShowInvalidProjectModelsErrorDialog(List<IMuleProject> projectsWithInvalidModel) {
        boolean multipleProjects = projectsWithInvalidModel.size() > 1;
        StringBuilder messageBuilder = new StringBuilder(multipleProjects ? "The following projects have an invalid pom.xml file. Please correct the issues before proceeding." : "The current project has an invalid pom.xml file. Please correct the issues before proceeding.").append(System.lineSeparator()).append("Offending project" + (multipleProjects ? "s" : "") + ": ");
        String projectNames = projectsWithInvalidModel.stream().map(IMuleProject::getName).collect(Collectors.joining(", "));
        messageBuilder.append(projectNames);
        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)INVALID_PROJECT_MODELS_TITLE, (String)messageBuilder.toString());
    }

    protected void showEmptyProjectsErrorDialog(final ILaunchConfiguration configuration, final String mode) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MuleRuntimeProcessLaunchDelegate.this.doShowEmptyProjectsErrorDialog(configuration, mode);
            }
        });
    }

    private void doShowEmptyProjectsErrorDialog(ILaunchConfiguration configuration, String mode) {
        String[] dialogButtonLabels = new String[]{"Edit configuration...", "Cancel launch"};
        int[] dialogButtonIds = new int[]{1279, 1280};
        Shell activeShell = Display.getDefault().getActiveShell();
        CoolMessageDialogWithToggle emptyProjectsDialog = new CoolMessageDialogWithToggle(activeShell, this.getNoProjectsSelectedTitle(), null, this.getNoProjectsSelectedMessage(), 3, dialogButtonLabels, dialogButtonIds, 3, "Don't ask me again", false);
        emptyProjectsDialog.hideToggle();
        if (emptyProjectsDialog.open() == 1279) {
            ILaunchGroup launchGroup = DebugUITools.getLaunchGroup((ILaunchConfiguration)configuration, (String)mode);
            DebugUITools.openLaunchConfigurationDialog((Shell)activeShell, (ILaunchConfiguration)configuration, (String)launchGroup.getIdentifier(), null);
        }
    }

    private void doShowJavaVersionErrorDialog(ILaunchConfiguration configuration, String compatibilityDescription, IVMInstall configuredVmInstall) {
        List<IMuleProject> allLaunchProjects = this.getMuleProjectsHolder().getAllLaunchProjects();
        String message = allLaunchProjects.size() == 1 ? "Cannot launch project " + allLaunchProjects.get(0).getName() + ". " : "Cannot launch projects configured in " + configuration.getName() + " launch. ";
        message = message + MessageFormat.format(INCOMPATIBLE_JAVA_VERSION_MSG, this.serverDefinition.getLabel(), compatibilityDescription, configuredVmInstall.getName());
        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)INCOMPATIBLE_JAVA_VERSION_TITLE, (String)message);
    }

    protected String getNoProjectsSelectedMessage() {
        return NO_PROJECTS_SELECTED_MESSAGE;
    }

    protected String getNoProjectsSelectedTitle() {
        return NO_PROJECTS_SELECTED_TITLE;
    }

    private boolean deployProjects(ILaunchConfiguration configuration, boolean deployInAgent, boolean clean) throws CoreException {
        if (clean) {
            try {
                DeploymentHelper.prepareMuleWorkspaceDirectory((IServerDefinition)this.serverDefinition);
            }
            catch (IOException e) {
                throw new CoreException(MuleRuntimePlugin.createStatus(4, "There was a problem preparing the workspace for deployment", e));
            }
        }
        boolean result = true;
        Collection<PackagingRequest> efectiveLaunchProjects = this.getEffectiveProjectsToLaunch(this.getMuleProjectsHolder(), configuration);
        for (PackagingRequest request : efectiveLaunchProjects) {
            DeploymentStrategy deploymentStrategy = this.getDeploymentStrategy(configuration, request, deployInAgent, clean);
            result &= deploymentStrategy.deployToEmbeddedInstance(request);
        }
        return result;
    }

    protected Collection<PackagingRequest> getEffectiveProjectsToLaunch(MuleProjectLaunchHolder muleProjectsHolder, ILaunchConfiguration configuration) {
        HashSet<PackagingRequest> requests = new HashSet<PackagingRequest>();
        List<IMuleProject> effectiveLaunchProjects = muleProjectsHolder.getEffectiveLaunchProjects();
        for (IMuleProject iMuleProject : effectiveLaunchProjects) {
            this.addRequest(iMuleProject, requests, configuration);
        }
        return requests;
    }

    private void addRequest(IMuleProject iMuleProject, Collection<PackagingRequest> requests, ILaunchConfiguration configuration) {
        if (MuleProjectKind.DOMAIN.classifies(iMuleProject)) {
            PackagingRequest request = DefaultPackagingRequest.create((IMuleProject)iMuleProject, (boolean)false);
            requests.add(new LaunchConfigurationPackagingRequest(request, configuration));
        } else if (MuleProjectKind.APPLICATION.classifies(iMuleProject)) {
            IMuleApplicationProject muleAppProject = (IMuleApplicationProject)MuleProjectKind.APPLICATION.adapt(iMuleProject);
            PackagingRequest request = DefaultPackagingRequest.create((IMuleProject)iMuleProject, (boolean)false);
            requests.add(new LaunchConfigurationPackagingRequest(request, configuration));
            if (!muleAppProject.hasDefaultDomain() && muleAppProject.getDomain() != null) {
                IMuleDomain domain = muleAppProject.getDomain();
                if (domain instanceof IMuleDomainProject) {
                    PackagingRequest domainRequest = DefaultPackagingRequest.create((IMuleProject)((IMuleDomainProject)domain), (boolean)false);
                    requests.add(new LaunchConfigurationPackagingRequest(domainRequest, configuration));
                } else if (domain instanceof ExternalMuleDomainReference) {
                    requests.add(new LaunchConfigurationPackagingRequest((PackagingRequest)new DefaultPackagingRequest.Builder(null).withOption("maven.export.artifact_file", (Object)((ExternalMuleDomainReference)domain).getArtifactFile()).build(), configuration));
                }
            }
        }
    }

    protected DeploymentStrategy getDeploymentStrategy(ILaunchConfiguration configuration, PackagingRequest request, boolean deployInAgent, boolean firstLaunch) {
        IMuleProject muleProject = request.getProject();
        DeploymentStrategy deploymentStrategy = CoreUtils.getDeploymentStrategy((IMuleProject)muleProject);
        return deploymentStrategy;
    }

    protected boolean resolveConflictingLaunches(ILaunch currentLaunch, IServerDefinition serverDefinition) {
        boolean run = true;
        if (this.isAnotherMuleLaunchAlreadyRunning(currentLaunch)) {
            try {
                run = this.shouldStopRunningInstance(currentLaunch);
                if (run) {
                    this.flushRuntimeInstance();
                    this.removeAllMuleLaunchesBut(currentLaunch);
                }
            }
            catch (BackingStoreException e) {
                MuleCorePlugin.logWarning((String)"Could not persist the 'override previous running instance' preference", (Throwable)e);
            }
        }
        return run;
    }

    private boolean shouldStopRunningInstance(ILaunch currentLaunch) {
        IPreferenceStore preferenceStore = MuleUIPlugin.getDefault().getPreferenceStore();
        MuleStudioPreferencePage.ActionDialogState runServerState = MuleStudioPreferencePage.ActionDialogState.fromPreference((IPreferenceStore)preferenceStore, (String)"server_already_running_inform");
        boolean run = runServerState.prompt() ? this.promptStopRunningInstance(currentLaunch, preferenceStore) : runServerState.isAlways();
        return run;
    }

    private boolean promptStopRunningInstance(ILaunch currentLaunch, IPreferenceStore preferenceStore) {
        QuestionDialog dialog = QuestionDialog.show((String)"Mule Runtime", (String)MessageFormat.format("You are already running an instance of the embedded Mule runtime.\n\nDo you want to stop the running application and start {0}?", currentLaunch.getLaunchConfiguration().getName()), (String)"Do not show this message again.", null, null);
        boolean run = dialog.getStatus();
        if (dialog.getToggleState()) {
            preferenceStore.setValue("server_already_running_inform", run ? MuleStudioPreferencePage.ActionDialogState.ALWAYS.name() : MuleStudioPreferencePage.ActionDialogState.NEVER.name());
        } else {
            preferenceStore.setValue("server_already_running_inform", MuleStudioPreferencePage.ActionDialogState.PROMPT.name());
        }
        return run;
    }

    public boolean isAnotherMuleLaunchAlreadyRunning(ILaunch currentLaunch) {
        ILaunch[] launches;
        ILaunch[] iLaunchArray = launches = this.getLaunchManager().getLaunches();
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            if (currentLaunch != launch && !launch.isTerminated()) {
                return RuntimeUtils.isMuleLaunch(launch);
            }
            ++n2;
        }
        return false;
    }

    protected void removeAllMuleLaunchesBut(ILaunch currentLaunch) {
        ILaunch[] muleLaunchesArray;
        List<ILaunch> muleLaunches = RuntimeUtils.getMuleLaunches();
        muleLaunches.remove(currentLaunch);
        ILaunch[] iLaunchArray = muleLaunchesArray = muleLaunches.toArray(new ILaunch[0]);
        int n = muleLaunchesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            try {
                this.terminateLaunchSync(launch);
            }
            catch (DebugException e) {
                MuleCorePlugin.logError((String)("Error when trying to terminate " + String.valueOf(launch)), (Throwable)e);
            }
            ++n2;
        }
    }

    protected void terminateLaunchSync(final ILaunch launch) throws DebugException {
        final Semaphore lock = new Semaphore(0);
        LaunchesListenerAdapter listener = new LaunchesListenerAdapter(){

            @Override
            public void launchesTerminated(ILaunch[] launches) {
                ILaunch[] iLaunchArray = launches;
                int n = launches.length;
                int n2 = 0;
                while (n2 < n) {
                    ILaunch launcho = iLaunchArray[n2];
                    if (launch == launcho) {
                        lock.release();
                    }
                    ++n2;
                }
            }
        };
        this.getLaunchManager().addLaunchListener((ILaunchesListener)listener);
        launch.terminate();
        boolean terminatedSuccessfully = false;
        try {
            terminatedSuccessfully = lock.tryAcquire(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            MuleCorePlugin.logWarning((String)"Waiting for launch termination interrupted", (Throwable)e);
        }
        if (!terminatedSuccessfully) {
            String errorMessage = "Could not terminate launch " + launch.getLaunchConfiguration().getName();
            MuleCorePlugin.logError((String)errorMessage, (Throwable)new RuntimeException(errorMessage));
        }
        this.getLaunchManager().removeLaunchListener((ILaunchesListener)listener);
    }

    private boolean checkConnectorVersionsOk() {
        boolean retVal = true;
        ArrayList<ExternalContributionMuleModule> offendingElements = new ArrayList<ExternalContributionMuleModule>();
        List<ExternalContributionMuleModule> externalContributionModulesInProject = this.getExternalContributionsFromProject();
        int serverVersion = this.serverDefinition.getVersionNumber();
        for (ExternalContributionMuleModule externalContributionMuleModule : externalContributionModulesInProject) {
            if (this.getVersionNumber(externalContributionMuleModule.getMinimumVersion()) <= serverVersion) continue;
            offendingElements.add(externalContributionMuleModule);
        }
        if (!offendingElements.isEmpty()) {
            boolean run = false;
            IPreferenceStore preferenceStore = MuleUIPlugin.getDefault().getPreferenceStore();
            MuleStudioPreferencePage.ActionDialogState notifyCCProblemState = MuleStudioPreferencePage.ActionDialogState.fromPreference((IPreferenceStore)preferenceStore, (String)"cc_version_problem_inform");
            run = notifyCCProblemState.prompt() ? this.promptConformanceWithConnectorVersionMismatch(preferenceStore, offendingElements) : notifyCCProblemState.isAlways();
            retVal = run;
        }
        return retVal;
    }

    private int getVersionNumber(String versionAsString) {
        int intVersion = 0;
        if (!StringUtils.isEmpty((String)versionAsString)) {
            String[] splitVersion = versionAsString.split("\\.");
            int i = 0;
            while (i < splitVersion.length) {
                if (splitVersion[i].contains("-")) {
                    splitVersion[i] = splitVersion[i].substring(0, splitVersion[i].indexOf(45));
                }
                ++i;
            }
            if (splitVersion.length == 2) {
                splitVersion = Arrays.copyOf(splitVersion, 3);
                splitVersion[2] = "0";
            }
            if (splitVersion.length >= 3) {
                intVersion = 100 * Integer.valueOf(splitVersion[0]) + 10 * Integer.valueOf(splitVersion[1]) + Integer.valueOf(splitVersion[2]);
            }
        }
        return intVersion;
    }

    private boolean promptConformanceWithConnectorVersionMismatch(IPreferenceStore preferenceStore, List<ExternalContributionMuleModule> offendingElements) {
        String ccText = this.getProblematicConnectorVersionsText(offendingElements);
        QuestionDialog dialog = QuestionDialog.show((String)"Problem with connectors version", (String)("The following connectors require a newer version of the Mule runtime in order to run properly:\n" + ccText + "\n\nYour current Mule runtime server is " + this.serverDefinition.getVersion() + "\n\nDo you still want to launch you application?"), (String)"Do not show this message again.", null, null);
        boolean run = dialog.getStatus();
        if (dialog.getToggleState()) {
            preferenceStore.setValue("cc_version_problem_inform", run ? MuleStudioPreferencePage.ActionDialogState.ALWAYS.name() : MuleStudioPreferencePage.ActionDialogState.NEVER.name());
        } else {
            preferenceStore.setValue("cc_version_problem_inform", MuleStudioPreferencePage.ActionDialogState.PROMPT.name());
        }
        return run;
    }

    private List<ExternalContributionMuleModule> getExternalContributionsFromProject() {
        HashSet externalModules = new HashSet();
        List<IMuleProject> allLaunchProjects = this.getMuleProjectsHolder().getAllLaunchProjects();
        for (IMuleProject iMuleProject : allLaunchProjects) {
            externalModules.addAll(CoreUtils.getExternalContributionModulesInProject((IMuleProject)iMuleProject));
        }
        return new ArrayList<ExternalContributionMuleModule>(externalModules);
    }

    private String getProblematicConnectorVersionsText(List<ExternalContributionMuleModule> offendingElements) {
        StringBuilder message = new StringBuilder();
        for (ExternalContributionMuleModule externalContributionMuleModule : offendingElements) {
            message.append("\n");
            message.append(externalContributionMuleModule.getName());
            message.append(" needs at least version ");
            message.append(externalContributionMuleModule.getMinimumVersion());
        }
        return message.toString();
    }

    private void flushRuntimeInstance() throws BackingStoreException {
        InstanceScope.INSTANCE.getNode(MuleRuntimePlugin.getDefault().getBundle().getSymbolicName()).flush();
    }

    private void installEETimedCheck(ILaunch launch, int hours) {
        if (this.serverDefinition != null && this.serverDefinition.isEnterpriseRuntime()) {
            DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
            this.eeRuntimeCheck = new RuntimeCheckThread(hours, launch);
            this.eeRuntimeCheck.setName("Anypoint Studio EE runtime check thread");
            this.eeRuntimeCheck.start();
        }
    }

    protected boolean isLaunchProblem(IMarker problemMarker) throws CoreException {
        return CoreUtils.isMuleError((IMarker)problemMarker);
    }

    public void launchesRemoved(ILaunch[] launches) {
    }

    public void launchesAdded(ILaunch[] launches) {
    }

    public void launchesChanged(ILaunch[] launches) {
    }

    public void launchesTerminated(ILaunch[] launches) {
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch iLaunch = iLaunchArray[n2];
            if (iLaunch == this.getThisLaunch() && this.eeRuntimeCheck != null && this.eeRuntimeCheck.isAlive()) {
                DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this);
                this.eeRuntimeCheck.remove();
                this.controller.stop();
                IServerDefinition definitionFromLaunch = RuntimeUtils.getServerDefinition(iLaunch);
                if (definitionFromLaunch != null) {
                    MuleRuntimePlugin.getDefault().getMuleServersStateManager().stopApplicationsStateManager(definitionFromLaunch);
                    MuleCorePlugin.getEventBus().fireEvent((IEvent)RuntimeStateChanged.stoppedEvent());
                }
                if (this.hotDeploylistener == null) break;
                EventBus eventBus = MuleCorePlugin.getEventBus();
                eventBus.unRegisterListener(MuleRuntimeEventTypes.ON_MULE_PROJECT_REDEPLOYED, (IEventHandler)this.hotDeploylistener);
                this.hotDeploylistener = null;
                if (this.redeploys > 0) {
                    this.trackHotdeploys(this.getThisLaunch().getLaunchMode(), this.redeploys);
                }
                this.redeploys = 0;
                break;
            }
            ++n2;
        }
    }

    public ILaunch getThisLaunch() {
        return this.thisLaunch;
    }

    public void setThisLaunch(ILaunch thisLaunch) {
        this.thisLaunch = thisLaunch;
    }

    public static void showDebuggerInCommunityWarning() {
        WidgetUtils.getDisplay().syncExec(() -> MessageDialog.openWarning((Shell)WidgetUtils.getShell(), (String)"Can not run a Mule debug session", (String)"Mule Debugger is only supported for Enterprise runtimes.\nA standard Java debugging session will be started."));
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected void setDefaultSourceLocator(ILaunch launch, ILaunchConfiguration configuration) throws CoreException {
        if (launch.getSourceLocator() == null) {
            JavaSourceLookupDirector sourceLocator = new JavaSourceLookupDirector();
            sourceLocator.setSourcePathComputer(this.getLaunchManager().getSourcePathComputer("org.eclipse.jdt.launching.sourceLookup.javaSourcePathComputer"));
            sourceLocator.initializeDefaults(configuration);
            launch.setSourceLocator((ISourceLocator)sourceLocator);
        }
    }

    private String getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, "");
    }

    private String getVMArguments(ILaunchConfiguration configuration) throws CoreException {
        String[] javaLibraryPath;
        String arguments = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "");
        arguments = VMUtils.getVMArguments((IJavaProject)this.getJavaProject(configuration), (String)arguments);
        String args = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(arguments);
        int libraryPath = args.indexOf("-Djava.library.path");
        StringBuffer sb = new StringBuffer(args);
        if (libraryPath < 0 && (javaLibraryPath = this.getJavaLibraryPath(configuration)) != null && javaLibraryPath.length > 0) {
            StringBuffer path = sb;
            path.append(" -Djava.library.path=");
            path.append("\"");
            int i = 0;
            while (i < javaLibraryPath.length) {
                if (i > 0) {
                    path.append(File.pathSeparatorChar);
                }
                path.append(javaLibraryPath[i]);
                ++i;
            }
            path.append("\"");
            args = path.toString();
        }
        MuleLaunchArgumentsProviderManager.getDefault().appendArguments(sb, this.getThisLaunch());
        return sb.toString();
    }

    private String[] getJavaLibraryPath(ILaunchConfiguration configuration) throws CoreException {
        String[] paths;
        IJavaProject project = this.getJavaProject(configuration);
        if (project != null && (paths = JavaRuntime.computeJavaLibraryPath((IJavaProject)project, (boolean)true)).length > 0) {
            return paths;
        }
        return new String[0];
    }

    private IJavaProject getJavaProject(ILaunchConfiguration configuration) throws CoreException {
        IProject project;
        IJavaProject javaProject;
        String projectName = this.getJavaProjectName(configuration);
        if (projectName != null && (projectName = projectName.trim()).length() > 0 && (javaProject = JavaCore.create((IProject)(project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)))) != null && javaProject.exists()) {
            return javaProject;
        }
        return null;
    }

    private String getJavaProjectName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
    }

    private static final class RuntimeCheckThread
    extends Thread {
        private final long hours;
        private final ILaunch launch;
        private boolean removing;

        private RuntimeCheckThread(int hours, ILaunch launch) {
            this.hours = hours;
            this.launch = launch;
        }

        public void remove() {
            this.removing = true;
            this.interrupt();
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this.hours * 60L * 60L * 1000L);
                if (!this.launch.isTerminated()) {
                    this.launch.terminate();
                    Display.getCurrent().syncExec(() -> MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Mule EE Runtime timeout", (String)("You are running an Enterprise version of Mule.\nThe Mule runtime embedded in Studio is meant for testing your applications, not for production environments; it will run for a maximum of " + this.hours + " hs.\nAfter that you would need to restart the server to start over.")));
                }
            }
            catch (InterruptedException e) {
                if (!this.removing) {
                    MuleCorePlugin.logError((String)"Error installing the EE time check...", (Throwable)e);
                }
            }
            catch (DebugException e) {
                MuleCorePlugin.logError((String)"Error installing the EE time check...", (Throwable)e);
            }
        }
    }
}

