/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.runtime.launch;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.model.IMuleApplicationProject;
import org.mule.tooling.core.model.IMuleDomain;
import org.mule.tooling.core.model.IMuleDomainProject;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.IMuleProjectVisitor;

public class MuleProjectLaunchHolder {
    private List<IProject> muleProjects = new ArrayList<IProject>();

    public MuleProjectLaunchHolder(List<String> muleProjectNames) {
        IMuleProject[] knowProjects = MuleRuntime.getMuleProjects();
        for (String muleProjectName : muleProjectNames) {
            IMuleProject[] iMuleProjectArray = knowProjects;
            int n = knowProjects.length;
            int n2 = 0;
            while (n2 < n) {
                IMuleProject muleProject = iMuleProjectArray[n2];
                if (muleProject.getName().equals(muleProjectName)) {
                    this.muleProjects.add(muleProject.getProject());
                }
                ++n2;
            }
        }
    }

    public List<IMuleProject> getEffectiveLaunchProjects() {
        return this.muleProjects.stream().map(x -> MuleRuntime.create((IProject)x)).collect(Collectors.toList());
    }

    public List<IMuleProject> getAllLaunchProjects() {
        final ArrayList<IMuleProject> allProjects = new ArrayList<IMuleProject>();
        for (IMuleProject muleProject : this.getEffectiveLaunchProjects()) {
            muleProject.accept(new IMuleProjectVisitor(){

                public void visit(IMuleApplicationProject muleProject) {
                    allProjects.add(muleProject);
                    IMuleDomain domain = muleProject.getDomain();
                    if (!muleProject.hasDefaultDomain() && domain != null && domain instanceof IMuleDomainProject) {
                        allProjects.add((IMuleDomainProject)domain);
                    }
                }

                public void visit(IMuleDomainProject muleDomain) {
                    try {
                        allProjects.add(muleDomain);
                        allProjects.addAll(muleDomain.getChildProjects());
                    }
                    catch (CoreException e) {
                        MuleCorePlugin.logError((String)("Cannot get child projects from domain " + muleDomain.getName()), (Throwable)e);
                    }
                }
            });
        }
        return allProjects;
    }

    public boolean isEmpty() {
        return this.muleProjects.isEmpty();
    }
}

