/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.runtime.launch;

import java.io.File;
import java.util.Optional;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.deployer.DeploymentHelper;
import org.mule.tooling.core.deployer.PackagingRequest;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.runtime.launch.RuntimeUtils;

public class LaunchConfigurationPackagingRequest
implements PackagingRequest {
    private final PackagingRequest decorated;
    private final ILaunchConfiguration launchConfiguration;

    public LaunchConfigurationPackagingRequest(PackagingRequest decorated, ILaunchConfiguration launchConfiguration) {
        this.decorated = decorated;
        this.launchConfiguration = launchConfiguration;
    }

    public IMuleProject getProject() {
        return this.decorated.getProject();
    }

    public Optional<File> getOutputFile() {
        IServerDefinition serverDefinition = RuntimeUtils.getServerDefinition(this.launchConfiguration);
        IMuleProject muleProject = this.decorated.getProject();
        File outputFile = MuleProjectKind.APPLICATION.classifies(muleProject) ? DeploymentHelper.getMuleAppsFolder((IServerDefinition)serverDefinition) : DeploymentHelper.getMuleDomainsFolder((IServerDefinition)serverDefinition);
        return Optional.of(DeploymentHelper.getStagingFolder((File)outputFile));
    }

    public boolean isLightweight() {
        return this.decorated.isLightweight();
    }

    public boolean attachSources() {
        return this.decorated.attachSources();
    }

    public boolean includeLinkedProjects() {
        return this.decorated.includeLinkedProjects();
    }

    public boolean onlySources() {
        return this.decorated.onlySources();
    }

    public Optional<Object> getOption(String key) {
        return Optional.ofNullable(this.decorated.getOption(key).orElse(this.getAttribute(key)));
    }

    public boolean useLocalRepo() {
        return this.decorated.useLocalRepo();
    }

    private Object getAttribute(String key) {
        try {
            return this.launchConfiguration.getAttributes().get(key);
        }
        catch (CoreException e) {
            MuleCorePlugin.logError((String)("There was a problem reading launch configuration attribute " + key), (Throwable)e);
            return null;
        }
    }

    public boolean checkMavenVersion() {
        return this.decorated.checkMavenVersion();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.decorated == null ? 0 : this.decorated.hashCode());
        result = 31 * result + (this.launchConfiguration == null ? 0 : this.launchConfiguration.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LaunchConfigurationPackagingRequest other = (LaunchConfigurationPackagingRequest)obj;
        if (this.decorated == null ? other.decorated != null : !this.decorated.equals(other.decorated)) {
            return false;
        }
        return !(this.launchConfiguration == null ? other.launchConfiguration != null : !this.launchConfiguration.equals(other.launchConfiguration));
    }
}

