/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.runtime.launch;

import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.jvm.JavaRuntimeResolver;
import org.mule.tooling.core.model.IMuleProject;
import org.osgi.framework.Version;

public class JavaRuntimeLaunchHelper {
    private final JavaRuntimeResolver javaRuntimeResolver;

    public JavaRuntimeLaunchHelper(JavaRuntimeResolver javaRuntimeResolver) {
        this.javaRuntimeResolver = javaRuntimeResolver;
    }

    public IVMInstall getLaunchVMInstall(ILaunchConfiguration configuration, List<IMuleProject> projectsToLaunch) throws CoreException {
        String launchConfigContainerName = (String)configuration.getAttributes().get(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH);
        Optional<IVMInstall> launchConfigurationInstall = Optional.ofNullable(launchConfigContainerName).map(name -> this.javaRuntimeResolver.getVmInstall(name));
        return Optional.ofNullable(launchConfigurationInstall.orElseGet(() -> this.getVMInstall(projectsToLaunch))).orElseGet(() -> this.javaRuntimeResolver.getDefaultVmInstall());
    }

    public Version getVersion(IVMInstall vmInstall) {
        return Version.parseVersion((String)this.javaRuntimeResolver.getVersion(vmInstall));
    }

    private IVMInstall getVMInstall(List<IMuleProject> projectsToLaunch) {
        IVMInstall highestVersionInstall = null;
        for (IMuleProject project : projectsToLaunch) {
            try {
                IVMInstall projectInstall = this.getVMInstall(project);
                highestVersionInstall = highestVersionInstall == null || this.isNewerVersion(projectInstall, highestVersionInstall) ? projectInstall : highestVersionInstall;
            }
            catch (CoreException e) {
                MuleCorePlugin.logError((String)("There was a problem resolving the Java runtime configured for project " + project.getName()), (Throwable)e);
            }
        }
        return highestVersionInstall;
    }

    private boolean isNewerVersion(IVMInstall projectInstall, IVMInstall otherVmInstall) {
        return this.getVersion(projectInstall).compareTo(this.getVersion(otherVmInstall)) > 0;
    }

    private IVMInstall getVMInstall(IMuleProject muleProject) throws CoreException {
        return this.javaRuntimeResolver.getVmInstall(muleProject);
    }
}

