/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.runtime.launch;

import java.util.UUID;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.mule.tooling.runtime.MuleRuntimePlugin;
import org.mule.tooling.runtime.launch.IMuleLaunchArgumentsProvider;
import org.mule.tooling.ui.launchConfiguration.StartAsClusterComponent;

public class ClusteringArgumentsProvider
implements IMuleLaunchArgumentsProvider {
    private static final String MULE_CLUSTER_ID_ARGUMENT = " -Dmule.clusterId=";

    @Override
    public void appendArguments(StringBuffer sb, ILaunch iLaunch) {
        ILaunchConfiguration launchConfiguration = iLaunch.getLaunchConfiguration();
        this.doAppendArguments(sb, launchConfiguration);
    }

    private void doAppendArguments(StringBuffer sb, ILaunchConfiguration launchConfiguration) {
        try {
            if (launchConfiguration.hasAttribute("clusterNodeId")) {
                String clusterNodeId = launchConfiguration.getAttribute("clusterNodeId", "");
                if (clusterNodeId.equals(StartAsClusterComponent.FROM_UUID)) {
                    clusterNodeId = UUID.randomUUID().toString();
                }
                clusterNodeId = clusterNodeId.replaceAll("[\\s/\\\\$\"']", "_");
                sb.append(MULE_CLUSTER_ID_ARGUMENT);
                sb.append(clusterNodeId);
            }
        }
        catch (CoreException e) {
            MuleRuntimePlugin.getDefault().getLog().log(MuleRuntimePlugin.createStatus(4, "There was a problem retrieving HA parameters in the run configuration", e));
        }
    }
}

