/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.runtime.controller;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.mule.tooling.runtime.controller.UnixFileResolver;
import org.mule.tooling.runtime.controller.WindowsFileResolver;
import org.mule.tooling.runtime.controller.WrapperAndPIDFileResolver;
import org.mule.tooling.utils.OsDetect;

public class MulePathHelper {
    private Path mulePath;
    private WrapperAndPIDFileResolver pidFileResolver;

    public MulePathHelper(Path mulePath) {
        this.mulePath = mulePath;
        OsDetect.OsType operatingSystemType = OsDetect.getOperatingSystemType();
        this.pidFileResolver = operatingSystemType.equals((Object)OsDetect.OsType.Windows) ? new WindowsFileResolver() : new UnixFileResolver();
    }

    public Path getMuleHomePath() {
        return this.mulePath;
    }

    public List<Path> getWrapperAnchorFile() {
        return this.pidFileResolver.getWrapperAnchorPath(this);
    }

    public List<Path> getWrapperPid() {
        return this.pidFileResolver.getWrapperPidFile(this);
    }

    public List<Path> getMuleJavaPid() {
        return this.pidFileResolver.getMuleJavaPid(this);
    }

    public Path getBinPath() {
        return this.mulePath.resolve("bin");
    }

    public Path getDomainsPath() {
        return this.mulePath.resolve("domains");
    }

    public Path getAppsPath() {
        return this.mulePath.resolve("apps");
    }

    public Path getLogsPath() {
        return this.mulePath.resolve("logs");
    }

    public Path getToolingPath() {
        return this.mulePath.resolve("tmp").resolve("tooling");
    }

    public Path getDefaultDomainPath() {
        return this.mulePath.resolve("domains").resolve("default");
    }

    public Path getLibBootExecPath() {
        Path libBootExec = this.mulePath.resolve("lib").resolve("boot").resolve("exec");
        if (Files.exists(libBootExec, new LinkOption[0])) {
            return libBootExec;
        }
        return this.mulePath.resolve("lib").resolve("boot").resolve("tanuki").resolve("exec");
    }

    public Path getWrapperConfFile() {
        return this.mulePath.resolve("conf").resolve("wrapper.conf");
    }

    public Path getWrapperConfFileTemplate() {
        return this.mulePath.resolve("conf").resolve("wrapper.conf.template");
    }

    public Path getBinaryFile() {
        return this.mulePath.resolve("bin").resolve(this.getScriptName());
    }

    public Path getMuleConfigFile() {
        return this.mulePath.resolve("conf").resolve("mule-config.json");
    }

    public Path getMuleConfigFileTemplate() {
        return this.mulePath.resolve("conf").resolve("mule-config.json.template");
    }

    public Path getAgentFile() {
        return this.mulePath.resolve("conf").resolve("mule-agent.yml");
    }

    public Path getInstanceLock() {
        return this.getMuleHomePath().resolve("Instance.lock");
    }

    private String getScriptName() {
        return this.pidFileResolver.getScriptName();
    }

    public String toString() {
        return "MulePathHelper [mulePath=" + String.valueOf(this.mulePath) + ", pidFileResolver=" + String.valueOf(this.pidFileResolver) + "]";
    }
}

