/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.runtime.controller;

import com.google.common.collect.Lists;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.mule.tooling.core.net.ConnectionManager;
import org.mule.tooling.core.net.ProxyData;
import org.mule.tooling.core.utils.EclipseContextHelper;

public class MuleInstanceConfiguration {
    public static final int NO_DEBUG_PORT = -1;
    private final List<String> vmArguments;
    private final List<String> programArguments;
    private final Map<String, String> environmentVariables;
    private final boolean debugMode;
    private final int debugPort;
    private final boolean toolingInstance;
    private final int startupTimeout;
    private final int checkExistingProcessTimeout;
    private final boolean suspend;
    private final String javaHome;
    private final String agentToken;
    private final String runtimeVersion;
    private final String debuggerVersion;

    private MuleInstanceConfiguration(MuleInstanceConfigurationBuilder builder) {
        this.javaHome = builder.javaHome;
        this.programArguments = builder.programArguments;
        this.vmArguments = builder.vmArguments;
        this.environmentVariables = builder.environmentVariables;
        this.suspend = builder.suspend;
        this.debugMode = builder.debugMode;
        this.toolingInstance = builder.toolingInstance;
        this.startupTimeout = builder.startupTimeout;
        this.checkExistingProcessTimeout = builder.checkExistingProcessTimeout;
        this.debugPort = builder.debugPort;
        this.agentToken = builder.agentToken;
        this.runtimeVersion = builder.runtimeVersion;
        this.debuggerVersion = builder.debuggerVersion;
    }

    public String getJavaHome() {
        return this.javaHome;
    }

    public List<String> getProgramArguments() {
        return this.programArguments;
    }

    public List<String> getVmArguments() {
        return this.vmArguments;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public boolean isToolingInstance() {
        return this.toolingInstance;
    }

    public int getStartupTimeout() {
        return this.startupTimeout;
    }

    public int getCheckExistingProcessTimeout() {
        return this.checkExistingProcessTimeout;
    }

    public boolean isSuspend() {
        return this.suspend;
    }

    public int getDebugPort() {
        return this.debugPort;
    }

    public boolean isDebugPortConfigured() {
        return this.debugPort != -1;
    }

    public String getAgentToken() {
        return this.agentToken;
    }

    public String getRuntimeVersion() {
        return this.runtimeVersion;
    }

    public String getDebuggerVersion() {
        return this.debuggerVersion;
    }

    public boolean isTrackCrash() {
        return this.runtimeVersion != null;
    }

    public static MuleInstanceConfigurationBuilder newBuilder() {
        return (MuleInstanceConfigurationBuilder)EclipseContextHelper.createFromStudioContext(MuleInstanceConfigurationBuilder.class);
    }

    public static class MuleInstanceConfigurationBuilder {
        private static final String VM_ARG_QUOTES = "\"";
        private static final String VM_ARG_EQUALS = "=\"";
        private static final String VM_ARG_PREFIX = "-D";
        private static final String PROXY_VM_ARGUMENT = "-M-Dcom.ning.http.client.AsyncHttpClientConfig.useProxyProperties=true";
        private static final String NON_PROXY_HOST_DELIMITER = "|";
        private static final int DEFAULT_TIMEOUT_FOR_CHECK_EXISTING_PROCESS = 10;
        private static final String ANYPOINT_PROXY_HOST = "anypoint.platform.proxy_host";
        private static final String ANYPOINT_PROXY_PORT = "anypoint.platform.proxy_port";
        private static final String ANYPOINT_PROXY_USER = "anypoint.platform.proxy_username";
        private static final String ANYPOINT_PROXY_PASSWORD = "anypoint.platform.proxy_password";
        private static final String AGENT_AUTH_TOKEN_PROPERTY = "-M-Dagent-token-authorization";
        private List<String> vmArguments = new ArrayList<String>();
        private List<String> programArguments = new ArrayList<String>();
        private Map<String, String> environmentVariables = new HashMap<String, String>();
        private boolean debugMode;
        private boolean toolingInstance;
        private int debugPort = -1;
        private int startupTimeout;
        private String agentToken;
        private int checkExistingProcessTimeout = 10;
        @Inject
        private ConnectionManager connectionManager;
        private boolean suspend = true;
        private String javaHome;
        private String runtimeVersion;
        private String debuggerVersion;

        private List<String> getProxyArguments() {
            List<String> proxyArgs = this.connectionManager.getAllProxyData().stream().flatMap(aProxyData -> this.transformProxyDataToVmArg((ProxyData)aProxyData).stream()).collect(Collectors.toList());
            if (!proxyArgs.isEmpty()) {
                proxyArgs.add(PROXY_VM_ARGUMENT);
            }
            return proxyArgs;
        }

        private String transformToQuotedVmArg(String key, String value) {
            StringBuilder vmArgBuilder = new StringBuilder();
            return vmArgBuilder.append(VM_ARG_PREFIX).append(key).append(VM_ARG_EQUALS).append(value).append(VM_ARG_QUOTES).toString();
        }

        private List<String> transformProxyDataToVmArg(ProxyData proxyData) {
            HashMap<String, String> systemPropertiesToAdd = new HashMap<String, String>();
            ProxyData.Protocol protocol = proxyData.getProtocol();
            systemPropertiesToAdd.put(protocol.getHostSystemPropertyKey(), proxyData.getHost());
            systemPropertiesToAdd.put(protocol.getPortSystemPropertyKey(), Integer.toString(proxyData.getPort()));
            if (protocol.equals((Object)ProxyData.Protocol.HTTP)) {
                systemPropertiesToAdd.put(ANYPOINT_PROXY_HOST, proxyData.getHost());
                systemPropertiesToAdd.put(ANYPOINT_PROXY_PORT, Integer.toString(proxyData.getPort()));
            }
            String nonProxyHosts = this.toolingInstance ? Arrays.asList("localhost", "127.*", "[::1]").stream().collect(Collectors.joining(NON_PROXY_HOST_DELIMITER)) : proxyData.getNonProxiedHosts().stream().collect(Collectors.joining(NON_PROXY_HOST_DELIMITER));
            protocol.getNonProxiesHostSystemPropertyKey().ifPresent(nonProxiedHostsKey -> systemPropertiesToAdd.put((String)nonProxiedHostsKey, nonProxyHosts));
            proxyData.getAuthentication().ifPresent(auth -> {
                protocol.getUsernameSystemPropertyKeys().stream().forEach(keyName -> {
                    systemPropertiesToAdd.put((String)keyName, auth.getUser());
                    if (protocol.equals((Object)ProxyData.Protocol.HTTP)) {
                        systemPropertiesToAdd.put(ANYPOINT_PROXY_USER, auth.getUser());
                    }
                });
                protocol.getPasswordSystemPropertyKeys().stream().forEach(keyName -> {
                    systemPropertiesToAdd.put((String)keyName, auth.getPassword());
                    if (protocol.equals((Object)ProxyData.Protocol.HTTP)) {
                        systemPropertiesToAdd.put(ANYPOINT_PROXY_PASSWORD, auth.getPassword());
                    }
                });
            });
            return systemPropertiesToAdd.entrySet().stream().map(entry -> this.transformToQuotedVmArg((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList());
        }

        private List<String> getAgentArguments() {
            this.agentToken = UUID.randomUUID().toString();
            String agentAuthProperty = "-M-Dagent-token-authorization=" + this.agentToken;
            return Lists.newArrayList((Object[])new String[]{agentAuthProperty});
        }

        public MuleInstanceConfigurationBuilder withVMArguments(List<String> vmArguments) {
            this.vmArguments.addAll(vmArguments);
            return this;
        }

        public MuleInstanceConfigurationBuilder withProgramArguments(List<String> programArguments) {
            this.programArguments = programArguments;
            return this;
        }

        public MuleInstanceConfigurationBuilder withEnvironmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = environmentVariables;
            return this;
        }

        public MuleInstanceConfigurationBuilder withDebugMode(boolean debugMode) {
            this.debugMode = debugMode;
            return this;
        }

        public MuleInstanceConfigurationBuilder withDebugPort(int debugPort) {
            this.debugPort = debugPort;
            return this;
        }

        public MuleInstanceConfigurationBuilder withSuspendOnDebug(boolean suspend) {
            this.suspend = suspend;
            return this;
        }

        public MuleInstanceConfigurationBuilder isToolingInstance(boolean toolingInstance) {
            this.toolingInstance = toolingInstance;
            return this;
        }

        public MuleInstanceConfigurationBuilder withStartupTimeout(int startupTimeout) {
            this.startupTimeout = startupTimeout;
            return this;
        }

        public MuleInstanceConfigurationBuilder withCheckExistingProcessTimeout(int checkExistingProcessTimeout) {
            this.checkExistingProcessTimeout = checkExistingProcessTimeout;
            return this;
        }

        public MuleInstanceConfigurationBuilder withJavaHome(String javaHome) {
            this.javaHome = javaHome;
            return this;
        }

        public MuleInstanceConfigurationBuilder withCrashReport(String runtimeVersion, String debuggerVersion) {
            this.runtimeVersion = runtimeVersion;
            this.debuggerVersion = debuggerVersion;
            return this;
        }

        public MuleInstanceConfiguration build() {
            if (this.javaHome == null) {
                this.javaHome = System.getProperty("java.home");
            }
            this.vmArguments.addAll(this.getProxyArguments());
            this.vmArguments.addAll(this.getAgentArguments());
            return new MuleInstanceConfiguration(this);
        }
    }
}

