/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.runtime.controller;

import java.net.InetAddress;
import java.nio.file.Path;
import java.util.Optional;
import org.mule.tooling.runtime.controller.IMuleInstance;
import org.mule.tooling.runtime.controller.MulePathHelper;

public class MuleInstance
implements IMuleInstance {
    private Process process;
    private Integer agentPort;
    private Integer debugPort;
    private MulePathHelper pathHelper;
    private String agentToken;

    public MuleInstance(Process process, Integer agentPort, Integer debugPort, MulePathHelper pathHelper, String agentToken) {
        this.process = process;
        this.agentPort = agentPort;
        this.debugPort = debugPort;
        this.pathHelper = pathHelper;
        this.agentToken = agentToken;
    }

    @Override
    public Process getProcess() {
        return this.process;
    }

    @Override
    public boolean isDebugMode() {
        return this.debugPort != null;
    }

    @Override
    public Integer getAgentPort() {
        return this.agentPort;
    }

    @Override
    public Path getPath() {
        return this.pathHelper.getMuleHomePath();
    }

    @Override
    public Optional<Integer> getDebugPort() {
        return Optional.ofNullable(this.debugPort);
    }

    @Override
    public String toolingURL() {
        return "http://" + InetAddress.getLoopbackAddress().getHostAddress() + ":" + String.valueOf(this.getAgentPort()) + "/mule/tooling";
    }

    @Override
    public String getAgentToken() {
        return this.agentToken;
    }
}

