/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.runtime.controller;

import com.google.common.collect.Range;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.deployer.DeploymentHelper;
import org.mule.tooling.core.io.MuleResourceUtils;
import org.mule.tooling.core.m2.MavenConfiguration;
import org.mule.tooling.core.m2.internal.MavenCore;
import org.mule.tooling.runtime.controller.MuleAgentConfigurer;
import org.mule.tooling.runtime.controller.MuleController;
import org.mule.tooling.runtime.controller.MuleControllerException;
import org.mule.tooling.runtime.controller.MuleInstanceConfiguration;
import org.mule.tooling.runtime.controller.MulePathHelper;
import org.mule.tooling.ui.MuleUIPlugin;
import org.mule.tooling.utils.OsDetect;
import org.mule.tooling.utils.UtilsPlugin;
import org.osgi.framework.Bundle;

public class MuleControllerHelper {
    private static final String JAVA_BINARY_OTHER = "java";
    private static final String JAVA_BINARY_WINDOWS = "javaw.exe";
    private static final String JDK_FOLDER_BIN = "bin";
    private static final String JDK_FOLDER_JRE = "jre";
    private static final String IGNORE_ARTIFACT_DESCRIPTOR_REPOSITORIES = "ignore_artifact_descriptor_repositories";
    private static final String OFFLINE_MODE = "offline_mode";
    public static final String WRAPPER_JAVA_COMMAND = "wrapper.java.command";
    public static final String WRAPPER_JAVA_ADDITIONAL = "wrapper.java.additional.";
    private static final String WRAPPER_JAVA_ADDITIONAL_MAX_METASPACE = "wrapper.java.additional.7";
    private static final String MAX_METASPACE = "-XX:MaxMetaspaceSize";
    private static final String MAX_METASPACE_DEFAULT = "1g";
    public static final Integer WRAPPER_JAVA_ADDITIONAL_DEFAULT_NUMBER = 99;
    public static final Range<Integer> WRAPPER_JAVA_ADDITIONAL_RESERVED = Range.closed((Comparable)Integer.valueOf(120), (Comparable)Integer.valueOf(125));
    public static final String WRAPPER_JAVA_PIDFILE = "wrapper.java.pidfile";
    public static final String WRAPPER_JAVA_MAXMEMORY = "wrapper.java.maxmemory";
    public static final String WRAPPER_JAVA_INITMEMORY = "wrapper.java.initmemory";
    public static final String WRAPPER_DISABLE_RESTARTS = "wrapper.disable_restarts";
    public static final String WRAPPER_CONSOLE_FLUSH = "wrapper.console.flush";
    public static final String WRAPPER_ANCHORFILE = "wrapper.anchorfile";
    public static final String WRAPPER_PIDFILE = "wrapper.pidfile";
    private static final String TOOLING_CLIENT_BUNDLE_ID = "org.mule.tooling.client";
    public static final String TOOLING_CLIENT_INIT_MEMORY = "toolingClient.initMemory";
    public static final int TOOLING_CLIENT_INIT_MEMORY_DEFAULT = 512;
    public static final String ADDITIONAL_ARGS_PROP = "org.mule.tooling.runtime.args";
    private static final String FIPS_DEPENDENCIES_BUNDLE = "org.mule.tooling.fips.dependencies";
    private static final String FIPS_BUNDLE_JDK_PREFIX = "org.mule.tooling.jdk.";
    private static final String LIB_FOLDER = "lib";
    private static final String BOOT_FOLDER = "boot";
    private static final String SECURITY_FOLDER = "conf/security";
    private static final String SECURITY_FILE_ORIGINAL = "java.security";
    private static final String FIPS_SECURITY_FILE_FIPS = "java.fips.security";
    private static final String TRUSTSTORE_ORIGINAL = "cacerts";
    private static final String FIPS_TRUSTSTORE_BCFKS = "cacerts.bcfks";
    private static final String[] FIPS_JAR_FILES = new String[]{"bc-fips.jar", "bcpkix-fips.jar", "bctls-fips.jar", "bcutil-fips.jar"};
    private static final String FIPS_PROVIDER_BCFIPS = "org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider";
    private static final String FIPS_PROVIDER_JSSE = "org.bouncycastle.jsse.provider.BouncyCastleJsseProvider fips:BCFIPS";
    private static final String FIPS_VM_ARG_BCFKS_KEYSTORE = "-Dmule.keystore.type=BCFKS";
    private static final String FIPS_VM_ARG_APPROVED_ONLY = "-Dorg.bouncycastle.fips.approved_only=true";
    private static final String FIPS_VM_ARG_SECURITY_MODEL = "-Dmule.security.model=fips140-2";
    private static final String FIPS_VM_ARG_TRUSTSTORE = "-Djavax.net.ssl.trustStore=";
    private static final String FIPS_VM_ARG_TRUSTSTORE_TYPE = "-Djavax.net.ssl.trustStoreType=BCFKS";
    private static final String FIPS_VM_ARG_SECURITY_PROPERTIES = "-Djava.security.properties==";
    private static final String FIPS_VM_ARG_MODULE_OPENS = "--add-opens=java.base/sun.security.provider=org.bouncycastle.fips.core";
    private static final String FIPS_VM_ARG_BC_DEBUG = "-Dorg.bouncycastle.fips.debug=true";
    private static final String MACOS_JDK_PATH_SUFFIX = "/Contents/Home/conf/security";
    private static final String WINDOWS_JDK_PATH_SUFFIX = "/conf/security";
    private static final String BUNDLE_LOCATION_PREFIX = "reference:file:";
    private static final String ECLIPSE_HOME_PROPERTY = "eclipse.home.location";
    private static final String USER_REPOSITORY_KEY = "user_repository";
    private static final String USER_SETTINGS_KEY = "user_settings";
    private static final String SETTINGS_SECURITY = "settings_security";
    private static final String GLOBAL_SETTINGS_KEY = "global_settings";
    public static final String WRAPPER_ANCHOR_FILENAME = ".wrapper.anchor";
    public static final String MULE_EE_PID_FILENAME = ".mule_ee.pid";
    public static final String MULE_EE_JAVA_PID_FILENAME = ".mule_ee.java.pid";
    private static final String MULE_APP_PID_FILENAME = ".%MULE_APP%.pid";
    private static final String MULE_APP_JAVA_PID_FILENAME = ".%MULE_APP%.java.pid";
    private static final FilenameFilter MULE_FILENAME_FILTER = new MuleFilenameFilter();
    private MuleAgentConfigurer agentConfigurer = new MuleAgentConfigurer();

    public void waitUntilInstanceIsAvailable(MulePathHelper pathHelper, MuleInstanceConfiguration configuration) throws MuleControllerException {
        ArrayList<Path> pathsToCheck = new ArrayList<Path>();
        pathsToCheck.addAll(pathHelper.getWrapperAnchorFile());
        pathsToCheck.addAll(pathHelper.getMuleJavaPid());
        pathsToCheck.addAll(pathHelper.getWrapperPid());
        pathsToCheck.add(pathHelper.getInstanceLock());
        boolean areAllProcessesDone = MuleControllerHelper.areAllProcessesDone(pathHelper, pathsToCheck, configuration);
        MuleControllerHelper.deleteFilesForNextRun(pathHelper, pathsToCheck);
        if (!areAllProcessesDone) {
            throw new ConditionTimeoutException("Pid and anchor files were not deleted on time");
        }
    }

    public void prepareFilesAndFolders(MulePathHelper pathHelper, MuleInstanceConfiguration configuration) throws IOException {
        IPreferenceStore preferenceStore = MuleUIPlugin.getDefault().getPreferenceStore();
        if (preferenceStore.getBoolean("enable_fips_support")) {
            this.copyFipsJarsToLibBoot(pathHelper);
        }
        this.ensureScriptsAreExecutable(pathHelper);
        MuleResourceUtils.cleanDirectory((Path)pathHelper.getAppsPath());
        this.initializeDefaultDomain(pathHelper);
        MuleControllerHelper.initializeAppsFolder(pathHelper);
        if (configuration.isToolingInstance()) {
            MuleResourceUtils.cleanDirectory((Path)pathHelper.getLogsPath());
            MuleResourceUtils.cleanDirectory((Path)pathHelper.getToolingPath());
        } else {
            this.deployStagingArtifacts(pathHelper);
        }
    }

    private void copyFipsJarsToLibBoot(MulePathHelper pathHelper) throws IOException {
        Path libBootDir = pathHelper.getMuleHomePath().resolve(LIB_FOLDER).resolve(BOOT_FOLDER);
        Bundle fipsBundle = Platform.getBundle((String)FIPS_DEPENDENCIES_BUNDLE);
        if (fipsBundle == null) {
            System.out.println("org.mule.tooling.fips.dependencies plugin not found. Skipping FIPS JAR copy.");
            return;
        }
        String[] stringArray = FIPS_JAR_FILES;
        int n = FIPS_JAR_FILES.length;
        int n2 = 0;
        while (n2 < n) {
            block16: {
                String jarName = stringArray[n2];
                try {
                    URL jarUrl = fipsBundle.getEntry("lib/" + jarName);
                    if (jarUrl != null) {
                        Path targetFile = libBootDir.resolve(jarName);
                        Throwable throwable = null;
                        Object var11_13 = null;
                        try (InputStream inputStream = jarUrl.openStream();){
                            try {
                                Files.copy(inputStream, targetFile, new CopyOption[0]);
                            }
                            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                                System.out.println("Target file already exists. Skipping copy operation.");
                            }
                            System.out.println("Copied FIPS JAR from plugin: " + jarName + " to " + String.valueOf(targetFile));
                            break block16;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    System.out.println("FIPS JAR not found in plugin: " + jarName);
                }
                catch (IOException e) {
                    throw new IOException("Failed to copy FIPS JAR from plugin: " + jarName, e);
                }
            }
            ++n2;
        }
    }

    public void configureInstance(MulePathHelper pathHelper, MuleInstanceConfiguration configuration, Integer agentPort, String studioLockFileName, String muleLockFileName) {
        this.initializeWrapperConfig(pathHelper, configuration);
        this.initializeMuleConfig(pathHelper);
        this.agentConfigurer.initializeAgentConfig(pathHelper.getAgentFile(), agentPort, studioLockFileName, muleLockFileName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initializeWrapperConfig(MulePathHelper pathHelper, MuleInstanceConfiguration configuration) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                BufferedReader wrapperConfFileTemplateReader = Files.newBufferedReader(pathHelper.getWrapperConfFileTemplate());
                try {
                    try (BufferedWriter wrapperConfWriter = Files.newBufferedWriter(pathHelper.getWrapperConfFile(), new OpenOption[0]);){
                        PropertiesConfiguration properties = new PropertiesConfiguration();
                        properties.getLayout().load(properties, (Reader)wrapperConfFileTemplateReader);
                        Map<String, Object> confOverrideProperties = this.getWrapperConfOverrideProperties(pathHelper, configuration, configuration.getJavaHome());
                        confOverrideProperties.forEach((key, value) -> properties.setProperty(key, value));
                        this.putJavaAdditionalProperty(properties, "-XX:OnOutOfMemoryError=" + (String)(OsDetect.isWindows() ? "\"taskkill /F /PID %p\"" : "\"" + String.valueOf(pathHelper.getBinPath().resolve("kill.sh")) + "\" %p"));
                        String maxMetaspace = configuration.getVmArguments().stream().filter(vmarg -> vmarg.contains(MAX_METASPACE)).findFirst().orElse("-XX:MaxMetaspaceSize=1g");
                        if (properties.getString(WRAPPER_JAVA_ADDITIONAL_MAX_METASPACE, "").contains(MAX_METASPACE)) {
                            properties.setProperty(WRAPPER_JAVA_ADDITIONAL_MAX_METASPACE, (Object)maxMetaspace);
                        } else {
                            this.putJavaAdditionalProperty(properties, maxMetaspace);
                        }
                        properties.getLayout().save(properties, (Writer)wrapperConfWriter);
                    }
                    if (wrapperConfFileTemplateReader == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (wrapperConfFileTemplateReader == null) throw throwable;
                    ((Reader)wrapperConfFileTemplateReader).close();
                    throw throwable;
                }
                ((Reader)wrapperConfFileTemplateReader).close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException | ConfigurationException e) {
            throw new MuleControllerException("Error while initializing wrapper conf...", e);
        }
    }

    private Map<String, Object> getWrapperConfOverrideProperties(MulePathHelper pathHelper, MuleInstanceConfiguration configuration, String javaHome) {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        properties.put(WRAPPER_JAVA_COMMAND, MuleControllerHelper.getJavaCommand(javaHome));
        properties.put(WRAPPER_PIDFILE, MULE_APP_PID_FILENAME);
        properties.put(WRAPPER_ANCHORFILE, WRAPPER_ANCHOR_FILENAME);
        properties.put(WRAPPER_CONSOLE_FLUSH, Boolean.TRUE.toString().toUpperCase());
        properties.put(WRAPPER_DISABLE_RESTARTS, Boolean.TRUE.toString().toUpperCase());
        if (configuration.isToolingInstance()) {
            properties.put(WRAPPER_JAVA_INITMEMORY, Platform.getPreferencesService().getInt(TOOLING_CLIENT_BUNDLE_ID, TOOLING_CLIENT_INIT_MEMORY, 512, null));
        }
        List<String> vmArguments = configuration.getVmArguments();
        for (String vmArgument : vmArguments) {
            if (vmArgument.startsWith("-Xms")) {
                properties.put(WRAPPER_JAVA_INITMEMORY, 0);
                continue;
            }
            if (!vmArgument.startsWith("-Xmx")) continue;
            properties.put(WRAPPER_JAVA_MAXMEMORY, 0);
        }
        properties.put(WRAPPER_JAVA_PIDFILE, MULE_APP_JAVA_PID_FILENAME);
        return properties;
    }

    private void putJavaAdditionalProperty(PropertiesConfiguration propertiesConfiguration, String value) {
        Integer number = WRAPPER_JAVA_ADDITIONAL_DEFAULT_NUMBER;
        String key = WRAPPER_JAVA_ADDITIONAL + String.valueOf(number);
        while (propertiesConfiguration.containsKey(key)) {
            if (WRAPPER_JAVA_ADDITIONAL_RESERVED.contains((Comparable)(number = Integer.valueOf(number + 1)))) {
                number = (Integer)WRAPPER_JAVA_ADDITIONAL_RESERVED.upperEndpoint() + 1;
            }
            key = WRAPPER_JAVA_ADDITIONAL + String.valueOf(number);
        }
        propertiesConfiguration.addProperty(key, (Object)value);
    }

    private static String getJavaCommand(String javaHomeProperty) {
        File javaHome = new File(javaHomeProperty);
        if (UtilsPlugin.isRunningJdk()) {
            javaHome = MuleControllerHelper.resolveJdkHomeDirectory(javaHome);
        }
        return MuleControllerHelper.getJavaBinaryFromHome(javaHome).getAbsolutePath();
    }

    private static File resolveJdkHomeDirectory(File javaHome) {
        File parentFile;
        File potentialJavaBinary;
        if (JDK_FOLDER_JRE.equals(javaHome.getName()) && (potentialJavaBinary = MuleControllerHelper.getJavaBinaryFromHome(parentFile = javaHome.getParentFile())).exists() && potentialJavaBinary.canExecute()) {
            javaHome = parentFile;
        }
        return javaHome;
    }

    private static File getJavaBinaryFromHome(File javaHome) {
        return javaHome.toPath().resolve(JDK_FOLDER_BIN).resolve(MuleControllerHelper.getJavaProgramName()).toFile();
    }

    private static String getJavaProgramName() {
        return OsDetect.isWindows() ? JAVA_BINARY_WINDOWS : JAVA_BINARY_OTHER;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initializeMuleConfig(MulePathHelper pathHelper) {
        try {
            MavenConfiguration mavenConfiguration = MavenConfiguration.instance();
            Optional userSettings = mavenConfiguration.getUserSettingsPath();
            Optional securitySettings = mavenConfiguration.getSettingsSecurityPath();
            Optional globalSettings = mavenConfiguration.getGlobalSettingsPath();
            String userRepository = mavenConfiguration.getLocalRepositoryPath();
            Throwable throwable = null;
            Object var8_10 = null;
            try {
                FileReader templateReader = new FileReader(pathHelper.getMuleConfigFileTemplate().toFile());
                try {
                    try (BufferedWriter targetWriter = Files.newBufferedWriter(pathHelper.getMuleConfigFile(), new OpenOption[0]);){
                        LinkedList<Object> contextKeyValues = new LinkedList<Object>();
                        contextKeyValues.add(USER_REPOSITORY_KEY);
                        contextKeyValues.add(StringEscapeUtils.escapeJson((String)userRepository));
                        userSettings.ifPresent(file -> {
                            contextKeyValues.add(USER_SETTINGS_KEY);
                            contextKeyValues.add(StringEscapeUtils.escapeJson((String)file));
                        });
                        securitySettings.ifPresent(file -> {
                            contextKeyValues.add(SETTINGS_SECURITY);
                            contextKeyValues.add(StringEscapeUtils.escapeJson((String)file));
                        });
                        globalSettings.ifPresent(file -> {
                            contextKeyValues.add(GLOBAL_SETTINGS_KEY);
                            contextKeyValues.add(StringEscapeUtils.escapeJson((String)file));
                        });
                        contextKeyValues.add(IGNORE_ARTIFACT_DESCRIPTOR_REPOSITORIES);
                        contextKeyValues.add(MavenCore.isIgnoringProjectRepositories());
                        contextKeyValues.add(OFFLINE_MODE);
                        contextKeyValues.add(MavenCore.isOfflineMode());
                        MuleResourceUtils.executeVelocityTemplate((ClassLoader)MuleControllerHelper.class.getClassLoader(), (Reader)templateReader, (Writer)targetWriter, (Object[])contextKeyValues.toArray());
                    }
                    if (templateReader == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (templateReader == null) throw throwable;
                    ((Reader)templateReader).close();
                    throw throwable;
                }
                ((Reader)templateReader).close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new MuleControllerException("Error while initializing mule config...", e);
        }
    }

    private void initializeDefaultDomain(MulePathHelper pathHelper) throws IOException {
        Path defaultDomainPath = pathHelper.getDefaultDomainPath();
        MuleControllerHelper.createIfDoesntExists(defaultDomainPath);
    }

    public static void initializeAppsFolder(MulePathHelper pathHelper) throws IOException {
        Path appsPath = pathHelper.getAppsPath();
        MuleControllerHelper.createIfDoesntExists(appsPath);
    }

    private static void createIfDoesntExists(Path appsPath) throws IOException {
        if (!Files.exists(appsPath, new LinkOption[0])) {
            Files.createDirectories(appsPath, new FileAttribute[0]);
        }
    }

    private void ensureScriptsAreExecutable(MulePathHelper pathHelper) {
        File binDir = pathHelper.getBinPath().toFile();
        File[] fileArray = binDir.listFiles(MULE_FILENAME_FILTER);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File currentFile = fileArray[n2];
            MuleControllerHelper.ensureScriptIsExecutable(currentFile);
            ++n2;
        }
        File libBootExecDir = pathHelper.getLibBootExecPath().toFile();
        File[] fileArray2 = libBootExecDir.listFiles();
        int n3 = fileArray2.length;
        n = 0;
        while (n < n3) {
            File currentFile = fileArray2[n];
            MuleControllerHelper.ensureScriptIsExecutable(currentFile);
            ++n;
        }
    }

    private static boolean isThereAnyProcessRunning(List<Path> pathsToCheck) {
        return pathsToCheck.stream().filter(path -> Files.exists(path, new LinkOption[0]) && path.getFileName().toString().endsWith("pid")).anyMatch(path -> {
            try {
                int pid = Integer.parseInt(FileUtils.readFileToString((File)path.toFile()).trim());
                Optional<ProcessHandle> processHandleOpt = ProcessHandle.of(pid);
                return processHandleOpt.isPresent() && processHandleOpt.get().isAlive();
            }
            catch (NumberFormatException e) {
                MuleCorePlugin.logWarning((String)"Issue while trying to parse pid file", (Throwable)e);
                return false;
            }
            catch (IOException e) {
                MuleCorePlugin.logWarning((String)"Issue while trying to check pid liveness", (Throwable)e);
                return false;
            }
        });
    }

    private static void deleteFilesForNextRun(MulePathHelper pathHelper, List<Path> pidFilesPaths) {
        for (Path filePath : pidFilesPaths) {
            try {
                Files.deleteIfExists(filePath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean areAllProcessesDone(MulePathHelper pathHelper, List<Path> pidFilesPaths, MuleInstanceConfiguration configuration) {
        try {
            Awaitility.with().timeout((long)configuration.getCheckExistingProcessTimeout(), TimeUnit.SECONDS).until(() -> !MuleControllerHelper.isThereAnyProcessRunning(pidFilesPaths));
            return true;
        }
        catch (ConditionTimeoutException conditionTimeoutException) {
            return false;
        }
    }

    private void deployStagingArtifacts(MulePathHelper pathHelper) throws IOException {
        MuleControllerHelper.deployStagingArtifacts(pathHelper.getAppsPath());
        MuleControllerHelper.deployStagingArtifacts(pathHelper.getDomainsPath());
    }

    private static void deployStagingArtifacts(Path artifactsPath) throws IOException {
        File stagingAppsFolder = DeploymentHelper.getStagingFolder((File)artifactsPath.toFile());
        File[] appsToDeploy = stagingAppsFolder.listFiles();
        if (appsToDeploy != null) {
            File[] fileArray = appsToDeploy;
            int n = appsToDeploy.length;
            int n2 = 0;
            while (n2 < n) {
                File app = fileArray[n2];
                FileUtils.copyFile((File)app, (File)artifactsPath.resolve(app.getName()).toFile());
                ++n2;
            }
        }
    }

    private static void ensureScriptIsExecutable(File currentFile) {
        if (!currentFile.canExecute()) {
            try {
                boolean success = currentFile.setExecutable(true);
                if (!success) {
                    throw new MuleControllerException(currentFile.getAbsolutePath() + " cannot be made executable. Please try again with admin permissions.");
                }
            }
            catch (SecurityException securityException) {
                throw new MuleControllerException(currentFile.getAbsolutePath() + " cannot be made executable. Please try again with admin permissions.");
            }
        }
    }

    public static List<String> getInitialVMArguments() {
        ArrayList<String> vmArguments = new ArrayList<String>();
        IPreferenceStore preferenceStore = MuleUIPlugin.getDefault().getPreferenceStore();
        if (preferenceStore.getBoolean("enable_fips_support")) {
            vmArguments.addAll(MuleControllerHelper.getFipsVMArguments());
        }
        Optional.ofNullable(System.getProperty(ADDITIONAL_ARGS_PROP)).ifPresent(args -> vmArguments.addAll(Arrays.stream(args.split(",")).map(param -> MuleController.prepend("-M", param)).collect(Collectors.toList())));
        return vmArguments;
    }

    private static List<String> getFipsVMArguments() {
        String fipsSecurityPropertiesPath;
        ArrayList<String> fipsArgs = new ArrayList<String>();
        fipsArgs.add(FIPS_VM_ARG_APPROVED_ONLY);
        fipsArgs.add(FIPS_VM_ARG_SECURITY_MODEL);
        String bcfksTruststorePath = MuleControllerHelper.getBCFKSTruststorePath();
        if (bcfksTruststorePath != null) {
            fipsArgs.add(FIPS_VM_ARG_TRUSTSTORE + bcfksTruststorePath);
            fipsArgs.add(FIPS_VM_ARG_TRUSTSTORE_TYPE);
            fipsArgs.add(FIPS_VM_ARG_BCFKS_KEYSTORE);
        }
        if ((fipsSecurityPropertiesPath = MuleControllerHelper.getFipsSecurityPropertiesPath()) != null) {
            String securityArg = FIPS_VM_ARG_SECURITY_PROPERTIES + fipsSecurityPropertiesPath;
            fipsArgs.add(securityArg);
        }
        fipsArgs.add(FIPS_VM_ARG_MODULE_OPENS);
        return fipsArgs;
    }

    private static String getFipsSecurityPropertiesPath() {
        Path javaSecurityFile;
        Path jdkSecurityDir;
        block5: {
            try {
                jdkSecurityDir = MuleControllerHelper.findEmbeddedJdkSecurityDirectoryStatic();
                if (jdkSecurityDir != null) break block5;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        Path fipsSecurityFile = jdkSecurityDir.resolve(FIPS_SECURITY_FILE_FIPS);
        if (!Files.exists(fipsSecurityFile, new LinkOption[0]) && Files.exists(javaSecurityFile = jdkSecurityDir.resolve(SECURITY_FILE_ORIGINAL), new LinkOption[0])) {
            MuleControllerHelper.createFipsSecurityFile(javaSecurityFile, fipsSecurityFile);
        }
        if (Files.exists(fipsSecurityFile, new LinkOption[0])) {
            return fipsSecurityFile.toAbsolutePath().toString();
        }
        return null;
    }

    private static Path findOriginalCacerts(Path securityDir) {
        Path libSecurityDir;
        String[] cacertsNames;
        String[] stringArray = cacertsNames = new String[]{TRUSTSTORE_ORIGINAL, "cacerts.jks", "cacerts.p12"};
        int n = cacertsNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            Path cacertsPath = securityDir.resolve(name);
            if (Files.exists(cacertsPath, new LinkOption[0])) {
                return cacertsPath;
            }
            ++n2;
        }
        Path parentDir = securityDir.getParent();
        if (parentDir != null && parentDir.getFileName().toString().equals("conf") && Files.exists(libSecurityDir = parentDir.getParent().resolve(LIB_FOLDER).resolve("security"), new LinkOption[0])) {
            String[] stringArray2 = cacertsNames;
            int n3 = cacertsNames.length;
            int n4 = 0;
            while (n4 < n3) {
                String name = stringArray2[n4];
                Path cacertsPath = libSecurityDir.resolve(name);
                if (Files.exists(cacertsPath, new LinkOption[0])) {
                    return cacertsPath;
                }
                ++n4;
            }
        }
        return null;
    }

    private static String getBCFKSTruststorePath() {
        Path originalCacerts;
        Path jdkSecurityDir;
        block5: {
            try {
                jdkSecurityDir = MuleControllerHelper.findEmbeddedJdkSecurityDirectoryStatic();
                if (jdkSecurityDir != null) break block5;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        Path bcfksTruststore = jdkSecurityDir.resolve(FIPS_TRUSTSTORE_BCFKS);
        if (!Files.exists(bcfksTruststore, new LinkOption[0]) && (originalCacerts = MuleControllerHelper.findOriginalCacerts(jdkSecurityDir)) != null) {
            MuleControllerHelper.convertKeystoreToBCFKS(originalCacerts, bcfksTruststore);
        }
        if (Files.exists(bcfksTruststore, new LinkOption[0])) {
            return bcfksTruststore.toAbsolutePath().toString();
        }
        return null;
    }

    private static Path findEmbeddedJdkSecurityDirectoryStatic() {
        Path bundlePath;
        Bundle jdkBundle;
        block12: {
            try {
                String os = Platform.getOS();
                String arch = Platform.getOSArch();
                String jdkBundleId = FIPS_BUNDLE_JDK_PREFIX + os + "." + arch;
                jdkBundle = Platform.getBundle((String)jdkBundleId);
                if (jdkBundle != null) break block12;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        String bundleLocation = jdkBundle.getLocation();
        if (bundleLocation.startsWith(BUNDLE_LOCATION_PREFIX)) {
            bundleLocation = bundleLocation.substring(BUNDLE_LOCATION_PREFIX.length());
        }
        if (Paths.get(bundleLocation, new String[0]).isAbsolute()) {
            bundlePath = Paths.get(bundleLocation, new String[0]);
        } else {
            String eclipseHome = System.getProperty(ECLIPSE_HOME_PROPERTY);
            if (eclipseHome != null) {
                if (eclipseHome.startsWith("file:")) {
                    eclipseHome = eclipseHome.substring("file:".length());
                }
                if (Platform.getOS().equals("win32")) {
                    if (eclipseHome.matches("^/[A-Za-z]:.*")) {
                        eclipseHome = eclipseHome.substring(1);
                    }
                    eclipseHome = eclipseHome.replace('\\', '/');
                    bundleLocation = bundleLocation.replace('\\', '/');
                }
                bundlePath = Paths.get(eclipseHome, bundleLocation);
            } else {
                bundlePath = Paths.get(bundleLocation, new String[0]).toAbsolutePath();
            }
        }
        Path securityDir = Platform.getOS().equals("win32") ? bundlePath.resolve("conf").resolve("security") : bundlePath.resolve("Contents").resolve("Home").resolve("conf").resolve("security");
        if (Files.exists(securityDir, new LinkOption[0]) && Files.isDirectory(securityDir, new LinkOption[0])) {
            return securityDir;
        }
        return null;
    }

    private static void convertKeystoreToBCFKS(Path sourceKeystore, Path targetKeystore) throws Exception {
        KeyStore sourceKS = MuleControllerHelper.loadKeystore(sourceKeystore, null);
        if (sourceKS == null) {
            throw new Exception("Could not load source keystore with any supported format");
        }
        KeyStore bcfksKS = KeyStore.getInstance("BCFKS");
        bcfksKS.load(null, null);
        Enumeration<String> aliases = sourceKS.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!sourceKS.isCertificateEntry(alias)) continue;
            Certificate cert = sourceKS.getCertificate(alias);
            bcfksKS.setCertificateEntry(alias, cert);
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try (FileOutputStream fos = new FileOutputStream(targetKeystore.toFile());){
            bcfksKS.store(fos, null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static KeyStore loadKeystore(Path keystorePath, char[] password) {
        String[] keystoreTypes;
        String[] stringArray = keystoreTypes = new String[]{"JKS", "PKCS12", "JCEKS"};
        int n = keystoreTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            try {
                KeyStore ks = KeyStore.getInstance(type);
                Throwable throwable = null;
                Object var9_10 = null;
                try (FileInputStream fis = new FileInputStream(keystorePath.toFile());){
                    ks.load(fis, null);
                    return ks;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {
                ++n2;
            }
        }
        return null;
    }

    private static void createFipsSecurityFile(Path sourceFile, Path targetFile) throws IOException {
        System.out.println("Creating FIPS security file...");
        System.out.println("  Source: " + String.valueOf(sourceFile));
        System.out.println("  Target: " + String.valueOf(targetFile));
        List<String> lines = Files.readAllLines(sourceFile);
        System.out.println("  Read " + lines.size() + " lines from source file");
        ArrayList<String> modifiedLines = new ArrayList<String>();
        boolean fipsProvidersAdded = false;
        int providersReplaced = 0;
        for (String line : lines) {
            String trimmedLine = line.trim();
            if (trimmedLine.startsWith("security.provider.")) {
                if (!fipsProvidersAdded) {
                    modifiedLines.add("security.provider.1=org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider");
                    modifiedLines.add("security.provider.2=org.bouncycastle.jsse.provider.BouncyCastleJsseProvider fips:BCFIPS");
                    fipsProvidersAdded = true;
                    System.out.println("  Added FIPS providers");
                }
                ++providersReplaced;
                continue;
            }
            modifiedLines.add(line);
        }
        if (!fipsProvidersAdded) {
            modifiedLines.add("");
            modifiedLines.add("# FIPS Security Providers");
            modifiedLines.add("security.provider.1=org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider");
            modifiedLines.add("security.provider.2=org.bouncycastle.jsse.provider.BouncyCastleJsseProvider fips:BCFIPS");
        }
        System.out.println("  Replaced " + providersReplaced + " security providers");
        System.out.println("  Final file will have " + modifiedLines.size() + " lines");
        Files.write(targetFile, modifiedLines, new OpenOption[0]);
        System.out.println("  File written successfully");
    }

    private static final class MuleFilenameFilter
    implements FilenameFilter {
        private static final String SH = "sh";
        private static final String CMD = "cmd";
        private static final String BAT = "bat";

        private MuleFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            String extension = FilenameUtils.getExtension((String)name);
            String string = extension = extension != null ? extension.toLowerCase() : "";
            return extension.endsWith(CMD) || extension.endsWith(BAT) || extension.endsWith(SH) || StringUtils.isBlank((String)extension);
        }
    }
}

