/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.runtime.controller;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.core.deployer.DeploymentHelper;
import org.mule.tooling.core.io.MuleResourceUtils;
import org.mule.tooling.runtime.controller.IMuleInstance;
import org.mule.tooling.runtime.controller.MuleControllerException;
import org.mule.tooling.runtime.controller.MuleControllerHelper;
import org.mule.tooling.runtime.controller.MuleInstance;
import org.mule.tooling.runtime.controller.MuleInstanceConfiguration;
import org.mule.tooling.runtime.controller.MulePathHelper;
import org.mule.tooling.runtime.launch.termination.DeleteAnchorCommand;
import org.mule.tooling.runtime.launch.termination.KillProcessCommand;
import org.mule.tooling.runtime.launch.termination.RetryWithDelayTimes;
import org.mule.tooling.runtime.launch.termination.StopCommand;
import org.mule.tooling.runtime.launch.termination.StudioManagementServiceTerminationCommand;
import org.mule.tooling.runtime.launch.termination.TerminationCommand;
import org.mule.tooling.runtime.launch.termination.TerminationCommandBuilder;
import org.mule.tooling.runtime.service.MuleAgentServices;
import org.mule.tooling.utils.networking.SocketUtils;

public class MuleController {
    private static final String CONSOLE = "console";
    private static final String MULE_HOME = "MULE_HOME";
    private static final String MULE_TESTING_MODE = "-M-Dmule.testingMode";
    private static final String MULE_FORCE_CONSOLE_LOG = "-M-Dmule.forceConsoleLog";
    public static final String INSTANCE_LOCK = "Instance.lock";
    private IMuleInstance instance;
    private final MulePathHelper pathHelper;
    private final MuleControllerHelper muleControllerHelper;
    private Process process;
    private MuleChecker checker;
    private MuleAgentServices agentServices;
    private ToolingProcessRedirect toolingProcessRedirect;
    private AtomicBoolean runningFlag = new AtomicBoolean();
    private File studioLockFile;
    private FileLock studioLock;
    private RandomAccessFile studioLockRAF;
    private boolean debugMode;
    private Optional<Integer> maybeDebugPort;

    public MuleController(MulePathHelper pathHelper, MuleControllerHelper muleControllerHelper) {
        this.pathHelper = pathHelper;
        this.muleControllerHelper = muleControllerHelper;
        this.maybeDebugPort = Optional.empty();
    }

    public synchronized IMuleInstance start(MuleInstanceConfiguration configuration) throws MuleControllerException {
        if (this.runningFlag.compareAndSet(false, true)) {
            Integer debugPort = null;
            Integer agentPort = SocketUtils.findFreePort();
            String studioLockFileName = "studio-" + UUID.randomUUID().toString();
            String muleLockFileName = "mule-" + UUID.randomUUID().toString();
            Path crashFile = this.pathHelper.getLogsPath().resolve("err_" + muleLockFileName + ".log");
            Path oomFile = this.pathHelper.getLogsPath().resolve("dump_" + muleLockFileName + ".hprof");
            try {
                try {
                    this.muleControllerHelper.waitUntilInstanceIsAvailable(this.pathHelper, configuration);
                    this.muleControllerHelper.prepareFilesAndFolders(this.pathHelper, configuration);
                    this.muleControllerHelper.configureInstance(this.pathHelper, configuration, agentPort, studioLockFileName, muleLockFileName);
                    List<String> vmArguments = configuration.getVmArguments();
                    if (configuration.isTrackCrash()) {
                        vmArguments.add("-XX:ErrorFile=\"" + String.valueOf(crashFile) + "\"");
                        vmArguments.add("-XX:HeapDumpPath=\"" + String.valueOf(oomFile) + "\"");
                    }
                    List<String> programArguments = configuration.getProgramArguments();
                    ArrayList<String> commandList = new ArrayList<String>(Arrays.asList(this.pathHelper.getBinaryFile().toString(), CONSOLE, MULE_FORCE_CONSOLE_LOG, MULE_TESTING_MODE));
                    commandList.addAll(programArguments.stream().map(param -> MuleController.prepend("-M", param)).collect(Collectors.toList()));
                    commandList.addAll(vmArguments.stream().map(param -> MuleController.prepend("-M", param)).collect(Collectors.toList()));
                    this.debugMode = configuration.isDebugMode();
                    if (this.debugMode) {
                        debugPort = this.getConfiguredOrAvailableDebugPort(configuration);
                        this.maybeDebugPort = Optional.of(debugPort);
                        System.out.println("Mule runtime launched with debugging port on " + String.valueOf(debugPort));
                        String debuggingServerCommand = this.getDebuggingServerCommandTemplate();
                        String suspendOption = configuration.isSuspend() ? "y" : "n";
                        commandList.add(String.format(debuggingServerCommand, suspendOption, debugPort));
                    }
                    ProcessBuilder processBuilder = new ProcessBuilder(commandList);
                    processBuilder.directory(this.pathHelper.getBinPath().toFile());
                    Map<String, String> environmentVariables = configuration.getEnvironmentVariables();
                    environmentVariables.putIfAbsent(MULE_HOME, this.pathHelper.getMuleHomePath().toString());
                    processBuilder.environment().putAll(environmentVariables);
                    if (configuration.isToolingInstance()) {
                        processBuilder.redirectErrorStream(true);
                    }
                    this.studioLockFile = new File(System.getProperty("java.io.tmpdir"), studioLockFileName);
                    this.studioLockFile.deleteOnExit();
                    this.studioLockRAF = new RandomAccessFile(this.studioLockFile, "rw");
                    FileChannel fileChannel = this.studioLockRAF.getChannel();
                    this.studioLock = fileChannel.lock();
                    this.process = processBuilder.start();
                    File instanceLockFile = this.getInstanceFile();
                    instanceLockFile.createNewFile();
                    this.agentServices = MuleAgentServices.getInstance(agentPort, configuration.getAgentToken());
                    if (configuration.isToolingInstance()) {
                        this.toolingProcessRedirect = new ToolingProcessRedirect(this.process);
                        this.toolingProcessRedirect.setDaemon(true);
                        this.toolingProcessRedirect.start();
                        Awaitility.with().timeout((long)configuration.getStartupTimeout(), TimeUnit.SECONDS).until(() -> this.agentServices.isToolingUp());
                    }
                    this.checker = new MuleChecker(this.process, muleLockFileName, crashFile, oomFile, configuration, this.runningFlag);
                    this.checker.setDaemon(true);
                    this.checker.start();
                    this.instance = new MuleInstance(this.process, agentPort, debugPort, this.pathHelper, configuration.getAgentToken());
                }
                catch (Exception e) {
                    this.runningFlag.set(false);
                    MuleAgentServices.release(agentPort);
                    if (this.process != null) {
                        this.process.destroyForcibly();
                    }
                    if (e instanceof ConditionTimeoutException) {
                        this.stop();
                        throw new MuleControllerException("Timeout while starting mule instance", e);
                    }
                    throw new MuleControllerException("There was an error while starting instance", e);
                }
            }
            finally {
                File stagingAppsFolder = DeploymentHelper.getStagingFolder((File)this.pathHelper.getAppsPath().toFile());
                MuleResourceUtils.cleanDirectory((Path)stagingAppsFolder.toPath());
            }
        }
        return this.instance;
    }

    protected Integer getConfiguredOrAvailableDebugPort(MuleInstanceConfiguration configuration) {
        Integer debugPort;
        if (configuration.isDebugPortConfigured()) {
            debugPort = configuration.getDebugPort();
            if (!SocketUtils.isPortAvailable((int)debugPort)) {
                debugPort = SocketUtils.findFreePort();
            }
        } else {
            debugPort = SocketUtils.findFreePort();
        }
        return debugPort;
    }

    protected String getDebuggingServerCommandTemplate() {
        String debuggingServerCommand = "-M-agentlib:jdwp=transport=dt_socket,server=y,suspend=%s,address=%s";
        if (System.getProperty("debug.oldConnection") != null) {
            debuggingServerCommand = "-M-Xrunjdwp:transport=dt_socket,server=y,suspend=%s,address=%s";
        }
        return debuggingServerCommand;
    }

    static String prepend(String prefix, String param) {
        return param.startsWith(prefix) ? param : prefix + param;
    }

    public boolean isRunning() {
        return this.runningFlag.get();
    }

    public synchronized void stop() throws MuleControllerException {
        try {
            try {
                boolean isAlive;
                if (this.checker != null) {
                    this.checker.interrupt();
                }
                if (this.process != null) {
                    this.process.destroyForcibly();
                }
                boolean bl = isAlive = this.agentServices != null && this.agentServices.isAlive();
                if (this.studioLock.isValid()) {
                    this.studioLock.release();
                }
                this.studioLockRAF.close();
                this.studioLockFile.delete();
                TerminationCommandBuilder builder = new TerminationCommandBuilder().watching(() -> !isAlive ? true : this.agentServices.isAlive());
                if (isAlive) {
                    builder = builder.with(new RetryWithDelayTimes(new StudioManagementServiceTerminationCommand(this.agentServices), 5, 100));
                }
                TerminationCommand terminationCommand = builder.with(new StopCommand(this.pathHelper.getBinaryFile().toString())).with(new DeleteAnchorCommand(this.pathHelper.getWrapperAnchorFile())).with(this.buildKillProcessCommands(this.pathHelper)).build();
                terminationCommand.execute();
            }
            catch (Exception e) {
                throw new MuleControllerException("There was an error while stopping instance", e);
            }
        }
        finally {
            this.runningFlag.set(false);
            this.getInstanceFile().delete();
            if (this.instance != null) {
                MuleAgentServices.release(this.instance.getAgentPort());
            }
            MuleResourceUtils.cleanDirectory((Path)this.pathHelper.getAppsPath());
        }
    }

    private TerminationCommand[] buildKillProcessCommands(MulePathHelper pathHelper) {
        return (TerminationCommand[])Stream.concat(pathHelper.getMuleJavaPid().stream(), pathHelper.getWrapperPid().stream()).map(pidPath -> new KillProcessCommand((Path)pidPath)).toArray(TerminationCommand[]::new);
    }

    private File getInstanceFile() {
        return new File(this.pathHelper.getMuleHomePath().toFile(), INSTANCE_LOCK);
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public int getDebugPort() {
        return this.maybeDebugPort.orElse(-1);
    }

    private static class MuleChecker
    extends Thread {
        private static final long MULE_CHECKER_INITIAL_WAIT = TimeUnit.MINUTES.toMillis(Integer.getInteger("muleChecker.initialWait", 2).intValue());
        private static final long MULE_CHECKER_INTERVAL = TimeUnit.MILLISECONDS.toMillis(Integer.getInteger("muleChecker.interval", 500).intValue());
        private static final String JAVA_IO_TMPDIR = "java.io.tmpdir";
        private Process process;
        private String muleLockFileName;
        private AtomicBoolean runningFlag;
        private Path crashFile;
        private Path oomFile;
        private MuleInstanceConfiguration config;
        private boolean checked;

        public MuleChecker(Process process, String muleLockFileName, Path crashFile, Path oomFile, MuleInstanceConfiguration config, AtomicBoolean runningFlag) {
            super("Mule Checker");
            this.process = process;
            this.muleLockFileName = muleLockFileName;
            this.crashFile = crashFile;
            this.oomFile = oomFile;
            this.config = config;
            this.runningFlag = runningFlag;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(MULE_CHECKER_INITIAL_WAIT);
                Throwable throwable = null;
                Object var2_3 = null;
                try (RandomAccessFile muleLockFile = new RandomAccessFile(new File(System.getProperty(JAVA_IO_TMPDIR), this.muleLockFileName), "rw");){
                    FileChannel fileChannel = muleLockFile.getChannel();
                    while (!Thread.currentThread().isInterrupted()) {
                        Throwable throwable2 = null;
                        Object var6_9 = null;
                        try (FileLock muleLock = fileChannel.tryLock();){
                            if (muleLock != null) {
                                this.runningFlag.set(false);
                                this.checkForCrash();
                                this.process.destroyForcibly();
                                Thread.currentThread().interrupt();
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                        Thread.sleep(MULE_CHECKER_INTERVAL);
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {
                this.runningFlag.set(false);
                this.checkForCrash();
                this.process.destroyForcibly();
            }
        }

        private void checkForCrash() {
            if (!this.config.isTrackCrash() || this.checked) {
                return;
            }
            this.checked = true;
            if (Files.exists(this.oomFile, new LinkOption[0])) {
                this.trackCrash(true);
            } else if (Files.exists(this.crashFile, new LinkOption[0])) {
                this.trackCrash(false);
            }
        }

        private void trackCrash(boolean oom) {
            AnalyticsRecordsFactory single = AnalyticsRecordsFactory.single((String)Events.MULE_CRASH).addMetadata("runtimeVersion", this.config.getRuntimeVersion()).addMetadata("outOfMemoryError", Boolean.toString(oom)).addMetadata("isToolingInstance", Boolean.toString(this.config.isToolingInstance()));
            if (this.config.isDebugMode()) {
                single.addMetadata("debuggerVersion", this.config.getDebuggerVersion());
            }
            single.track();
        }
    }

    private static final class NullOutputStream
    extends OutputStream {
        public static final NullOutputStream INSTANCE = new NullOutputStream();

        private NullOutputStream() {
        }

        @Override
        public void write(byte[] b, int off, int len) {
        }

        @Override
        public void write(int b) {
        }

        @Override
        public void write(byte[] b) throws IOException {
        }
    }

    private static final class ToolingProcessRedirect
    extends Thread {
        private static final int DEFAULT_SIZE = 1024;
        private Process process;

        public ToolingProcessRedirect(Process process) {
            super("Tooling Process Redirect");
            this.process = process;
        }

        @Override
        public void run() {
            try {
                int length;
                NullOutputStream out = NullOutputStream.INSTANCE;
                InputStream is = this.process.getInputStream();
                byte[] buffer = new byte[1024];
                while ((length = is.read(buffer)) > 0) {
                    ((OutputStream)out).write(buffer, 0, length);
                }
            }
            catch (Exception exception) {}
        }
    }
}

