/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.runtime.controller;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.mule.tooling.runtime.controller.MuleControllerException;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class MuleAgentConfigurer {
    private static final String ENABLED = "enabled";
    private static final String PORT = "port";
    private static final String HOST = "host";
    private static final String MULE_LOCK_FILE_NAME = "muleLockFileName";
    private static final String STUDIO_LOCK_FILE_NAME = "studioLockFileName";
    private static final String STUDIO_CHECKER_ENABLED = "studioCheckerEnabled";

    public void initializeAgentConfig(Path agentFilePath, int agentPort, String studioLockFileName, String muleLockFileName) {
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (BufferedReader agentConfFile = Files.newBufferedReader(agentFilePath);){
                DumperOptions options = new DumperOptions();
                options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
                options.setPrettyFlow(true);
                options.setExplicitStart(true);
                Yaml yaml = new Yaml(options);
                HashMap<String, Object> config = (HashMap<String, Object>)yaml.load((Reader)agentConfFile);
                if (config == null) {
                    config = new HashMap<String, Object>();
                }
                Map<String, Object> transports = this.getOrPut(config, "transports");
                Map<String, Object> restAgentTransport = this.getOrPut(transports, "rest.agent.transport");
                restAgentTransport.put(HOST, InetAddress.getLoopbackAddress().getHostAddress());
                restAgentTransport.put(PORT, agentPort);
                restAgentTransport.put(ENABLED, true);
                Map<String, Object> services = this.getOrPut(config, "services");
                Map<String, Object> studioService = this.getOrPut(services, "mule.agent.studio.service");
                studioService.put(STUDIO_CHECKER_ENABLED, true);
                studioService.put(STUDIO_LOCK_FILE_NAME, studioLockFileName);
                studioService.put(MULE_LOCK_FILE_NAME, muleLockFileName);
                Throwable throwable2 = null;
                Object var16_20 = null;
                try (BufferedWriter writer = Files.newBufferedWriter(agentFilePath, new OpenOption[0]);){
                    yaml.dump(config, (Writer)writer);
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new MuleControllerException("Error while initializing mule agent conf...", e);
        }
    }

    private Map<String, Object> getOrPut(Map<String, Object> config, String key) {
        return (Map)config.computeIfAbsent(key, x -> new HashMap());
    }
}

