/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.runtime.builder;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.StudioDesignContextRunner;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.core.auth.AuthUser;
import org.mule.tooling.core.builder.ICleanerDelegate;
import org.mule.tooling.core.builder.MuleBuilderExtensionProvider;
import org.mule.tooling.core.deployer.DeploymentHelper;
import org.mule.tooling.core.deployer.MuleApplicationDeployment;
import org.mule.tooling.core.impl.model.DomainUtils;
import org.mule.tooling.core.m2.dependency.MavenCoordinates;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.core.model.IMuleDomainProject;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.core.utils.VMUtils;
import org.mule.tooling.model.messageflow.CommentContainer;
import org.mule.tooling.model.messageflow.EndpointNode;
import org.mule.tooling.model.messageflow.GlobalUnknown;
import org.mule.tooling.model.messageflow.IReadOnlyProperty;
import org.mule.tooling.model.messageflow.IReadOnlyPropertyCollection;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.PatternNode;
import org.mule.tooling.model.messageflow.ReadOnlyPropertyCollection;
import org.mule.tooling.model.messageflow.UnknownNode;
import org.mule.tooling.model.messageflow.util.AbstractMessageFlowEntityVisitor;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitor;
import org.mule.tooling.runtime.MuleRuntimePlugin;
import org.mule.tooling.runtime.events.MuleAppRedeployedEvent;
import org.mule.tooling.runtime.launch.RuntimeUtils;
import org.mule.tooling.ui.MessageDialogUtils;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.IEvent;

public class HotDeployBuilderExtensionProvider
implements MuleBuilderExtensionProvider {
    private String WEAVE_EXTENSION = "dwl";

    public IResourceVisitor getResourceVisitor() {
        return new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                return HotDeployBuilderExtensionProvider.this.doVisit(resource);
            }
        };
    }

    public IResourceDeltaVisitor getResourceDeltaVisitor() {
        return new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta) throws CoreException {
                return HotDeployBuilderExtensionProvider.this.doVisit(delta.getResource());
            }
        };
    }

    public static boolean isMuleAppsFolder(IResource resource) throws CoreException {
        IMuleProject muleProject;
        return resource instanceof IFolder && (muleProject = MuleRuntime.create((IProject)resource.getProject())) != null && resource.equals((Object)muleProject.getMuleAppsFolder());
    }

    public boolean isResourceDwlFile(IResource resource) {
        return this.WEAVE_EXTENSION.equals(resource.getFileExtension()) && !resource.isDerived();
    }

    public boolean isFileReferenced(IResource resource, IMuleProject muleProject) {
        for (MuleConfiguration configuration : muleProject.getConfigurationsCache().getConfigurations()) {
            ResourceDwlVisitor resourceDwlVisitor = new ResourceDwlVisitor(resource.getFullPath().toOSString());
            configuration.accept((MessageFlowEntityVisitor)resourceDwlVisitor);
            if (!resourceDwlVisitor.shouldRebuild()) continue;
            return true;
        }
        return false;
    }

    protected boolean isServerAlreadyRunningThisApp(IMuleProject muleProject) throws CoreException {
        return RuntimeUtils.isServerAlreadyRunningThisApp(muleProject);
    }

    public boolean doVisit(final IResource resource) throws CoreException {
        final IMuleProject muleProject = MuleRuntime.create((IProject)resource.getProject());
        return (Boolean)StudioDesignContextRunner.runSilentWithMuleProject((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                if (!HotDeployBuilderExtensionProvider.this.isServerAlreadyRunningThisApp(muleProject)) {
                    return false;
                }
                if (!HotDeployBuilderExtensionProvider.isMuleAppsFolder(resource) && !HotDeployBuilderExtensionProvider.this.isResourceDwlFile(resource)) {
                    return true;
                }
                if (HotDeployBuilderExtensionProvider.this.isResourceDwlFile(resource) && !HotDeployBuilderExtensionProvider.this.isFileReferenced(resource, muleProject)) {
                    return true;
                }
                HotDeployBuilderExtensionProvider.this.build(muleProject);
                return false;
            }
        }, (IMuleProject)muleProject, (Object)false);
    }

    protected void build(IMuleProject muleProject) throws CoreException {
        if (MuleProjectKind.APPLICATION.classifies(muleProject)) {
            Long startEventProcessing = System.currentTimeMillis();
            MuleApplicationDeployment deployer = new MuleApplicationDeployment(new DeploymentHelper(muleProject).getProjectDeploymentFolder());
            deployer.initialize(false);
            boolean compileAndCopySuccess = !deployer.compileAndCopyConfigFilesAndDirectories(muleProject).isEmpty();
            this.trackHotDeployProject(muleProject, CoreUtils.getLoginManager().retrieveActiveAuthUser(), startEventProcessing, compileAndCopySuccess);
            if (!compileAndCopySuccess) {
                Display.getDefault().syncExec(() -> {
                    Shell activeShell = PlatformUI.getWorkbench().getDisplay().getActiveShell().getShell();
                    MessageDialogUtils.openErrorWithLinkToLogView((Shell)activeShell, (String)"Deployment Failed", (String)"The Project re-deployment has been aborted due to an error.");
                });
                return;
            }
        } else if (MuleProjectKind.DOMAIN.classifies(muleProject)) {
            IMuleDomainProject adapt = (IMuleDomainProject)MuleProjectKind.DOMAIN.adapt(muleProject);
            String artifactFinalName = DomainUtils.getDeployableArtifactName((IMuleProject)adapt);
            final File deploymentDomainFolder = new File(DeploymentHelper.getMuleDomainsFolder((IServerDefinition)muleProject.getServerDefinition()), artifactFinalName);
            final IFolder domainsConfigFolderResource = adapt.getMuleAppsFolder();
            domainsConfigFolderResource.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    boolean isContainer = resource instanceof IContainer;
                    int configsFolderSegmentCount = domainsConfigFolderResource.getProjectRelativePath().segmentCount();
                    IPath pathRelativeToConfigsFolder = resource.getProjectRelativePath().removeFirstSegments(configsFolderSegmentCount);
                    if (isContainer) {
                        if (!resource.equals((Object)domainsConfigFolderResource)) {
                            File newFolder = new File(deploymentDomainFolder, pathRelativeToConfigsFolder.toOSString());
                            newFolder.mkdirs();
                        }
                    } else {
                        File destDir;
                        if (pathRelativeToConfigsFolder.segmentCount() > 1) {
                            destDir = new File(deploymentDomainFolder, resource.getParent().getProjectRelativePath().toOSString());
                            destDir.mkdirs();
                        } else {
                            destDir = deploymentDomainFolder;
                        }
                        try {
                            FileUtils.copyFileToDirectory((File)resource.getLocation().toFile(), (File)destDir);
                        }
                        catch (IOException e) {
                            MuleRuntimePlugin.createStatus(4, "There was a problem copying configuration files ", e);
                        }
                    }
                    return isContainer;
                }
            });
        }
        EventBus eventBus = MuleCorePlugin.getEventBus();
        MuleAppRedeployedEvent muleAppRedeployedEvent = new MuleAppRedeployedEvent(muleProject);
        eventBus.fireEvent((IEvent)muleAppRedeployedEvent);
    }

    private void trackHotDeployProject(IMuleProject muleProject, AuthUser currentUser, Long startEventProcessing, boolean successful) {
        Optional dep = MavenUtils.findProjectDeclaredExtension((IMuleProject)muleProject, (String)"org.mule.modules", (String)"mule-asynckit-module");
        long endEventProcessing = System.currentTimeMillis();
        Long duration = endEventProcessing - startEventProcessing;
        AnalyticsRecordsFactory single = AnalyticsRecordsFactory.single((String)Events.RUN_MULE_APPLICATION);
        single.addMetadata("organizationId", currentUser != null ? currentUser.getOrganization().getId() : "").addMetadata("rootOrgName", currentUser != null ? currentUser.getOrganization().getName() : "").addMetadata("jdkVersion", VMUtils.getJreVersion((IJavaProject)muleProject.getJavaProject()).orElse("")).addMetadata("duration", duration.toString()).addMetadata("runtimeVersion", muleProject.getServerDefinition().getLabel()).addMetadata("successful", Boolean.toString(successful)).addMetadata("isHotDeploy", Boolean.TRUE.toString()).addMetadata("apikitExtensionVersion", dep.map(MavenCoordinates::getVersion).orElse("")).track();
    }

    public ICleanerDelegate getCleanerDelegate() {
        return null;
    }

    private class ResourceDwlVisitor
    extends AbstractMessageFlowEntityVisitor {
        private boolean reBuild = false;
        private String resourcePath;

        public ResourceDwlVisitor(String resourcePath) {
            this.resourcePath = resourcePath;
        }

        public boolean shouldRebuild() {
            return this.reBuild;
        }

        public boolean isReferenced(ReadOnlyPropertyCollection property) {
            IReadOnlyProperty result = property.getProperty("resource");
            if (result != null && this.endsWithPath(this.resourcePath, result)) {
                return true;
            }
            List properties = property.getPropertyCollections();
            if (properties != null && !properties.isEmpty()) {
                for (IReadOnlyPropertyCollection iReadOnlyProperty : properties) {
                    if (!this.isReferenced((ReadOnlyPropertyCollection)iReadOnlyProperty)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean endsWithPath(String resourcePath, IReadOnlyProperty result) {
            return resourcePath.replaceAll("\\\\", "/").endsWith(result.getValue().replaceAll("\\\\", "/"));
        }

        private void doVisit(MessageFlowNode node) {
            if (this.isReferenced((ReadOnlyPropertyCollection)node.getProperties())) {
                this.reBuild = true;
            }
        }

        public void visitEndpointNode(EndpointNode endpointNode) {
            this.doVisit((MessageFlowNode)endpointNode);
        }

        public void visitPatternNode(PatternNode patternNode) {
            this.doVisit((MessageFlowNode)patternNode);
        }

        public void visitGlobalUnknown(GlobalUnknown globalUnknown) {
        }

        public void visitUnknownNode(UnknownNode unknownNode) {
        }

        public void visitCommentNode(CommentContainer commentNode) {
        }

        public void preChildrenVisit(MessageFlowEntity entity) {
        }

        public void postChildrenVisit(MessageFlowEntity entity) {
        }
    }
}

