/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.runtime;

import org.mule.tooling.runtime.RuntimeEvents;
import org.mule.tooling.runtime.RuntimeStateChangedHandler;
import org.mule.tooling.utils.eventbus.EventType;
import org.mule.tooling.utils.eventbus.IEvent;

public class RuntimeStateChanged
implements IEvent<RuntimeStateChangedHandler> {
    private State state;

    private RuntimeStateChanged(State state) {
        this.state = state;
    }

    public static RuntimeStateChanged startedEvent() {
        return new RuntimeStateChanged(State.STARTED);
    }

    public static RuntimeStateChanged stoppedEvent() {
        return new RuntimeStateChanged(State.STOPPED);
    }

    public EventType<RuntimeStateChangedHandler> getAssociatedType() {
        return RuntimeEvents.STATE_CHANGED;
    }

    public void dispatch(RuntimeStateChangedHandler handler) {
        switch (this.state) {
            case STARTED: {
                handler.onRuntimeStarted();
                break;
            }
            case STOPPED: {
                handler.onRuntimeStopped();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported event type");
            }
        }
    }

    public static enum State {
        STARTED,
        STOPPED;

    }
}

