/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.runtime;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.runtime.AgentBasedApplicationsStateManager;
import org.mule.tooling.runtime.FixedProjectStateManager;
import org.mule.tooling.runtime.IMuleApplicationsStateManager;
import org.mule.tooling.utils.eventbus.EventBus;

public class MuleServersStateManager {
    private final Map<IServerDefinition, IMuleApplicationsStateManager> applicationStateManagersMap = new HashMap<IServerDefinition, IMuleApplicationsStateManager>();
    private EventBus eventBus;

    public MuleServersStateManager(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public void stopApplicationsStateManager(IServerDefinition serverDefinition) {
        IMuleApplicationsStateManager applicationsStateManager = this.applicationStateManagersMap.remove(serverDefinition);
        applicationsStateManager.stop();
    }

    public IMuleApplicationsStateManager startApplicationsStateManager(IServerDefinition serverDefinition, List<IMuleProject> projects) {
        return this.doStart(serverDefinition, new FixedProjectStateManager(serverDefinition, projects, this.eventBus));
    }

    public IMuleApplicationsStateManager startApplicationsStateManager(IServerDefinition serverDefinition, int agentPort, String agentToken) {
        return this.doStart(serverDefinition, new AgentBasedApplicationsStateManager(serverDefinition, this.eventBus, agentPort, agentToken));
    }

    private IMuleApplicationsStateManager doStart(IServerDefinition serverDefinition, IMuleApplicationsStateManager muleApplicationsStateManager) {
        this.applicationStateManagersMap.put(serverDefinition, muleApplicationsStateManager);
        muleApplicationsStateManager.start();
        return muleApplicationsStateManager;
    }

    public IMuleApplicationsStateManager getApplicationsStateManager(IServerDefinition serverDefinition) {
        return this.applicationStateManagersMap.get(serverDefinition);
    }

    public boolean hasStateManager(IServerDefinition serverDefinition) {
        return this.applicationStateManagersMap.containsKey(serverDefinition);
    }

    public Set<IMuleApplicationsStateManager> getMuleApplicationsStateManagers() {
        return new HashSet<IMuleApplicationsStateManager>(this.applicationStateManagersMap.values());
    }
}

