/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.runtime;

import java.util.List;
import org.mule.tooling.core.model.IMuleApplicationProject;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.runtime.IMuleApplicationsStateManager;
import org.mule.tooling.runtime.service.ApplicationInfo;
import org.mule.tooling.runtime.service.ApplicationState;
import org.mule.tooling.runtime.service.DomainInfo;
import org.mule.tooling.utils.eventbus.EventBus;

public class FixedProjectStateManager
implements IMuleApplicationsStateManager {
    private boolean running;
    private List<IMuleProject> muleProjects;
    private IServerDefinition serverDefinition;

    public FixedProjectStateManager(IServerDefinition serverDefinition, List<IMuleProject> projects, EventBus eventBus) {
        this.serverDefinition = serverDefinition;
        this.muleProjects = projects;
    }

    @Override
    public void start() {
        this.running = true;
    }

    protected String getServerId() {
        return this.serverDefinition.getId();
    }

    @Override
    public void stop() {
        this.running = false;
    }

    @Override
    public boolean isServerRunning() {
        return this.running;
    }

    @Override
    public ApplicationInfo getApplicationInfo(String name) {
        IMuleProject project = this.getProject(name);
        if (this.running && project != null) {
            String domain;
            if (MuleProjectKind.APPLICATION.classifies(project)) {
                IMuleApplicationProject appProject = (IMuleApplicationProject)MuleProjectKind.APPLICATION.adapt(project);
                domain = appProject.getDomainName();
            } else {
                domain = "DEFAULT";
            }
            return new ApplicationInfo(name, domain, ApplicationState.STARTED);
        }
        return null;
    }

    @Override
    public DomainInfo getDomainInfo(String name) {
        return null;
    }

    private IMuleProject getProject(String name) {
        for (IMuleProject muleProject : this.muleProjects) {
            if (!name.equals(muleProject.getName())) continue;
            return muleProject;
        }
        return null;
    }

    @Override
    public IServerDefinition getServerDefinition() {
        return this.serverDefinition;
    }
}

