/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.runtime;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import org.eclipse.core.resources.IProject;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.deployer.MuleLocator;
import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.IMuleProjectEventListener;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.runtime.IMuleApplicationsStateManager;
import org.mule.tooling.runtime.controller.MuleController;
import org.mule.tooling.runtime.controller.MuleControllerManager;
import org.mule.tooling.runtime.events.IMuleRuntimeEventListener;
import org.mule.tooling.runtime.events.MuleRuntimeEventTypes;
import org.mule.tooling.runtime.service.ApplicationInfo;
import org.mule.tooling.runtime.service.ApplicationState;
import org.mule.tooling.runtime.service.DomainInfo;
import org.mule.tooling.runtime.service.MuleAgentServices;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.EventBusHelper;
import org.mule.tooling.utils.eventbus.EventType;
import org.mule.tooling.utils.eventbus.IEvent;
import org.mule.tooling.utils.eventbus.IEventHandler;

public class AgentBasedApplicationsStateManager
implements IMuleProjectEventListener,
IMuleApplicationsStateManager {
    private static final int POLL_INTERVAL = 200;
    private EventBus eventBus;
    private boolean serverRunning;
    private EventBusHelper eventBusHelper;
    private IServerDefinition serverDefinition;
    private List<ApplicationInfo> cachedAppsStatus;
    private List<DomainInfo> cachedDomainsStatus;
    private MuleApplicationsStatus muleApplicationsStatusThread;

    public AgentBasedApplicationsStateManager(IServerDefinition serverDefinition, EventBus eventBus, int agentPort, String agentToken) {
        this.serverDefinition = serverDefinition;
        this.eventBus = eventBus;
        this.muleApplicationsStatusThread = new MuleApplicationsStatus(MuleAgentServices.getInstance(agentPort, agentToken));
    }

    @Override
    public void start() {
        this.eventBusHelper = new EventBusHelper();
        this.eventBusHelper.registerListener(MuleCorePlugin.getEventBus(), CoreEventTypes.ON_MULE_PROJECT_EVENT, (IEventHandler)this);
        this.muleApplicationsStatusThread.start();
    }

    @Override
    public void stop() {
        this.eventBusHelper.unregister();
        this.muleApplicationsStatusThread.interrupt();
    }

    @Override
    public boolean isServerRunning() {
        return this.serverRunning;
    }

    @Override
    public ApplicationInfo getApplicationInfo(String name) {
        ApplicationInfo applicationInfo = null;
        if (this.cachedAppsStatus != null) {
            for (ApplicationInfo currentApplicationInfo : this.cachedAppsStatus) {
                if (!currentApplicationInfo.getName().equals(name)) continue;
                applicationInfo = currentApplicationInfo;
                break;
            }
        }
        return applicationInfo;
    }

    @Override
    public DomainInfo getDomainInfo(String name) {
        DomainInfo domainInfo = null;
        if (this.cachedAppsStatus != null) {
            for (DomainInfo currentDomainInfo : this.cachedDomainsStatus) {
                if (!currentDomainInfo.getName().equals(name)) continue;
                domainInfo = currentDomainInfo;
                break;
            }
        }
        return domainInfo;
    }

    public void onMuleProjectOpened(IProject project) {
    }

    public void onMuleProjectClosed(IProject project) {
    }

    @Override
    public IServerDefinition getServerDefinition() {
        return this.serverDefinition;
    }

    private class MuleApplicationsStatus
    extends Thread {
        private boolean interrupted;
        private final MuleAgentServices agentClient;

        public MuleApplicationsStatus(MuleAgentServices agentClient) {
            super("[Mule Applications Status Thread]");
            this.agentClient = agentClient;
        }

        @Override
        public void interrupt() {
            this.interrupted = true;
            super.interrupt();
        }

        @Override
        public void run() {
            Path mulePath = Paths.get(MuleLocator.create((IServerDefinition)AgentBasedApplicationsStateManager.this.getServerDefinition()).getInstallationDirectoryRootPath(), new String[0]);
            MuleController controller = MuleControllerManager.getInstance().get(mulePath);
            while (!this.interrupted) {
                try {
                    if (controller.isRunning()) {
                        List<ApplicationInfo> listApplications = this.agentClient.listApplications();
                        this.processAppsInfo(listApplications);
                        this.processDomainsInfo(this.agentClient.listDomains());
                    }
                }
                catch (WebApplicationException webApplicationException) {}
                this.sleepPoll(200);
            }
        }

        private void sleepPoll(int interval) {
            try {
                Thread.sleep(interval);
            }
            catch (InterruptedException interruptedException) {}
        }

        private void processAppsInfo(List<ApplicationInfo> listApplications) {
            if (AgentBasedApplicationsStateManager.this.cachedAppsStatus == null) {
                AgentBasedApplicationsStateManager.this.cachedAppsStatus = listApplications;
                if (listApplications.size() > 0) {
                    for (ApplicationInfo appInfo : listApplications) {
                        this.notifyAppState(appInfo);
                    }
                }
            } else {
                this.compareAndNotifyChanges(listApplications);
            }
        }

        private void processDomainsInfo(List<DomainInfo> domains) {
            if (AgentBasedApplicationsStateManager.this.cachedDomainsStatus == null) {
                AgentBasedApplicationsStateManager.this.cachedDomainsStatus = domains;
                if (domains.size() > 0) {
                    Iterator<DomainInfo> iterator = domains.iterator();
                    while (iterator.hasNext()) {
                        iterator.next();
                    }
                }
            } else {
                this.compareAndNotifyDomainChanges(domains);
            }
        }

        private void notifyAppState(final ApplicationInfo appInfo) {
            AgentBasedApplicationsStateManager.this.eventBus.fireEvent((IEvent)new IEvent<IMuleRuntimeEventListener>(){

                public EventType<IMuleRuntimeEventListener> getAssociatedType() {
                    return MuleRuntimeEventTypes.ON_MULE_RUNTIME_EVENT;
                }

                public void dispatch(IMuleRuntimeEventListener handler) {
                    switch (appInfo.getState()) {
                        case DEPLOYMENT_FAILED: {
                            handler.onAppDeploymentFailed(MuleApplicationsStatus.this.getServerId(), appInfo.getName(), appInfo.getDomainName());
                            break;
                        }
                        case CREATED: {
                            handler.onAppDeployed(MuleApplicationsStatus.this.getServerId(), appInfo.getName(), appInfo.getDomainName());
                            break;
                        }
                        case DESTROYED: {
                            handler.onAppUndeployed(MuleApplicationsStatus.this.getServerId(), appInfo.getName(), appInfo.getDomainName());
                            break;
                        }
                        case INITIALISED: {
                            break;
                        }
                        case STARTED: {
                            handler.onAppStarted(MuleApplicationsStatus.this.getServerId(), appInfo.getName(), appInfo.getDomainName());
                            break;
                        }
                        case STOPPED: {
                            handler.onAppStopped(MuleApplicationsStatus.this.getServerId(), appInfo.getName(), appInfo.getDomainName());
                            break;
                        }
                        default: {
                            MuleCorePlugin.logWarning((String)"Unknown application state received from the Mule ESB agent.");
                        }
                    }
                }
            });
        }

        private String getServerId() {
            return AgentBasedApplicationsStateManager.this.serverDefinition.getId();
        }

        private void compareAndNotifyChanges(List<ApplicationInfo> listApplications) {
            for (ApplicationInfo appInfo : listApplications) {
                if (AgentBasedApplicationsStateManager.this.cachedAppsStatus.contains(appInfo)) continue;
                this.notifyAppState(appInfo);
            }
            AgentBasedApplicationsStateManager.this.cachedAppsStatus.removeAll(listApplications);
            for (ApplicationInfo appInfo : AgentBasedApplicationsStateManager.this.cachedAppsStatus) {
                this.notifyAppState(new ApplicationInfo(appInfo.getName(), appInfo.getDomainName(), ApplicationState.DESTROYED));
            }
            AgentBasedApplicationsStateManager.this.cachedAppsStatus = listApplications;
        }

        private void compareAndNotifyDomainChanges(List<DomainInfo> domains) {
            for (DomainInfo domainInfo : domains) {
                AgentBasedApplicationsStateManager.this.cachedDomainsStatus.contains(domainInfo);
            }
            AgentBasedApplicationsStateManager.this.cachedDomainsStatus.removeAll(domains);
            Iterator<DomainInfo> iterator = AgentBasedApplicationsStateManager.this.cachedDomainsStatus.iterator();
            while (iterator.hasNext()) {
                iterator.next();
            }
            AgentBasedApplicationsStateManager.this.cachedDomainsStatus = domains;
        }
    }
}

