/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.dispatch;

import com.mulesoft.agent.dispatch.AgentHttpRequest;
import com.mulesoft.agent.dispatch.WSMessageParser;
import java.io.IOException;
import java.net.Socket;
import java.util.Arrays;
import java.util.List;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestFactory;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.ProtocolException;
import org.apache.http.RequestLine;
import org.apache.http.impl.DefaultBHttpServerConnection;
import org.apache.http.impl.DefaultHttpRequestFactory;
import org.apache.http.impl.io.DefaultHttpRequestParserFactory;
import org.apache.http.io.HttpMessageParserFactory;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.util.Args;

public class WSRequestParser
extends WSMessageParser<AgentHttpRequest> {
    public static final int BUFFER_SIZE = 500;
    private DefaultBHttpServerConnection serverConnection = new DefaultBHttpServerConnection(500, 500, null, null, null, null, null, (HttpMessageParserFactory)new DefaultHttpRequestParserFactory(null, (HttpRequestFactory)new WSHttpRequestParser()), null);

    public WSRequestParser(String requestAsString) throws IOException {
        super(requestAsString);
        this.serverConnection.bind((Socket)this.socket);
    }

    public WSRequestParser(byte[] requestAsString) throws IOException {
        super(requestAsString);
        this.serverConnection.bind((Socket)this.socket);
    }

    @Override
    public AgentHttpRequest parse() throws ProtocolException {
        try {
            HttpRequest httpRequest = this.serverConnection.receiveRequestHeader();
            if (httpRequest instanceof HttpEntityEnclosingRequest) {
                this.serverConnection.receiveRequestEntity((HttpEntityEnclosingRequest)httpRequest);
            }
            return new AgentHttpRequest(httpRequest);
        }
        catch (ProtocolException e) {
            throw e;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (HttpException e) {
            throw new RuntimeException(e);
        }
    }

    private class WSHttpRequestParser
    extends DefaultHttpRequestFactory {
        private final List<String> enclosingMethods = Arrays.asList("POST", "PUT", "PATCH", "DELETE");
        private final List<String> acceptedMethods = Arrays.asList("GET", "HEAD", "OPTIONS", "DELETE", "TRACE", "CONNECT");

        private WSHttpRequestParser() {
        }

        public HttpRequest newHttpRequest(RequestLine requestline) throws MethodNotSupportedException {
            Args.notNull((Object)requestline, (String)"Request line");
            String method = requestline.getMethod();
            if (this.enclosingMethods.contains(method)) {
                return new BasicHttpEntityEnclosingRequest(requestline);
            }
            if (this.acceptedMethods.contains(method)) {
                return new BasicHttpRequest(requestline);
            }
            throw new MethodNotSupportedException(method + " method not supported");
        }

        public HttpRequest newHttpRequest(String method, String uri) throws MethodNotSupportedException {
            if (this.enclosingMethods.contains(method)) {
                return new BasicHttpEntityEnclosingRequest(method, uri);
            }
            if (this.acceptedMethods.contains(method)) {
                return new BasicHttpRequest(method, uri);
            }
            throw new MethodNotSupportedException(method + " method not supported");
        }
    }
}

