/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.dispatch;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import org.apache.http.ProtocolException;

public abstract class WSMessageParser<T> {
    protected WebSocket socket;

    public WSMessageParser(String message) throws IOException {
        this.socket = new WebSocket(message);
    }

    public WSMessageParser(byte[] message) throws IOException {
        this.socket = new WebSocket(message);
    }

    public abstract T parse() throws ProtocolException;

    protected class WebSocket
    extends Socket {
        private ByteArrayInputStream inputStream;
        private ByteArrayOutputStream byteArrayOutputStream;

        private WebSocket(String receivedMessage) {
            try {
                this.inputStream = new ByteArrayInputStream(receivedMessage.getBytes("utf-8"));
                this.byteArrayOutputStream = new ByteArrayOutputStream();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }

        public WebSocket(byte[] message) {
            this.inputStream = new ByteArrayInputStream(message);
            this.byteArrayOutputStream = new ByteArrayOutputStream();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.inputStream;
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return this.byteArrayOutputStream;
        }
    }
}

