/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.dispatch;

import com.mulesoft.agent.dispatch.AgentMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.impl.io.DefaultHttpResponseWriter;
import org.apache.http.impl.io.HttpTransportMetricsImpl;
import org.apache.http.impl.io.SessionOutputBufferImpl;
import org.apache.http.io.SessionOutputBuffer;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.message.BasicStatusLine;
import org.eclipse.jetty.http.HttpStatus;

public class AgentHttpResponse
implements HttpServletResponse,
AgentMessage {
    public static final int BUFFER_SIZE = 100;
    private Map<String, String> headers = new HashMap<String, String>();
    private int status;
    private String statusMessage;
    private String contentType = "application/json";
    private ResponseOutputStream stream;

    public AgentHttpResponse(HttpResponse httpResponse) throws IOException {
        Header[] allHeaders;
        for (Header header : allHeaders = httpResponse.getAllHeaders()) {
            this.headers.put(header.getName(), header.getValue());
        }
        this.stream = new ResponseOutputStream();
        this.status = httpResponse.getStatusLine().getStatusCode();
        if (httpResponse.getEntity() != null) {
            this.contentType = httpResponse.getEntity().getContentType() == null ? "application/json" : httpResponse.getEntity().getContentType().getValue();
            httpResponse.getEntity().writeTo((OutputStream)((Object)this.stream));
        }
    }

    public AgentHttpResponse() throws IOException {
        this.stream = new ResponseOutputStream();
    }

    public void addCookie(Cookie cookie) {
    }

    public boolean containsHeader(String name) {
        return this.headers.containsKey(name);
    }

    public String encodeURL(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return url;
        }
    }

    public String encodeRedirectURL(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return url;
        }
    }

    public String encodeUrl(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return url;
        }
    }

    public String encodeRedirectUrl(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return url;
        }
    }

    public void sendError(int sc, String msg) throws IOException {
    }

    public void sendError(int sc) throws IOException {
    }

    public void sendRedirect(String location) throws IOException {
    }

    public void setDateHeader(String name, long date) {
        this.headers.put(name, String.valueOf(date));
    }

    public void addDateHeader(String name, long date) {
        this.headers.put(name, String.valueOf(date));
    }

    public void setHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.headers.put(name, String.valueOf(value));
    }

    public void addIntHeader(String name, int value) {
        this.headers.put(name, String.valueOf(value));
    }

    public void setStatus(int sc) {
        this.status = sc;
    }

    public void setStatus(int sc, String sm) {
        this.setStatus(sc);
        this.statusMessage = sm;
    }

    public int getStatus() {
        return this.status;
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public Collection<String> getHeaders(String name) {
        return this.headers.values();
    }

    public Collection<String> getHeaderNames() {
        return this.headers.keySet();
    }

    public String getCharacterEncoding() {
        return "UTF-8";
    }

    public String getContentType() {
        return this.contentType;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.stream;
    }

    public String getProtocol() {
        return new ProtocolVersion("HTTP", 1, 1).toString();
    }

    public PrintWriter getWriter() throws IOException {
        return new PrintWriter((OutputStream)((Object)this.stream));
    }

    public void setCharacterEncoding(String charset) {
    }

    public void setContentLength(int len) {
    }

    public void setContentLengthLong(long len) {
    }

    public void setContentType(String type) {
        this.contentType = type;
        this.headers.put("Content-Type", this.contentType);
    }

    public void setBufferSize(int size) {
    }

    public int getBufferSize() {
        return 0;
    }

    public void flushBuffer() throws IOException {
    }

    public void resetBuffer() {
    }

    public boolean isCommitted() {
        return false;
    }

    public void reset() {
    }

    public void setLocale(Locale loc) {
    }

    public Locale getLocale() {
        return Locale.US;
    }

    public InputStream getInputStream() throws IOException {
        if (this.stream != null) {
            this.stream.flush();
            this.stream.close();
            return new ByteArrayInputStream(this.stream.out.toByteArray());
        }
        return null;
    }

    @Override
    public String asString() {
        return new String(this.asByteArray());
    }

    @Override
    public byte[] asByteArray() {
        try {
            SessionOutputBufferImpl sessionOutputBuffer = new SessionOutputBufferImpl(new HttpTransportMetricsImpl(), 100);
            ByteArrayOutputStream outstream = new ByteArrayOutputStream();
            sessionOutputBuffer.bind((OutputStream)outstream);
            DefaultHttpResponseWriter writer = new DefaultHttpResponseWriter((SessionOutputBuffer)sessionOutputBuffer);
            BasicHttpResponse http = new BasicHttpResponse((StatusLine)new BasicStatusLine(new ProtocolVersion("HTTP", 1, 1), this.getStatus(), HttpStatus.getMessage((int)this.getStatus())));
            BasicHttpEntity entity = new BasicHttpEntity();
            this.stream.flush();
            this.stream.close();
            entity.setContentLength((long)this.stream.length);
            entity.setContent(this.getInputStream());
            http.setEntity((HttpEntity)entity);
            for (String headerName : this.getHeaderNames()) {
                http.setHeader(headerName, this.getHeader(headerName));
            }
            http.addHeader(entity.getContentType());
            http.addHeader(entity.getContentEncoding());
            if (!http.containsHeader("Content-Length")) {
                http.addHeader("Content-Length", String.valueOf(entity.getContentLength()));
            }
            writer.write((HttpMessage)http);
            sessionOutputBuffer.flush();
            entity.writeTo((OutputStream)outstream);
            outstream.flush();
            return outstream.toByteArray();
        }
        catch (IOException | HttpException e) {
            throw new RuntimeException("The Agent response could not be serialised to an HTTP response", e);
        }
    }

    private final class ResponseOutputStream
    extends ServletOutputStream {
        private final ByteArrayOutputStream out = new ByteArrayOutputStream();
        private int length = 0;

        private ResponseOutputStream() throws IOException {
        }

        public void flush() throws IOException {
            this.out.flush();
            super.flush();
        }

        public void close() throws IOException {
            this.out.close();
            super.close();
        }

        public void write(int b) throws IOException {
            this.out.write(b);
            ++this.length;
        }

        public void write(byte[] b) throws IOException {
            this.out.write(b);
            this.length += b.length;
        }

        public void setWriteListener(WriteListener writeListener) {
        }

        public boolean isReady() {
            return true;
        }
    }
}

