/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.dispatch;

import com.mulesoft.agent.dispatch.AgentMessage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.ReadListener;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.impl.io.DefaultHttpRequestWriter;
import org.apache.http.impl.io.HttpTransportMetricsImpl;
import org.apache.http.impl.io.SessionOutputBufferImpl;
import org.apache.http.io.SessionOutputBuffer;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.util.CharArrayBuffer;

public class AgentHttpRequest
implements HttpServletRequest,
AgentMessage {
    public static final int SERVER_PORT = 8080;
    public static final int BUFFER_SIZE = 100;
    private HttpRequest httpRequest;
    private byte[] requestAsByteArray = null;
    private Map<String, Object> requestAttributes = new HashMap<String, Object>();

    public AgentHttpRequest(HttpRequest httpRequest) {
        this.httpRequest = httpRequest;
    }

    public String getAuthType() {
        return this.firstHeaderValue("Authorization");
    }

    public Cookie[] getCookies() {
        Header[] headers = this.httpRequest.getHeaders("Cookie");
        if (headers == null) {
            return new Cookie[0];
        }
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        for (Header header : headers) {
            HeaderElement[] elements = header.getElements();
            if (elements == null) continue;
            for (HeaderElement element : elements) {
                cookies.add(new Cookie(element.getName(), element.getValue()));
            }
        }
        return cookies.toArray(new Cookie[0]);
    }

    public long getDateHeader(String name) {
        String date = this.firstHeaderValue("Date");
        return date == null ? 0L : Long.parseLong(date);
    }

    public String getHeader(String name) {
        return this.firstHeaderValue(name);
    }

    public Enumeration<String> getHeaders(String name) {
        Vector<String> headerValues = new Vector<String>();
        Header[] headers = this.httpRequest.getHeaders(name);
        if (headers != null) {
            for (Header header : headers) {
                headerValues.add(header.getValue());
            }
        }
        return headerValues.elements();
    }

    public Enumeration<String> getHeaderNames() {
        Vector<String> headerValues = new Vector<String>();
        Header[] headers = this.httpRequest.getAllHeaders();
        if (headers != null) {
            for (Header header : headers) {
                headerValues.add(header.getName());
            }
        }
        return headerValues.elements();
    }

    public int getIntHeader(String name) {
        String headerValue = this.firstHeaderValue(name);
        return headerValue == null ? 0 : Integer.parseInt(headerValue);
    }

    public String getMethod() {
        return this.httpRequest.getRequestLine().getMethod();
    }

    public String getPathInfo() {
        return this.httpRequest.getRequestLine().getUri();
    }

    public String getPathTranslated() {
        return this.httpRequest.getRequestLine().getUri();
    }

    public String getContextPath() {
        return "/";
    }

    public String getQueryString() {
        return this.httpRequest.getRequestLine().getUri();
    }

    public String getRemoteUser() {
        return null;
    }

    public boolean isUserInRole(String role) {
        return true;
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public String getRequestedSessionId() {
        return null;
    }

    public String changeSessionId() {
        return this.getRequestedSessionId();
    }

    public long getContentLengthLong() {
        return this.getContentLength();
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException, ServletException {
        return null;
    }

    public String getRequestURI() {
        return this.httpRequest.getRequestLine().getUri();
    }

    public StringBuffer getRequestURL() {
        return new StringBuffer(this.getRequestURI());
    }

    public String getServletPath() {
        return "/";
    }

    public HttpSession getSession(boolean create) {
        return null;
    }

    public HttpSession getSession() {
        return null;
    }

    public boolean isRequestedSessionIdValid() {
        return true;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return true;
    }

    public boolean isRequestedSessionIdFromURL() {
        return true;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return true;
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        return true;
    }

    public void login(String username, String password) throws ServletException {
    }

    public void logout() throws ServletException {
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        return Collections.EMPTY_LIST;
    }

    public Part getPart(String name) throws IOException, ServletException {
        return null;
    }

    public Object getAttribute(String name) {
        return this.requestAttributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return new Vector<String>(this.requestAttributes.keySet()).elements();
    }

    public String getCharacterEncoding() {
        return this.firstHeaderValue("Content-Encoding");
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
    }

    public int getContentLength() {
        return this.getIntHeader("Content-Length");
    }

    public String getContentType() {
        return this.firstHeaderValue("Content-Type");
    }

    public ServletInputStream getInputStream() throws IOException {
        return new ServletInputStream(){

            public int read() throws IOException {
                if (AgentHttpRequest.this.httpRequest instanceof BasicHttpEntityEnclosingRequest) {
                    return ((BasicHttpEntityEnclosingRequest)AgentHttpRequest.this.httpRequest).getEntity().getContent().read();
                }
                return -1;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener readListener) {
            }

            public boolean isFinished() {
                return true;
            }
        };
    }

    public String getParameter(String name) {
        return null;
    }

    public Enumeration<String> getParameterNames() {
        return null;
    }

    public String[] getParameterValues(String name) {
        return new String[0];
    }

    public Map<String, String[]> getParameterMap() {
        return null;
    }

    public String getProtocol() {
        return this.httpRequest.getProtocolVersion().getProtocol();
    }

    public String getScheme() {
        return null;
    }

    public String getServerName() {
        return "localhost";
    }

    public int getServerPort() {
        return 8080;
    }

    public BufferedReader getReader() throws IOException {
        return null;
    }

    public String getRemoteAddr() {
        return "localhost";
    }

    public String getRemoteHost() {
        return "localhost";
    }

    public void setAttribute(String name, Object o) {
        this.requestAttributes.put(name, o);
    }

    public void removeAttribute(String name) {
        this.requestAttributes.remove(name);
    }

    public Locale getLocale() {
        return Locale.US;
    }

    public Enumeration<Locale> getLocales() {
        return null;
    }

    public boolean isSecure() {
        return true;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return null;
    }

    public String getRealPath(String path) {
        return null;
    }

    public int getRemotePort() {
        return 0;
    }

    public String getLocalName() {
        return null;
    }

    public String getLocalAddr() {
        return null;
    }

    public int getLocalPort() {
        return 8080;
    }

    public ServletContext getServletContext() {
        return null;
    }

    public AsyncContext startAsync() throws IllegalStateException {
        return null;
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        return null;
    }

    public boolean isAsyncStarted() {
        return false;
    }

    public boolean isAsyncSupported() {
        return false;
    }

    public AsyncContext getAsyncContext() {
        return null;
    }

    public DispatcherType getDispatcherType() {
        return null;
    }

    @Override
    public String asString() {
        return new String(this.asByteArray());
    }

    @Override
    public byte[] asByteArray() {
        if (this.requestAsByteArray == null) {
            SessionOutputBufferImpl sessionOutputBuffer = new SessionOutputBufferImpl(new HttpTransportMetricsImpl(), 100);
            ByteArrayOutputStream outstream = new ByteArrayOutputStream();
            try {
                sessionOutputBuffer.bind((OutputStream)outstream);
                DefaultHttpRequestWriter writer = new DefaultHttpRequestWriter((SessionOutputBuffer)sessionOutputBuffer);
                if (this.httpRequest instanceof BasicHttpEntityEnclosingRequest) {
                    ByteArrayOutputStream bodyOutStream = new ByteArrayOutputStream();
                    ((BasicHttpEntityEnclosingRequest)this.httpRequest).getEntity().writeTo((OutputStream)bodyOutStream);
                    byte[] bytes = bodyOutStream.toByteArray();
                    this.httpRequest.addHeader((Header)new BasicHeader("Content-Length", String.valueOf(bytes.length)));
                    this.httpRequest.addHeader((Header)new BasicHeader("Content-Encoding", "UTF-8"));
                    writer.write((HttpMessage)this.httpRequest);
                    CharArrayBuffer charArrayBuffer = new CharArrayBuffer(bytes.length);
                    charArrayBuffer.append(bytes, 0, bytes.length);
                    sessionOutputBuffer.writeLine(charArrayBuffer);
                } else {
                    writer.write((HttpMessage)this.httpRequest);
                }
                sessionOutputBuffer.flush();
                outstream.flush();
                byte[] byArray = this.requestAsByteArray = outstream.toByteArray();
                return byArray;
            }
            catch (IOException | HttpException e) {
                throw new RuntimeException("The Agent response could not be serialised to an HTTP response", e);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)outstream);
            }
        }
        return this.requestAsByteArray;
    }

    private String firstHeaderValue(String headerName) {
        Header header = this.httpRequest.getFirstHeader(headerName);
        if (header != null) {
            return header.getValue();
        }
        return null;
    }
}

