/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.properties;

import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.configuration.ReportConfiguration;
import com.mulesoft.agent.configuration.Type;
import com.mulesoft.agent.domain.properties.AutoDiscoveredProperty;
import com.mulesoft.agent.domain.properties.MuleProperty;
import com.mulesoft.agent.handlers.InternalMessageHandler;
import com.mulesoft.agent.services.ConfigurableAgentService;
import com.mulesoft.agent.services.MuleConfigurationService;
import com.mulesoft.agent.services.PropertiesService;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.runtime.api.exception.MuleException;

@Named(value="mule.agent.properties.service")
@Singleton
public class MuleAgentPropertiesService
extends ConfigurableAgentService
implements PropertiesService,
ReportConfiguration {
    private static final String CONFIGURATION_FOLDER_PROPERTY = "mule.agent.configuration.folder";
    private RuntimeMXBean mxBean = ManagementFactory.getRuntimeMXBean();
    private static final Logger LOGGER = LogManager.getLogger();
    private List<MuleProperty> oldProperties;
    private static final int SPLIT_LIMIT = 2;
    private ScheduledExecutorService executorService = null;
    @Inject
    MuleConfigurationService muleConfigurationService;
    @Configurable(value="[]", type=Type.DYNAMIC)
    MuleProperty[] properties;
    @Configurable(value="[]", type=Type.STATIC)
    AutoDiscoveredProperty[] discoveredProperties;
    @Configurable(value="300", type=Type.DYNAMIC)
    Long discoveryRefreshTime;
    @Configurable(value="false", type=Type.DYNAMIC)
    boolean discoveryEnabled;
    @Configurable(value="true", type=Type.DYNAMIC)
    private boolean enabled;

    protected void doStart() throws MuleException {
        this.executorService = Executors.newSingleThreadScheduledExecutor();
        if (this.discoveryEnabled) {
            this.setDiscoveredProperties();
            try {
                this.executorService.scheduleAtFixedRate(new Runnable(){

                    @Override
                    public void run() {
                        MuleAgentPropertiesService.this.setDiscoveredProperties();
                    }
                }, this.discoveryRefreshTime, this.discoveryRefreshTime, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                LOGGER.warn("Error retrieving the properties.", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                LOGGER.debug((Object)e);
            }
        } else {
            this.discoveredProperties = new AutoDiscoveredProperty[0];
        }
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        List<MuleProperty> newProperties = Arrays.asList(this.properties);
        if (this.oldProperties != null) {
            this.oldProperties.removeAll(newProperties);
            this.unsetProperties(this.oldProperties);
        }
        for (MuleProperty property : newProperties) {
            propertiesMap.put(property.getName(), property.getValue());
        }
        this.setProperties(propertiesMap, false);
    }

    protected void doStop() throws MuleException {
        if (this.discoveryEnabled) {
            this.executorService.shutdown();
        }
        this.oldProperties = new ArrayList<MuleProperty>(Arrays.asList(this.properties));
    }

    public MuleProperty getProperty(String name) throws IllegalArgumentException, NoSuchElementException {
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("Can not retrieve value for empty property name");
        }
        for (MuleProperty property : Arrays.asList(this.properties)) {
            if (!name.equals(property.getName())) continue;
            return property;
        }
        throw new NoSuchElementException("Property " + name + " is not set in Mule Agent");
    }

    public void clearProperty(String name) {
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("Can not set value for empty property name");
        }
        int idx = this.getPropertyIndex(name);
        if (idx >= 0) {
            MuleProperty property = this.properties[idx];
            this.unsetProperties(Collections.singletonList(property));
            return;
        }
        throw new NoSuchElementException("Property " + name + " is not set in Mule Agent");
    }

    public List<MuleProperty> getProperties() {
        return Arrays.asList(this.properties);
    }

    public MuleProperty setProperty(String name, String value, boolean override) throws IllegalArgumentException {
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("Can not set value for empty property name");
        }
        if (value == null) {
            throw new IllegalArgumentException("Can not set null value for property");
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(name, value);
        return this.setProperties(properties, override).get(0);
    }

    public List<MuleProperty> setProperties(Map<String, String> properties, boolean override) throws IllegalArgumentException {
        if (properties == null) {
            throw new IllegalArgumentException("Can not set empty list of properties");
        }
        for (String string : properties.keySet()) {
            if (!StringUtils.isBlank((String)string)) continue;
            throw new IllegalArgumentException("Can not set value for empty property name");
        }
        for (String string : properties.values()) {
            if (string != null) continue;
            throw new IllegalArgumentException("Can not set null value for property");
        }
        LinkedList<MuleProperty> result = new LinkedList<MuleProperty>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            MuleProperty muleProperty = new MuleProperty(entry.getKey(), entry.getValue(), override);
            int idx = this.getPropertyIndex(muleProperty.getName());
            if (idx >= 0) {
                this.properties = (MuleProperty[])ArrayUtils.remove((Object[])this.properties, (int)idx);
            }
            this.properties = (MuleProperty[])ArrayUtils.add((Object[])this.properties, (Object)muleProperty);
            System.setProperty(muleProperty.getName(), muleProperty.getValue());
            result.add(muleProperty);
        }
        String string = System.getProperty(CONFIGURATION_FOLDER_PROPERTY);
        try {
            this.muleConfigurationService.addWrapperJavaAdditionalProperties(new File(string), properties);
        }
        catch (IOException iOException) {
            LOGGER.error("There was an error setting the properties in the wrapper.conf. Reason: {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)iOException));
            LOGGER.debug((Object)iOException);
        }
        return result;
    }

    public List<InternalMessageHandler> getInternalHandlers() {
        return new LinkedList<InternalMessageHandler>();
    }

    public List<AutoDiscoveredProperty> getDiscoveredProperties() {
        return Arrays.asList(this.discoveredProperties);
    }

    private int getPropertyIndex(String name) {
        for (int i = 0; i < this.properties.length; ++i) {
            if (!this.properties[i].getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    private void unsetProperties(List<MuleProperty> propertiesToRemove) {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        for (MuleProperty muleProperty : propertiesToRemove) {
            int idx = this.getPropertyIndex(muleProperty.getName());
            if (idx >= 0) {
                this.properties = (MuleProperty[])ArrayUtils.remove((Object[])this.properties, (int)this.getPropertyIndex(muleProperty.getName()));
            }
            System.clearProperty(muleProperty.getName());
            propertyMap.put(muleProperty.getName(), muleProperty.getValue());
        }
        String confFolder = System.getProperty(CONFIGURATION_FOLDER_PROPERTY);
        try {
            this.muleConfigurationService.removeWrapperJavaAdditionalProperties(new File(confFolder), propertyMap);
        }
        catch (IOException e) {
            LOGGER.error("There was an error removing the properties from the wrapper.conf. Reason: {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            LOGGER.debug((Object)e);
        }
    }

    private void setDiscoveredProperties() {
        ArrayList<AutoDiscoveredProperty> propertiesList = new ArrayList<AutoDiscoveredProperty>();
        propertiesList.addAll(this.getEnvironmentProperties());
        propertiesList.addAll(this.getJVMArguments());
        propertiesList.addAll(this.getSystemProperties());
        this.discoveredProperties = propertiesList.toArray(new AutoDiscoveredProperty[propertiesList.size()]);
    }

    private List<AutoDiscoveredProperty> getSystemProperties() {
        ArrayList<AutoDiscoveredProperty> systemProperties = new ArrayList<AutoDiscoveredProperty>();
        Map<String, String> propertyMap = this.mxBean.getSystemProperties();
        for (Map.Entry<String, String> entry : propertyMap.entrySet()) {
            systemProperties.add(new AutoDiscoveredProperty(entry.getKey(), entry.getValue(), AutoDiscoveredProperty.Category.SYSTEM_PROPERTIES.getCategory()));
        }
        return systemProperties;
    }

    private List<AutoDiscoveredProperty> getEnvironmentProperties() {
        ArrayList<AutoDiscoveredProperty> environmentProperties = new ArrayList<AutoDiscoveredProperty>();
        Map<String, String> propertyMap = System.getenv();
        for (Map.Entry<String, String> entry : propertyMap.entrySet()) {
            environmentProperties.add(new AutoDiscoveredProperty(entry.getKey(), entry.getValue(), AutoDiscoveredProperty.Category.ENVIRONMENT_PROPERTIES.getCategory()));
        }
        return environmentProperties;
    }

    private List<AutoDiscoveredProperty> getJVMArguments() {
        ArrayList<AutoDiscoveredProperty> jvmArguments = new ArrayList<AutoDiscoveredProperty>();
        List<String> arguments = this.mxBean.getInputArguments();
        for (String argument : arguments) {
            String[] pair = argument.split("=", 2);
            jvmArguments.add(new AutoDiscoveredProperty(pair[0], pair.length == 2 ? pair[1] : "", AutoDiscoveredProperty.Category.JVM_PROPERTIES.getCategory()));
        }
        return jvmArguments;
    }
}

