/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.licm.security;

import com.mulesoft.licm.impl.TrueLicenseHelper;
import de.schlichtherle.license.DefaultKeyStoreParam;

public class KeyStoreParamBuilder {
    private Class<?> clazz;
    private String keyStoreName;
    private String alias;
    private String storePassword;
    private boolean isFipsCompliant = false;
    private String keyPassword;

    public static KeyStoreParamBuilder getKeyStoreParamBuilder() {
        return new KeyStoreParamBuilder();
    }

    public KeyStoreParamBuilder withClazz(Class<?> clazz) {
        this.clazz = clazz;
        return this;
    }

    public KeyStoreParamBuilder withKeyStoreName(String keyStoreName) {
        this.keyStoreName = keyStoreName;
        return this;
    }

    public KeyStoreParamBuilder withAlias(String alias) {
        this.alias = alias;
        return this;
    }

    public KeyStoreParamBuilder withStorePassword(String storePassword) {
        this.storePassword = storePassword;
        return this;
    }

    public KeyStoreParamBuilder withKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
        return this;
    }

    public KeyStoreParamBuilder isFipsCompliant(boolean isFipsCompliant) {
        this.isFipsCompliant = isFipsCompliant;
        return this;
    }

    public DefaultKeyStoreParam build() {
        if (this.clazz == null) {
            throw new IllegalArgumentException("clazz should not be null");
        }
        if (this.isFipsCompliant) {
            this.storePassword = this.storePassword != null ? this.storePassword : TrueLicenseHelper.STORE_PASSWORD_FIPS;
            this.keyStoreName = this.keyStoreName != null ? this.keyStoreName : this.getDefaultFipsKeyStore();
        } else {
            this.storePassword = this.storePassword != null ? this.storePassword : TrueLicenseHelper.STORE_PASSWORD;
            this.keyStoreName = this.keyStoreName != null ? this.keyStoreName : this.getDefaultKeystore();
        }
        return new DefaultKeyStoreParam(this.clazz, this.keyStoreName, this.alias, this.storePassword, this.keyPassword);
    }

    protected String getDefaultKeystore() {
        return TrueLicenseHelper.PUBLIC_KEYSTORE;
    }

    protected String getDefaultFipsKeyStore() {
        return TrueLicenseHelper.PUBLIC_KEYSTORE_FIPS;
    }
}

