/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.licm.impl;

import com.mulesoft.licm.EnterpriseLicenseKey;
import com.mulesoft.licm.EnterpriseLicenseKeyRequest;
import com.mulesoft.licm.LicenseHelper;
import com.mulesoft.licm.LicenseKeyException;
import com.mulesoft.licm.LicenseManagementFactory;
import com.mulesoft.licm.feature.Feature;
import com.mulesoft.licm.impl.InvalidLicenseKeyException;
import com.mulesoft.licm.impl.MuleLicenseKeyParam;
import com.mulesoft.licm.impl.TrueLicenseKeyname;
import com.mulesoft.licm.security.KeyStoreParamBuilder;
import de.schlichtherle.license.CipherParam;
import de.schlichtherle.license.DefaultCipherParam;
import de.schlichtherle.license.DefaultKeyStoreParam;
import de.schlichtherle.license.KeyStoreParam;
import de.schlichtherle.license.LicenseContent;
import de.schlichtherle.license.ftp.LicenseManager;
import de.schlichtherle.license.ftp.LicenseParam;
import de.schlichtherle.util.ObfuscatedString;
import java.io.File;
import java.nio.file.Files;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import javax.security.auth.x500.X500Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TrueLicenseHelper
implements LicenseHelper {
    private static final String CONSUMER_TYPE_USER = "User";
    private static final Logger logger = LoggerFactory.getLogger(TrueLicenseHelper.class);
    static final String LICENSE_FILENAME = new ObfuscatedString(new long[]{7674583432497883263L, 9092825098713877854L, 3924184289828916512L}).toString();
    private static final String TOKEN_EQUALS = "=";
    private static final String TOKEN_COMMA = ",";
    private static final String ISSUER_NAME = new ObfuscatedString(new long[]{9025203709918143220L, 7687295577627216830L, -4120868743347406441L}).toString();
    private static final String ISSUER_ORG_UNIT = "";
    private static final String ISSUER_ORG = new ObfuscatedString(new long[]{-8184960286983176119L, 2936891996731662438L}).toString();
    private static final String ISSUER_STATE = new ObfuscatedString(new long[]{-2558887464932377223L, -48980570131099662L}).toString();
    private static final String ISSUER_COUNTRY = new ObfuscatedString(new long[]{6736034966506471186L, -5351820781856471164L}).toString();
    public static final String PUBLIC_KEYSTORE = new ObfuscatedString(new long[]{-1329250457924590046L, 8883820924921543643L, 7577804644442275284L}).toString();
    public static final String PUBLIC_KEYSTORE_FIPS = new ObfuscatedString(new long[]{7659062015855015228L, -7096590275894821919L, -2057589905597908979L, 4836611218692200095L}).toString();
    public static final String STORE_PASSWORD_FIPS = new ObfuscatedString(new long[]{7035541055588596796L, -5428697812283065020L, 7374813199551122687L}).toString();
    private static final String PRIVATE_KEYSTORE = new ObfuscatedString(new long[]{-2562065900073861945L, 5598860532196499802L, -2942155685739283597L, 177691783290404306L}).toString();
    private static final String PRIVATE_KEYSTORE_FIPS = new ObfuscatedString(new long[]{1611040975358888936L, 7359246257141152948L, 135481970019089857L, -5098936122225986369L, -6294374348877382319L}).toString();
    private static final String ALIAS = new ObfuscatedString(new long[]{5178985762545032702L, 9193815838879397018L}).toString();
    public static final String EVAL_ALIAS = new ObfuscatedString(new long[]{-243190734359859638L, 6762427657292449438L, 5162874349276728161L}).toString();
    public static final String KEY_PASSWORD = new ObfuscatedString(new long[]{6143136126810142985L, 8795700847773991693L}).toString();
    public static final String KEY_PASSWORD_FIPS = new ObfuscatedString(new long[]{7035541055588596796L, -5428697812283065020L, 7374813199551122687L}).toString();
    public static final String STORE_PASSWORD = new ObfuscatedString(new long[]{6143136126810142985L, 8795700847773991693L}).toString();
    static final String EVAL_MARKER_FILE = new ObfuscatedString(new long[]{3442369751299707987L, -2755550668709312818L, -2991211913604177192L}).toString();
    static final String PREF_MULE_EVALUATION = new ObfuscatedString(new long[]{-8882992121951343793L, -2290837093271381763L, 8884461155159543265L}).toString();
    private final boolean fipsEnabled;
    private LicenseManagementFactory factory;
    private LicenseManager publicManager;
    private String licenseSubject;
    private String licmKey;

    public TrueLicenseHelper(String licenseSubject, String licmKey) {
        this(licenseSubject, licmKey, false);
    }

    public TrueLicenseHelper(String licenseSubject, String licmKey, boolean fipsEnabled) {
        String useDefaultPreferencesFactory = System.getProperty("use.default.preferences.factory", "false");
        boolean isDefaultPreferencesFactory = Boolean.parseBoolean(useDefaultPreferencesFactory);
        this.licenseSubject = licenseSubject;
        this.licmKey = licmKey;
        this.fipsEnabled = fipsEnabled;
        if (!isDefaultPreferencesFactory) {
            System.setProperty("java.util.prefs.PreferencesFactory", "com.mulesoft.licm.pref.MulePreferencesFactory");
        }
        this.publicManager = this.createLicenseManager(true);
        this.factory = LicenseManagementFactory.getInstance();
    }

    private LicenseManager createLicenseManager(boolean isPublic) {
        KeyStoreParam keyStoreParam = this.createKeyStoreParams(isPublic);
        LicenseParam publicManagerParameters = this.createLicenseManagerParameters(keyStoreParam);
        return new LicenseManager(publicManagerParameters);
    }

    @Override
    public EnterpriseLicenseKey createLicenseKey(EnterpriseLicenseKeyRequest request) throws LicenseKeyException {
        if (request == null) {
            throw new IllegalArgumentException("Missing license request!");
        }
        EnterpriseLicenseKey key = this.factory.createLicenseKey(request.getProduct());
        try {
            LicenseManager privateManager = this.createLicenseManager(false);
            LicenseContent content = this.unpack(request);
            File licenseFile = new File(request.getLicenseKeyFile());
            privateManager.store(content, licenseFile);
            key.setLicenseKeyFile(licenseFile.getName());
            key.setEvaluation(false);
            key.setContactName(request.getContactName());
            key.setContactEmailAddress(request.getContactEmailAddress());
            key.setContactTelephone(request.getContactTelephone());
            key.setContactCompany(request.getContactCompany());
            key.setContactCountry(request.getContactCountry());
            key.setExpirationDate(request.getExpirationDate());
            for (Feature feature : request.getFeatures().getFeatures()) {
                key.setFeature(feature);
            }
        }
        catch (Exception e) {
            logger.error("Couldn't create license key!");
            throw new LicenseKeyException(e);
        }
        return key;
    }

    @Override
    public void installLicenseKey(EnterpriseLicenseKey key) throws LicenseKeyException {
        if (key == null) {
            throw new IllegalArgumentException("Missing license key!");
        }
        try {
            this.publicManager.install(new File(key.getLicenseKeyFile()));
            Preferences preferences = Preferences.userRoot().node(TrueLicenseKeyname.COM_MULESOFT_LICM.getValue());
            preferences.flush();
        }
        catch (Throwable e) {
            throw new LicenseKeyException(e);
        }
    }

    @Override
    public void unInstallLicenseKey() throws LicenseKeyException {
        try {
            this.publicManager.uninstall();
        }
        catch (Exception e) {
            logger.error("Couldn't uninstall license key!");
            throw new LicenseKeyException(e);
        }
    }

    @Override
    public EnterpriseLicenseKey validateLicenseKey(String product) throws InvalidLicenseKeyException {
        if (product == null) {
            throw new IllegalArgumentException("Missing key type!");
        }
        EnterpriseLicenseKey validLicenseKey = null;
        try {
            String test = this.publicManager.getLicenseParam().getPreferences().get("license", null);
            if (test != null) {
                String newtest = test;
                if (test.indexOf("\n") != -1) {
                    newtest = test.replaceAll("\n", ISSUER_ORG_UNIT);
                }
                if (test.indexOf(" ") != -1) {
                    newtest = newtest.replaceAll("\\s", ISSUER_ORG_UNIT);
                }
                if (newtest.compareToIgnoreCase(test) != 0) {
                    logger.debug("Applied license workaround");
                    this.publicManager.getLicenseParam().getPreferences().put("license", newtest);
                }
            }
            LicenseContent content = this.publicManager.verify();
            validLicenseKey = this.pack(content, product);
        }
        catch (Exception e) {
            throw new InvalidLicenseKeyException(e);
        }
        return validLicenseKey;
    }

    @Override
    public EnterpriseLicenseKey verifyLicenseKey(String product, File licenseFile) throws InvalidLicenseKeyException {
        EnterpriseLicenseKey validLicenseKey;
        if (product == null) {
            throw new IllegalArgumentException("Missing key type!");
        }
        try {
            LicenseContent content = this.publicManager.verify(Files.readAllBytes(licenseFile.toPath()));
            validLicenseKey = this.pack(content, product);
        }
        catch (Exception e) {
            throw new InvalidLicenseKeyException(e);
        }
        return validLicenseKey;
    }

    private EnterpriseLicenseKey pack(LicenseContent content, String product) {
        assert (content != null);
        assert (product != null);
        EnterpriseLicenseKey key = null;
        try {
            key = this.factory.createLicenseKey(product);
        }
        catch (LicenseKeyException e) {
            logger.error("Invalid License Key type!");
            return key;
        }
        String distinguishedName = content.getHolder().getName();
        assert (distinguishedName != null);
        String[] kvPairs = distinguishedName.split(TOKEN_COMMA);
        String[] contactNameKV = kvPairs[0].split(TOKEN_EQUALS);
        String contactName = contactNameKV[1];
        key.setContactName(contactName);
        if (contactName.equals("MuleSoft Support")) {
            key.setEvaluation(true);
        } else {
            key.setEvaluation(false);
        }
        String[] contactCompanyKV = kvPairs[2].split(TOKEN_EQUALS);
        String contactCompany = contactCompanyKV[1];
        key.setContactCompany(contactCompany);
        String[] contactEmailAddressKV = kvPairs[3].split(TOKEN_EQUALS);
        String contactEmailAddress = contactEmailAddressKV[1];
        key.setContactEmailAddress(contactEmailAddress);
        String[] contactTelephoneKV = kvPairs[4].split(TOKEN_EQUALS);
        String contactTelephone = contactTelephoneKV[1];
        key.setContactTelephone(contactTelephone);
        String[] contactCountryKV = kvPairs[5].split(TOKEN_EQUALS);
        String contactCountry = contactCountryKV[1];
        key.setContactCountry(contactCountry);
        key.setExpirationDate(content.getNotAfter());
        if (content.getExtra() != null) {
            StringTokenizer st = new StringTokenizer((String)content.getExtra(), TOKEN_COMMA);
            while (st.hasMoreTokens()) {
                String featureId = st.nextToken();
                Feature temp = new Feature(featureId, featureId);
                key.setFeature(temp);
            }
        }
        return key;
    }

    private KeyStoreParam createKeyStoreParams(boolean isPublic) {
        DefaultKeyStoreParam keyStoreParam = null;
        keyStoreParam = isPublic ? KeyStoreParamBuilder.getKeyStoreParamBuilder().withAlias(ALIAS).isFipsCompliant(this.fipsEnabled).withClazz(this.getClass()).build() : KeyStoreParamBuilder.getKeyStoreParamBuilder().withAlias(ALIAS).withKeyPassword(this.fipsEnabled ? KEY_PASSWORD_FIPS : KEY_PASSWORD).withKeyStoreName(this.fipsEnabled ? PRIVATE_KEYSTORE_FIPS : PRIVATE_KEYSTORE).isFipsCompliant(this.fipsEnabled).withClazz(this.getClass()).build();
        return keyStoreParam;
    }

    private LicenseParam createLicenseManagerParameters(KeyStoreParam keyStoreParam) {
        assert (keyStoreParam != null);
        DefaultCipherParam cipherParam = new DefaultCipherParam(KEY_PASSWORD);
        if (this.fipsEnabled) {
            cipherParam = new DefaultCipherParam(KEY_PASSWORD_FIPS);
        }
        Preferences preferences = Preferences.userRoot().node(this.licmKey);
        MuleLicenseKeyParam licenseManagerParameters = new MuleLicenseKeyParam(this.licenseSubject, preferences, keyStoreParam, (CipherParam)cipherParam, this.fipsEnabled);
        return licenseManagerParameters;
    }

    private LicenseContent unpack(EnterpriseLicenseKeyRequest request) {
        assert (request != null);
        LicenseContent content = new LicenseContent();
        content.setSubject(this.licenseSubject);
        X500Principal licenseHolder = this.getContactDetails(request);
        content.setHolder(licenseHolder);
        X500Principal licenseIssuer = TrueLicenseHelper.getIssuerDetails();
        content.setIssuer(licenseIssuer);
        content.setIssued(new Date());
        content.setNotAfter(request.getExpirationDate());
        content.setConsumerType(CONSUMER_TYPE_USER);
        List featuresList = request.getFeatures().getFeatures();
        Iterator iterator = featuresList.iterator();
        StringBuffer buffer = new StringBuffer();
        int count = 0;
        while (iterator.hasNext()) {
            if (count != 0) {
                buffer.append(TOKEN_COMMA);
            }
            Feature feature = (Feature)iterator.next();
            buffer.append(feature.getId());
            ++count;
        }
        content.setExtra((Object)buffer.toString());
        return content;
    }

    private X500Principal getContactDetails(EnterpriseLicenseKeyRequest request) {
        assert (request != null);
        X500Principal contactDetails = null;
        StringBuffer dnBuffer = new StringBuffer();
        dnBuffer.append("CN=").append(request.getContactName()).append(", ");
        dnBuffer.append("OU=").append(ISSUER_ORG_UNIT).append(", ");
        dnBuffer.append("O=").append(request.getContactCompany()).append(", ");
        dnBuffer.append("UID=").append(request.getContactEmailAddress()).append(", ");
        dnBuffer.append("L=").append(request.getContactTelephone()).append(", ");
        dnBuffer.append("C=").append(request.getContactCountry());
        String contactName = new String(dnBuffer);
        contactDetails = new X500Principal(contactName);
        return contactDetails;
    }

    static X500Principal getIssuerDetails() {
        X500Principal issuerDetails = null;
        StringBuffer dnBuffer = new StringBuffer();
        dnBuffer.append("CN=").append(ISSUER_NAME).append(", ");
        dnBuffer.append("OU=").append(ISSUER_ORG_UNIT).append(", ");
        dnBuffer.append("O=").append(ISSUER_ORG).append(", ");
        dnBuffer.append("L=").append(ISSUER_STATE).append(", ");
        dnBuffer.append("C=").append(ISSUER_COUNTRY);
        String distinguishedName = new String(dnBuffer);
        issuerDetails = new X500Principal(distinguishedName);
        return issuerDetails;
    }

    public boolean islicenseNotNull() {
        return this.publicManager.getLicenseParam().getPreferences().get("license", null) != null;
    }

    public String getLicmKey() {
        return this.licmKey;
    }

    public String getLicenseSubject() {
        return this.licenseSubject;
    }

    public boolean isFipsEnabled() {
        return this.fipsEnabled;
    }
}

