/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.licm;

import com.mulesoft.licm.EnterpriseLicense;
import com.mulesoft.licm.EnterpriseLicenseKey;
import com.mulesoft.licm.EnterpriseLicenseKeyRequest;
import com.mulesoft.licm.EntitlementsConfigReader;
import com.mulesoft.licm.LicenseKeyException;
import com.mulesoft.licm.LicenseManagementFactory;
import com.mulesoft.licm.LicenseManager;
import com.mulesoft.licm.feature.Feature;
import com.mulesoft.licm.feature.FeatureSet;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LicenseGenerator {
    private static final Logger logger = LoggerFactory.getLogger(LicenseGenerator.class);
    private static final String SUPPORTED_DATE_FORMAT = "yyyy-MM-dd";
    private EnterpriseLicenseKeyRequest request;
    private LicenseManagementFactory factory = LicenseManagementFactory.getInstance();
    private String product;

    public static void main(String[] args) {
        LicenseGenerator licGen = new LicenseGenerator();
        Options options = LicenseGenerator.setupCommandLineOptions(args);
        CommandLine line = LicenseGenerator.parseCommandLineOptions(options, args);
        if (line != null) {
            boolean rc = licGen.process(line, options);
            EnterpriseLicense key = null;
            if (rc) {
                key = licGen.createLicenseKey();
            }
            if (key != null) {
                System.out.println();
                System.out.println("License key generated successfully to file: " + key.getLicenseKeyFile() + ".");
                System.out.println(key);
                System.exit(0);
            } else {
                System.exit(1);
            }
        } else {
            System.exit(1);
        }
    }

    private EnterpriseLicense createLicenseKey() {
        EnterpriseLicenseKey key = null;
        try {
            LicenseManager licManager = this.factory.createLicenseManager(this.product);
            key = licManager.create(this.request);
        }
        catch (LicenseKeyException e) {
            logger.error("Couldn't generate license key!", (Throwable)e);
        }
        return key;
    }

    private boolean process(CommandLine line, Options options) {
        boolean rc;
        block23: {
            rc = false;
            if (!line.hasOption("h")) {
                Date expirationDate;
                block24: {
                    if (line.hasOption("p")) {
                        this.product = line.getOptionValue("p");
                        try {
                            this.request = this.factory.createLicenseRequest(this.product);
                        }
                        catch (LicenseKeyException e) {
                            logger.error("Unrecognized product value!", (Throwable)e);
                            break block23;
                        }
                    }
                    if (line.hasOption("d")) {
                        SimpleDateFormat dateFormat = new SimpleDateFormat(SUPPORTED_DATE_FORMAT);
                        dateFormat.setLenient(false);
                        expirationDate = null;
                        try {
                            String dateStr = line.getOptionValue("d");
                            expirationDate = dateFormat.parse(dateStr);
                            break block24;
                        }
                        catch (java.text.ParseException e) {
                            logger.error("Invalid date format!", (Throwable)e);
                            break block23;
                        }
                    }
                    logger.error("Missing option - 'd'!");
                    break block23;
                }
                this.request.setExpirationDate(expirationDate);
                if (!line.hasOption("n")) {
                    logger.error("Missing option - 'n'!");
                } else {
                    String name = line.getOptionValue("n");
                    this.request.setContactName(name);
                    if (!line.hasOption("e")) {
                        logger.error("Missing option - 'e'!");
                    } else {
                        String email = line.getOptionValue("e");
                        this.request.setContactEmailAddress(email);
                        if (!line.hasOption("t")) {
                            logger.error("Missing option - 't'!");
                        } else {
                            String telephone = line.getOptionValue("t");
                            this.request.setContactTelephone(telephone);
                            if (!line.hasOption("c")) {
                                logger.error("Missing option - 'c'!");
                            } else {
                                String company = line.getOptionValue("c");
                                this.request.setContactCompany(company);
                                if (!line.hasOption("C")) {
                                    logger.error("Missing option - 'C'!");
                                } else {
                                    String country = line.getOptionValue("C");
                                    this.request.setContactCountry(country);
                                    if (!line.hasOption("f")) {
                                        logger.error("Missing option - 'f'!");
                                    } else {
                                        String file = line.getOptionValue("f");
                                        this.request.setLicenseKeyFile(file);
                                        if (line.hasOption("en")) {
                                            String entitlement = line.getOptionValue("en");
                                            EntitlementsConfigReader.read(entitlement);
                                            FeatureSet featureSet = EntitlementsConfigReader.getFeatureSet();
                                            List featuresList = featureSet.getFeatures();
                                            for (Feature feature : featuresList) {
                                                this.request.setFeature(feature);
                                            }
                                        } else {
                                            logger.error("Missing option - 'en'! Entitlements disabled!");
                                        }
                                        rc = true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (!rc) {
            LicenseGenerator.printHelp(options);
        }
        return rc;
    }

    private static Options setupCommandLineOptions(String[] args) {
        Options options = new Options();
        options.addOption("h", "help", false, "Help Message");
        options.addOption("p", "product", true, "Product [mule-ee|...] <Mandatory>");
        options.addOption("d", "date", true, "Expiration Date [yyyy-MM-dd], <Mandatory>");
        options.addOption("n", "name", true, "Contact Name, <Mandatory>");
        options.addOption("e", "email", true, "Contact Email Address, <Mandatory>");
        options.addOption("t", "telephone-number", true, "Contact Telephone Number, <Mandatory>");
        options.addOption("c", "company", true, "Contact Company Name, <Mandatory>");
        options.addOption("C", "country", true, "Contact Country, <Mandatory>");
        options.addOption("f", "license-file", true, "License Key File, <Mandatory>");
        options.addOption("en", "entitlement", true, "Entitlement, <Mandatory> (as per options in entitlements.xml)");
        return options;
    }

    private static CommandLine parseCommandLineOptions(Options options, String[] args) {
        CommandLine commandLine = null;
        try {
            GnuParser parser = new GnuParser();
            commandLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            logger.error("Parsing failed!", (Throwable)e);
            LicenseGenerator.printHelp(options);
        }
        return commandLine;
    }

    private static void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("LicenseGenerator", options);
    }
}

