/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.ic.internal.runtime.connection;

import com.mulesoft.connectivity.mule.api.MuleConnectivityService;
import com.mulesoft.connectivity.mule.api.Page;
import com.mulesoft.connectivity.mule.api.ServiceConfiguration;
import com.mulesoft.connectivity.mule.api.operation.OperationResult;
import com.mulesoft.connectivity.mule.api.operation.ResultError;
import com.mulesoft.connectivity.mule.api.trigger.NextData;
import com.mulesoft.connectivity.mule.api.trigger.TriggerPage;
import com.mulesoft.connectivity.mule.api.valueprovider.ProvidedValue;
import com.mulesoft.connectivity.mule.persistence.model.MuleMetadataProviderSerializableModel;
import com.mulesoft.connectivity.mule.persistence.model.MuleOperationSerializableModel;
import com.mulesoft.connectivity.mule.persistence.model.MuleSourceSerializableModel;
import com.mulesoft.connectivity.mule.persistence.model.MuleValueProviderSerializableModel;
import com.mulesoft.connectivity.mule.persistence.model.SerializableModel;
import com.mulesoft.connectivity.mule.persistence.model.connection.HttpAuthenticationType;
import com.mulesoft.connectivity.mule.persistence.model.connection.MuleConnectionProviderSerializableModel;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.http.api.client.HttpClient;

public class Connection {
    private static final String ACCESS_TOKEN_EXPIRED_ERROR_KIND = "401";
    private final Map<String, Object> params;
    private final MuleConnectionProviderSerializableModel model;
    private final ServiceConfiguration config;
    private final MuleConnectivityService muleConnectivityService;

    public Connection(Map<String, Object> params, MuleConnectionProviderSerializableModel model, MuleConnectivityService muleConnectivityService, HttpClient httpClient) {
        this.params = params;
        this.model = model;
        this.muleConnectivityService = muleConnectivityService;
        this.config = new ServiceConfiguration(Map.of(ServiceConfiguration.CLIENT_TYPE.HTTPCLIENT.name(), httpClient));
    }

    public ConnectionValidationResult testConnection() {
        String testConnectionSelector = Connection.getModelReference((SerializableModel)this.model.getTestConnection());
        String connectionProviderSelector = Connection.getModelReference((SerializableModel)this.model);
        return this.muleConnectivityService.testConnectivity(testConnectionSelector, connectionProviderSelector, this.params, this.config);
    }

    public OperationResult<?> executeOperation(MuleOperationSerializableModel operationModel, Map<String, Object> operationParams) {
        String connectionProviderSelector = Connection.getModelReference((SerializableModel)this.model);
        String operationModelReference = Connection.getModelReference((SerializableModel)operationModel);
        return this.muleConnectivityService.executeOperation(connectionProviderSelector, this.params, operationModelReference, operationParams, operationModel.isPaginated(), this.config);
    }

    public OperationResult<?> executeOperationNextPage(MuleOperationSerializableModel operationModel, Object operationParams) {
        String connectionProviderSelector = Connection.getModelReference((SerializableModel)this.model);
        String operationModelReference = Connection.getModelReference((SerializableModel)operationModel);
        return this.muleConnectivityService.executeOperationNextPage(connectionProviderSelector, this.params, operationModelReference, operationParams, this.config);
    }

    public OperationResult<Page<ProvidedValue>> executeValueProvider(MuleValueProviderSerializableModel valueProviderModel, Map<String, Object> valueProviderParams) {
        String connectionProviderSelector = Connection.getModelReference((SerializableModel)this.model);
        String valueProviderModelReference = Connection.getModelReference((SerializableModel)valueProviderModel);
        return this.muleConnectivityService.executeValueProvider(connectionProviderSelector, this.params, valueProviderModelReference, valueProviderParams, valueProviderModel.isPaginated(), this.config);
    }

    public OperationResult<MetadataType> executeMetadataProvider(MuleMetadataProviderSerializableModel metadataProviderModel, Map<String, Object> metadataProviderParams) {
        String connectionProviderSelector = Connection.getModelReference((SerializableModel)this.model);
        String metadataProviderModelReference = Connection.getModelReference((SerializableModel)metadataProviderModel);
        return this.muleConnectivityService.executeMetadataProvider(connectionProviderSelector, this.params, metadataProviderModelReference, metadataProviderParams, this.config);
    }

    public OperationResult<Page<ProvidedValue>> executeValueProviderNextPage(MuleValueProviderSerializableModel valueProviderModel, Object nextPageData) {
        String connectionProviderSelector = Connection.getModelReference((SerializableModel)this.model);
        String valueProviderModelReference = Connection.getModelReference((SerializableModel)valueProviderModel);
        return this.muleConnectivityService.executeValueProviderNextPage(connectionProviderSelector, this.params, valueProviderModelReference, nextPageData, this.config);
    }

    private static String getModelReference(SerializableModel model) {
        return model.getModelReference().filter(Predicate.not(String::isEmpty)).orElseThrow(() -> new IllegalStateException("Model must have a valid selector set as model reference"));
    }

    public HttpAuthenticationType getConnectionType() {
        return this.model.getAuthenticationType();
    }

    public int compareWatermarks(MuleSourceSerializableModel sourceModel, Serializable a, Serializable b) {
        return this.muleConnectivityService.executeTriggerCompareWatermark(Connection.getModelReference((SerializableModel)sourceModel), b, a, this.config);
    }

    public Serializable getInitialWatermark(MuleSourceSerializableModel sourceModel, Map<String, Object> sourceParams) {
        return this.muleConnectivityService.getInitialWatermark(Connection.getModelReference((SerializableModel)this.model), this.params, Connection.getModelReference((SerializableModel)sourceModel), sourceParams, this.config);
    }

    public OperationResult<TriggerPage> executeTrigger(MuleSourceSerializableModel sourceModel, Serializable watermark, Map<String, Object> sourceParams) {
        return this.muleConnectivityService.executeTrigger(Connection.getModelReference((SerializableModel)this.model), this.params, Connection.getModelReference((SerializableModel)sourceModel), (Object)watermark, sourceParams, this.config);
    }

    public OperationResult<TriggerPage> executeTriggerNextPage(MuleSourceSerializableModel sourceModel, NextData nextData) {
        return this.muleConnectivityService.executeTriggerNextPage(Connection.getModelReference((SerializableModel)this.model), this.params, Connection.getModelReference((SerializableModel)sourceModel), nextData, this.config);
    }

    public boolean isTokenExpired(OperationResult<?> result) {
        HttpAuthenticationType type = this.model.getAuthenticationType();
        if (type != null && type.getType() == HttpAuthenticationType.Type.oauth2) {
            String errorKind = result.getErrorValue().getKind();
            return errorKind.equalsIgnoreCase(ACCESS_TOKEN_EXPIRED_ERROR_KIND);
        }
        return false;
    }

    public static ResultError getErrorCauseIfUncheckedError(ResultError errorValue) {
        Optional resultErrorCause = errorValue.getCause();
        if (errorValue.getKind().equalsIgnoreCase("__UNCHECKED") && resultErrorCause.isPresent()) {
            errorValue = (ResultError)resultErrorCause.get();
        }
        return errorValue;
    }
}

