/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.ic.internal.parser;

import com.mulesoft.connectivity.mule.persistence.model.MuleValueProviderSerializableModel;
import com.mulesoft.connectivity.mule.persistence.model.provider.SerializedProviderReferences;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.mule.metadata.api.annotation.DefaultValueAnnotation;
import org.mule.metadata.api.annotation.DescriptionAnnotation;
import org.mule.metadata.api.annotation.LabelAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.extension.api.declaration.type.annotation.SemanticTermsTypeAnnotation;
import org.mule.runtime.extension.api.loader.parser.ValueProviderModelParser;
import org.mule.runtime.extension.api.loader.parser.metadata.InputResolverModelParser;
import org.mule.runtime.extension.ic.internal.parser.ConnectivityInputResolverModelParser;
import org.mule.runtime.extension.ic.internal.parser.ConnectivityValueProviderParser;
import org.mule.runtime.extension.ic.internal.parser.ParameterModelParserWithDefaults;
import org.mule.runtime.extension.ic.internal.parser.utils.AnnotationUtils;

public class ConnectivityParameterModelParser
implements ParameterModelParserWithDefaults {
    private final ObjectFieldType objectFieldType;
    private final Set<TypeAnnotation> annotations;
    private final MuleValueProviderSerializableModel muleValueProviderSerializableModel;
    private final ConnectivityInputResolverModelParser connectivityInputResolverModelParser;
    private final SerializedProviderReferences providerReferences;
    private static final Set<String> ADVANCED_TAB_PARAMETERS = Set.of("customHeaders", "customQueryParams");
    private static final Set<String> SENSITIVE_TERMS = Set.of("password", "secretToken", "apiKey");
    private final Boolean isMetadataKey;

    public ConnectivityParameterModelParser(ObjectFieldType param, MuleValueProviderSerializableModel valueProviderSerializableModel, ConnectivityInputResolverModelParser connectivityInputResolverModelParser, SerializedProviderReferences providerRefs, boolean isMetadataKey) {
        this.providerReferences = providerRefs;
        this.objectFieldType = param;
        this.annotations = this.objectFieldType.getValue().getAnnotations();
        this.muleValueProviderSerializableModel = valueProviderSerializableModel;
        this.connectivityInputResolverModelParser = connectivityInputResolverModelParser;
        this.isMetadataKey = isMetadataKey;
    }

    public String getName() {
        return this.objectFieldType.getKey().getName().getLocalPart();
    }

    public String getDescription() {
        return AnnotationUtils.findAnnotation(this.annotations, DescriptionAnnotation.class).map(DescriptionAnnotation::getValue).orElse("");
    }

    public MetadataType getType() {
        return this.objectFieldType.getValue();
    }

    public boolean isRequired() {
        return this.objectFieldType.isRequired();
    }

    @Override
    public Object getDefaultValue() {
        return AnnotationUtils.findAnnotation(this.annotations, DefaultValueAnnotation.class).map(DefaultValueAnnotation::getValue).orElse(null);
    }

    public ParameterRole getRole() {
        if (this.objectFieldType.getValue() instanceof ObjectType) {
            return ParameterRole.CONTENT;
        }
        return ParameterRole.BEHAVIOUR;
    }

    public ExpressionSupport getExpressionSupport() {
        return ExpressionSupport.SUPPORTED;
    }

    @Override
    public Optional<LayoutModel> getLayoutModel() {
        if (ADVANCED_TAB_PARAMETERS.contains(this.getName())) {
            return Optional.of(LayoutModel.builder().tabName("Advanced").build());
        }
        return AnnotationUtils.findAnnotation(this.annotations, SemanticTermsTypeAnnotation.class).flatMap(annotation -> annotation.getSemanticTerms().stream().flatMap(term -> SENSITIVE_TERMS.stream().filter(term::contains)).findFirst().map(__ -> LayoutModel.builder().asPassword().build()));
    }

    @Override
    public Optional<ValueProviderModelParser> getValueProviderModelParser() {
        if (this.muleValueProviderSerializableModel == null) {
            return Optional.empty();
        }
        List serializedArguments = this.providerReferences.getValueProviderReference() != null ? this.providerReferences.getValueProviderReference().getArguments() : List.of();
        return Optional.of(new ConnectivityValueProviderParser(this.muleValueProviderSerializableModel, serializedArguments));
    }

    @Override
    public Optional<InputResolverModelParser> getInputResolverModelParser() {
        if (this.connectivityInputResolverModelParser == null) {
            return Optional.empty();
        }
        return Optional.of(this.connectivityInputResolverModelParser);
    }

    @Override
    public Optional<DisplayModel> getDisplayModel() {
        String displayName = AnnotationUtils.findAnnotation(this.annotations, LabelAnnotation.class).map(LabelAnnotation::getValue).orElse(this.objectFieldType.getKey().getName().getLocalPart());
        String description = AnnotationUtils.findAnnotation(this.annotations, DescriptionAnnotation.class).map(DescriptionAnnotation::getValue).orElse("");
        return Optional.of(DisplayModel.builder().displayName(displayName).summary(description).build());
    }

    @Override
    public Set<String> getSemanticTerms() {
        return AnnotationUtils.getSemanticTerms(this.annotations);
    }

    @Override
    public Optional<Pair<Integer, Boolean>> getMetadataKeyPart() {
        if (this.isMetadataKey.booleanValue()) {
            return Optional.of(new Pair((Object)1, (Object)false));
        }
        return Optional.empty();
    }
}

