/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.ic.internal.parser;

import com.mulesoft.connectivity.mule.persistence.model.MuleConnectorSerializableModel;
import com.mulesoft.connectivity.mule.persistence.model.MuleExecutableComponentSerializableModel;
import com.mulesoft.connectivity.mule.persistence.model.MuleMetadataProviderSerializableModel;
import com.mulesoft.connectivity.mule.persistence.model.provider.SerializedObjectFieldSelector;
import com.mulesoft.connectivity.mule.persistence.model.provider.SerializedProviderArgument;
import com.mulesoft.connectivity.mule.persistence.model.provider.SerializedProviderReference;
import com.mulesoft.connectivity.mule.persistence.model.provider.SerializedProviderReferences;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.model.ComponentVisibility;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.notification.NotificationModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.extension.api.loader.parser.AttributesResolverModelParser;
import org.mule.runtime.extension.api.loader.parser.MediaTypeParser;
import org.mule.runtime.extension.api.loader.parser.MinMuleVersionParser;
import org.mule.runtime.extension.api.loader.parser.ParameterGroupModelParser;
import org.mule.runtime.extension.api.loader.parser.StereotypeModelFactory;
import org.mule.runtime.extension.api.loader.parser.metadata.MetadataKeyModelParser;
import org.mule.runtime.extension.api.loader.parser.metadata.OutputResolverModelParser;
import org.mule.runtime.extension.api.runtime.exception.SdkExceptionHandlerFactory;
import org.mule.runtime.extension.ic.internal.parser.ConnectivityInputResolverModelParser;
import org.mule.runtime.extension.ic.internal.parser.ConnectivityMetadataKeyModelParser;
import org.mule.runtime.extension.ic.internal.parser.ConnectivityOutputResolverModelParser;
import org.mule.runtime.extension.ic.internal.parser.utils.ModelParserUtils;

public abstract class ConnectivityExecutableModelParser<T extends MuleExecutableComponentSerializableModel> {
    protected final T model;
    protected final MuleConnectorSerializableModel connectorModel;
    private OutputResolverModelParser outputResolverModelParser;
    private final Map<String, ConnectivityInputResolverModelParser> inputTypeResolverModelParserMap = new HashMap<String, ConnectivityInputResolverModelParser>();
    private String metadataKeyParameterName;
    private String metadataKeyInputFieldName;

    public ConnectivityExecutableModelParser(MuleConnectorSerializableModel connectorModel, T model) {
        this.connectorModel = connectorModel;
        this.model = model;
        this.initializeMetadataTypeResolverParsers();
    }

    private void initializeMetadataTypeResolverParsers() {
        this.initializeOutputResolver();
        this.initializeInputResolverParsers();
    }

    private void initializeOutputResolver() {
        if (this.model.getOutputResolvedProviders() == null || this.model.getOutputResolvedProviders().isEmpty()) {
            return;
        }
        for (Map.Entry entry : this.model.getOutputResolvedProviders().entrySet()) {
            SerializedProviderReference metadataProviderReference;
            SerializedObjectFieldSelector serializedObjectFieldSelector = (SerializedObjectFieldSelector)entry.getKey();
            SerializedProviderReferences serializedProviderReferences = (SerializedProviderReferences)entry.getValue();
            if (serializedProviderReferences == null || serializedObjectFieldSelector == null || (metadataProviderReference = serializedProviderReferences.getMetadataProviderReference()) == null) continue;
            List metadataProviderReferenceArguments = metadataProviderReference.getArguments();
            this.trySetMetadataKeyFields(metadataProviderReferenceArguments);
            MuleMetadataProviderSerializableModel metadataProvider = this.connectorModel.getMetadataProvider(metadataProviderReference.getName());
            this.outputResolverModelParser = new ConnectivityOutputResolverModelParser(this.getName(), metadataProvider, metadataProviderReferenceArguments);
            break;
        }
    }

    private void initializeInputResolverParsers() {
        if (this.model.getInputResolvedProviders() == null || this.model.getInputResolvedProviders().isEmpty()) {
            return;
        }
        for (Map.Entry entry : this.model.getInputResolvedProviders().entrySet()) {
            SerializedProviderReference metadataProviderReference;
            SerializedObjectFieldSelector serializedObjectFieldSelector = (SerializedObjectFieldSelector)entry.getKey();
            SerializedProviderReferences serializedProviderReferences = (SerializedProviderReferences)entry.getValue();
            if (serializedProviderReferences == null || serializedObjectFieldSelector == null || (metadataProviderReference = serializedProviderReferences.getMetadataProviderReference()) == null) continue;
            String paramName = serializedObjectFieldSelector.getPath()[0];
            MuleMetadataProviderSerializableModel metadataProvider = this.connectorModel.getMetadataProvider(metadataProviderReference.getName());
            List metadataProviderReferenceArguments = metadataProviderReference.getArguments();
            if (this.metadataKeyParameterName == null) {
                this.trySetMetadataKeyFields(metadataProviderReferenceArguments);
            }
            if (paramName == null || metadataProvider == null) break;
            this.inputTypeResolverModelParserMap.put(paramName, new ConnectivityInputResolverModelParser(paramName, this.getName(), metadataProvider, metadataProviderReferenceArguments));
            break;
        }
    }

    private void trySetMetadataKeyFields(List<SerializedProviderArgument> metadataProviderReferenceArguments) {
        if (metadataProviderReferenceArguments == null || metadataProviderReferenceArguments.isEmpty()) {
            return;
        }
        this.metadataKeyParameterName = metadataProviderReferenceArguments.get(0).getParameterSelector().getPath()[0];
        this.metadataKeyInputFieldName = ((SerializedObjectFieldSelector)metadataProviderReferenceArguments.get(0).getInputSelector()).getPath()[0];
    }

    public String getName() {
        return this.model.getName();
    }

    public String getDescription() {
        return this.model.getDisplayName();
    }

    public List<ParameterGroupModelParser> getParameterGroupModelParsers() {
        return ModelParserUtils.getParameterGroupParser(this.connectorModel, this.model.getInputType(), this.model.getInputResolvedProviders(), "General", false, List.of(), this.inputTypeResolverModelParserMap, this.metadataKeyInputFieldName);
    }

    public boolean isIgnored() {
        return false;
    }

    public boolean isConnected() {
        return true;
    }

    public boolean isTransactional() {
        return false;
    }

    public Optional<MediaTypeParser> getMediaType() {
        return Optional.empty();
    }

    public Optional<SdkExceptionHandlerFactory> getExceptionHandlerFactory() {
        return Optional.empty();
    }

    public Optional<DeprecationModel> getDeprecationModel() {
        return Optional.empty();
    }

    public Optional<MinMuleVersionParser> getResolvedMinMuleVersion() {
        return Optional.empty();
    }

    public Optional<OutputResolverModelParser> getOutputResolverModelParser() {
        return this.outputResolverModelParser == null ? Optional.empty() : Optional.of(this.outputResolverModelParser);
    }

    public Optional<AttributesResolverModelParser> getAttributesResolverModelParser() {
        return Optional.empty();
    }

    public Optional<MetadataKeyModelParser> getMetadataKeyModelParser() {
        return Optional.of(new ConnectivityMetadataKeyModelParser(this.metadataKeyParameterName, this.getName(), (MetadataType)new BaseTypeBuilder(MetadataFormat.JAVA).stringType().build()));
    }

    public List<ModelProperty> getAdditionalModelProperties() {
        return List.of();
    }

    public boolean hasConfig() {
        return true;
    }

    public ComponentVisibility getComponentVisibility() {
        return ComponentVisibility.PUBLIC;
    }

    public Stream<NotificationModel> getEmittedNotificationsStream(Function<String, Optional<NotificationModel>> notificationMapper) {
        return Stream.empty();
    }

    public Optional<StereotypeModel> getStereotype(StereotypeModelFactory factory) {
        return Optional.empty();
    }
}

