/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.ic.internal.parser;

import com.mulesoft.connectivity.mule.persistence.model.MuleConnectorSerializableModel;
import com.mulesoft.connectivity.mule.persistence.model.connection.HttpAuthenticationType;
import com.mulesoft.connectivity.mule.persistence.model.connection.MuleConnectionProviderSerializableModel;
import com.mulesoft.connectivity.mule.persistence.model.connection.oauth.OAuth2AuthCodeAuthenticationType;
import com.mulesoft.connectivity.mule.persistence.model.connection.oauth.OAuth2ClientCredentialsAuthenticationType;
import com.mulesoft.connectivity.mule.persistence.model.provider.SerializedObjectFieldSelector;
import com.mulesoft.connectivity.mule.persistence.model.provider.SerializedProviderReferences;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.mule.metadata.api.annotation.DescriptionAnnotation;
import org.mule.metadata.api.annotation.LabelAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.runtime.api.meta.model.ExternalLibraryModel;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.connection.ConnectionManagementType;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthModelProperty;
import org.mule.runtime.extension.api.loader.parser.ConnectionProviderModelParser;
import org.mule.runtime.extension.api.loader.parser.MinMuleVersionParser;
import org.mule.runtime.extension.api.loader.parser.ParameterGroupModelParser;
import org.mule.runtime.extension.api.loader.parser.StereotypeModelFactory;
import org.mule.runtime.extension.api.runtime.connectivity.ConnectionProviderFactory;
import org.mule.runtime.extension.ic.internal.loader.property.OAuthGrantTypeFactory;
import org.mule.runtime.extension.ic.internal.parser.utils.AnnotationUtils;
import org.mule.runtime.extension.ic.internal.parser.utils.ModelParserUtils;
import org.mule.runtime.extension.ic.internal.runtime.connection.ConnectivityConnectionProviderFactory;

public class ConnectivityConnectionProviderModelParser
implements ConnectionProviderModelParser {
    private final MuleConnectorSerializableModel muleConnectorSerializableModel;
    private final MuleConnectionProviderSerializableModel muleConnectionProviderSerializableModel;
    private final Set<TypeAnnotation> annotations;

    public ConnectivityConnectionProviderModelParser(MuleConnectorSerializableModel muleConnectorSerializableModel, MuleConnectionProviderSerializableModel muleConnectionProviderSerializableModel) {
        this.muleConnectorSerializableModel = muleConnectorSerializableModel;
        this.muleConnectionProviderSerializableModel = muleConnectionProviderSerializableModel;
        this.annotations = muleConnectionProviderSerializableModel.getInputType().getAnnotations();
    }

    public String getName() {
        return this.muleConnectionProviderSerializableModel.getName();
    }

    public String getDescription() {
        return AnnotationUtils.findAnnotation(this.annotations, DescriptionAnnotation.class).map(DescriptionAnnotation::getValue).orElse("");
    }

    public List<ParameterGroupModelParser> getParameterGroupModelParsers() {
        return ModelParserUtils.getParameterGroupParser(this.muleConnectorSerializableModel, this.muleConnectionProviderSerializableModel.getInputType(), new HashMap<SerializedObjectFieldSelector, SerializedProviderReferences>(), "General", true, this.paramsToOmit(this.muleConnectionProviderSerializableModel), Map.of(), null);
    }

    public List<ExternalLibraryModel> getExternalLibraryModels() {
        return List.of();
    }

    public ConnectionManagementType getConnectionManagementType() {
        return ConnectionManagementType.NONE;
    }

    public Optional<ConnectionProviderFactory<?>> getConnectionProviderFactory() {
        return Optional.of(new ConnectivityConnectionProviderFactory(this.muleConnectionProviderSerializableModel));
    }

    public boolean supportsConnectivityTesting() {
        return this.muleConnectionProviderSerializableModel.getTestConnection() != null;
    }

    public boolean supportsXa() {
        return false;
    }

    public boolean isExcludedFromConnectivitySchema() {
        return false;
    }

    public Optional<OAuthModelProperty> getOAuthModelProperty() {
        LinkedList<OAuthGrantType> grantTypes = new LinkedList<OAuthGrantType>();
        HttpAuthenticationType httpAuthenticationType = this.muleConnectionProviderSerializableModel.getAuthenticationType();
        if (httpAuthenticationType instanceof OAuth2ClientCredentialsAuthenticationType) {
            OAuth2ClientCredentialsAuthenticationType authTypeCc = (OAuth2ClientCredentialsAuthenticationType)httpAuthenticationType;
            grantTypes.add(OAuthGrantTypeFactory.createClientCredentialsGrantType(authTypeCc));
        } else {
            httpAuthenticationType = this.muleConnectionProviderSerializableModel.getAuthenticationType();
            if (httpAuthenticationType instanceof OAuth2AuthCodeAuthenticationType) {
                OAuth2AuthCodeAuthenticationType authTypeAc = (OAuth2AuthCodeAuthenticationType)httpAuthenticationType;
                grantTypes.add(OAuthGrantTypeFactory.createAuthorizationCodeGrantType(authTypeAc));
            }
        }
        return grantTypes.isEmpty() ? Optional.empty() : Optional.of(new OAuthModelProperty(grantTypes));
    }

    public List<ModelProperty> getAdditionalModelProperties() {
        return List.of();
    }

    public Optional<DeprecationModel> getDeprecationModel() {
        return Optional.empty();
    }

    public Optional<DisplayModel> getDisplayModel() {
        Optional<String> displayName = AnnotationUtils.findAnnotation(this.annotations, LabelAnnotation.class).map(LabelAnnotation::getValue);
        Optional<String> description = AnnotationUtils.findAnnotation(this.annotations, DescriptionAnnotation.class).map(DescriptionAnnotation::getValue);
        if (displayName.isPresent() || description.isPresent()) {
            DisplayModel.DisplayModelBuilder builder = DisplayModel.builder();
            displayName.ifPresent(arg_0 -> ((DisplayModel.DisplayModelBuilder)builder).displayName(arg_0));
            description.ifPresent(arg_0 -> ((DisplayModel.DisplayModelBuilder)builder).summary(arg_0));
            return Optional.of(builder.build());
        }
        return Optional.empty();
    }

    public Optional<MinMuleVersionParser> getResolvedMinMuleVersion() {
        return Optional.empty();
    }

    public Set<String> getSemanticTerms() {
        return AnnotationUtils.getSemanticTerms(this.annotations);
    }

    public Optional<StereotypeModel> getStereotype(StereotypeModelFactory factory) {
        return Optional.empty();
    }

    private List<String> paramsToOmit(MuleConnectionProviderSerializableModel muleConnectionProviderSerializableModel) {
        String INPUT_FIELD_ACCESS_TOKEN = "accessToken";
        ArrayList<String> paramsToBeRemoved = new ArrayList<String>();
        if (muleConnectionProviderSerializableModel.getAuthenticationTypeName().startsWith(HttpAuthenticationType.Type.oauth2.name())) {
            paramsToBeRemoved.add("accessToken");
        }
        return paramsToBeRemoved;
    }
}

