/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.ic.internal.loader.property;

import com.mulesoft.connectivity.mule.persistence.model.connection.oauth.OAuth2AuthCodeAuthenticationType;
import com.mulesoft.connectivity.mule.persistence.model.connection.oauth.OAuth2AuthenticationType;
import com.mulesoft.connectivity.mule.persistence.model.connection.oauth.OAuth2ClientCredentialsAuthenticationType;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.ClientCredentialsGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthGrantType;
import org.mule.runtime.extension.api.security.CredentialsPlacement;

public class OAuthGrantTypeFactory {
    private OAuthGrantTypeFactory() {
    }

    public static OAuthGrantType createClientCredentialsGrantType(OAuth2ClientCredentialsAuthenticationType authenticationType) {
        return new ClientCredentialsGrantType(authenticationType.getTokenUrl(), "#[payload.access_token]", "#[payload.expires_in]", String.join((CharSequence)" ", authenticationType.getScopes()), OAuthGrantTypeFactory.toCredentialsPlacement(authenticationType.getPlacement()));
    }

    public static OAuthGrantType createAuthorizationCodeGrantType(OAuth2AuthCodeAuthenticationType authenticationType) {
        return new AuthorizationCodeGrantType(authenticationType.getTokenUrl(), authenticationType.getAuthorizationUrl(), "#[payload.access_token]", "#[payload.expires_in]", "#[payload.refresh_token]", String.join((CharSequence)" ", authenticationType.getScopes()), OAuthGrantTypeFactory.toCredentialsPlacement(authenticationType.getPlacement()), true);
    }

    private static CredentialsPlacement toCredentialsPlacement(OAuth2AuthenticationType.Placement placement) {
        return placement == OAuth2AuthenticationType.Placement.basicAuth ? CredentialsPlacement.BASIC_AUTH_HEADER : CredentialsPlacement.BODY;
    }
}

