/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.embedded.runner;

import java.io.File;
import java.io.OutputStream;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IProject;
import org.mule.tooling.maven.cmdline.MavenCommandLine;
import org.mule.tooling.maven.embedded.runner.MavenBuildRunnable;
import org.mule.tooling.maven.runner.MavenExecutionException;
import org.mule.tooling.maven.runner.MavenRunner;
import org.mule.tooling.maven.runner.MavenRunnerCallback;
import org.mule.tooling.maven.runner.MavenRunnerConfiguration;

public class EmbeddedMavenRunner
implements MavenRunner {
    private final MavenRunnerConfiguration configuration;
    private volatile Thread buildThread;
    private volatile MavenBuildRunnable mavenBuildRunnable;

    public EmbeddedMavenRunner(MavenRunnerConfiguration configuration) {
        this.configuration = configuration;
    }

    public void run(File pomFile, MavenCommandLine commandLine, MavenRunnerCallback callback, OutputStream outputStream) throws MavenExecutionException {
        String workingDirectory = pomFile.getParent();
        this.runInDirectory(workingDirectory, commandLine, callback, outputStream);
    }

    public void runBare(MavenCommandLine commandLine, MavenRunnerCallback callback, OutputStream outputStream) {
        File workingDirectory = this.generateTempWorkingDirectory();
        this.runInDirectory(workingDirectory.getAbsolutePath(), commandLine, callback, outputStream);
    }

    private File generateTempWorkingDirectory() {
        File workingDirectory = new File(FileUtils.getTempDirectory(), "studio-embedded-maven" + File.separator + UUID.randomUUID().toString());
        workingDirectory.mkdirs();
        workingDirectory.deleteOnExit();
        return workingDirectory;
    }

    private void runInDirectory(String workingDirectory, MavenCommandLine commandLine, MavenRunnerCallback callback, OutputStream outputStream) {
        String threadName = "Maven build: " + commandLine.getRawCommandArguments();
        this.mavenBuildRunnable = new MavenBuildRunnable(this.configuration, workingDirectory, commandLine, callback, outputStream, outputStream);
        this.buildThread = new Thread((Runnable)this.mavenBuildRunnable, threadName){

            @Override
            public void run() {
                try {
                    super.run();
                }
                finally {
                    EmbeddedMavenRunner.this.buildThread = null;
                }
            }
        };
        this.buildThread.start();
    }

    public void cancelBuild() {
        if (this.buildThread != null) {
            this.mavenBuildRunnable.cancel();
            this.buildThread.interrupt();
        }
    }

    public String toString() {
        return "EmbeddedMavenRunner [configuration=" + String.valueOf(this.configuration) + "]";
    }

    public void run(IProject project, MavenCommandLine commandLine, MavenRunnerCallback callback, OutputStream outputStream) throws MavenExecutionException {
        this.runInDirectory(project.getLocation().toFile().getAbsolutePath(), commandLine, callback, outputStream);
    }
}

