/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.embedded.log;

import java.io.PrintStream;
import org.mule.tooling.maven.embedded.log.Slf4jLoggerAdapter;
import org.slf4j.helpers.MessageFormatter;

public class MuleLogger
extends Slf4jLoggerAdapter {
    private boolean infoEnabled = true;
    private boolean warnEnabled = true;
    private boolean errorEnabled = true;
    private boolean debugEnabled = false;
    private boolean traceEnabled = false;
    private static ThreadLocal<PrintStream> outStreams = InheritableThreadLocal.withInitial(() -> System.out);
    private static ThreadLocal<PrintStream> errStreams = InheritableThreadLocal.withInitial(() -> System.err);

    public static void setOut(PrintStream outStream) {
        outStreams.set(outStream);
    }

    public static void setErr(PrintStream outStream) {
        errStreams.set(outStream);
    }

    public static PrintStream getOutStream() {
        return outStreams.get();
    }

    public static PrintStream getErrStream() {
        return errStreams.get();
    }

    public static void dispose() {
        outStreams.remove();
        errStreams.remove();
    }

    public MuleLogger(boolean debugEnabled, boolean errorEnabled, boolean warnEnabled) {
        this.debugEnabled = debugEnabled;
        this.errorEnabled = errorEnabled;
        this.warnEnabled = warnEnabled;
    }

    public boolean isInfoEnabled() {
        return this.infoEnabled;
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public boolean isErrorEnabled() {
        return this.errorEnabled;
    }

    public boolean isWarnEnabled() {
        return this.warnEnabled;
    }

    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    private void defaultLog(PrintStream stream, String message) {
        this.defaultLog(stream, "", message);
    }

    private void defaultLog(PrintStream stream, String prefix, String message) {
        stream.println(prefix + message);
        stream.flush();
    }

    private void infoLog(String message) {
        this.defaultLog(MuleLogger.getOutStream(), "[INFO] ", message);
    }

    private void debugLog(String message) {
        this.defaultLog(MuleLogger.getOutStream(), "[DEBUG] ", message);
    }

    private void warnLog(String message) {
        this.defaultLog(MuleLogger.getErrStream(), "[WARNING] ", message);
    }

    private void errorLog(String message) {
        this.defaultLog(MuleLogger.getErrStream(), "[ERROR] ", message);
    }

    public void info(String message) {
        this.infoLog(message);
    }

    public void info(String message, Object arg1) {
        this.infoLog(MessageFormatter.format((String)message, (Object)arg1).getMessage());
    }

    public void info(String message, Object ... arg1) {
        this.infoLog(MessageFormatter.arrayFormat((String)message, (Object[])arg1).getMessage());
    }

    public void info(String message, Throwable arg1) {
        this.infoLog(MessageFormatter.format((String)message, (Object)this.print(arg1)).getMessage());
    }

    public void info(String message, Object arg1, Object arg2) {
        this.infoLog(MessageFormatter.format((String)message, (Object)arg1, (Object)arg2).getMessage());
    }

    public void warn(String message) {
        if (this.isWarnEnabled()) {
            this.warnLog(message);
        }
    }

    public void warn(String message, Object arg1) {
        if (this.isWarnEnabled()) {
            this.warnLog(MessageFormatter.format((String)message, (Object)arg1).getMessage());
        }
    }

    public void warn(String message, Object ... arg1) {
        if (this.isWarnEnabled()) {
            this.warnLog(MessageFormatter.arrayFormat((String)message, (Object[])arg1).getMessage());
        }
    }

    public void warn(String message, Throwable arg1) {
        if (this.isWarnEnabled()) {
            this.warnLog(MessageFormatter.format((String)message, (Object)this.print(arg1)).getMessage());
        }
    }

    public void warn(String message, Object arg1, Object arg2) {
        if (this.isWarnEnabled()) {
            this.warnLog(MessageFormatter.format((String)message, (Object)arg1, (Object)arg2).getMessage());
        }
    }

    public void debug(String message) {
        if (this.isDebugEnabled()) {
            this.debugLog(message);
        }
    }

    public void debug(String message, Object arg1) {
        if (this.isDebugEnabled()) {
            this.debugLog(MessageFormatter.format((String)message, (Object)arg1).getMessage());
        }
    }

    public void debug(String message, Object ... arg1) {
        if (this.isDebugEnabled()) {
            this.debugLog(MessageFormatter.arrayFormat((String)message, (Object[])arg1).getMessage());
        }
    }

    public void debug(String message, Throwable arg1) {
        if (this.isDebugEnabled()) {
            this.debugLog(MessageFormatter.format((String)message, (Object)this.print(arg1)).getMessage());
        }
    }

    public void debug(String message, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            this.debugLog(MessageFormatter.format((String)message, (Object)arg1, (Object)arg2).getMessage());
        }
    }

    public void error(String message) {
        this.errorLog(message);
    }

    public void error(String message, Object arg1) {
        this.errorLog(MessageFormatter.format((String)message, (Object)arg1).getMessage());
    }

    public void error(String message, Object ... arg1) {
        this.errorLog(MessageFormatter.arrayFormat((String)message, (Object[])arg1).getMessage());
    }

    public void error(String message, Throwable arg1) {
        this.errorLog(MessageFormatter.format((String)message, (Object)this.print(arg1)).getMessage());
    }

    public void error(String message, Object arg1, Object arg2) {
        this.errorLog(MessageFormatter.format((String)message, (Object)arg1, (Object)arg2).getMessage());
    }

    public String getName() {
        return "Studio custom logger";
    }

    public void trace(String message) {
        if (this.isTraceEnabled()) {
            this.defaultLog(MuleLogger.getOutStream(), message);
        }
    }

    public void trace(String message, Object arg1) {
        if (this.isTraceEnabled()) {
            this.defaultLog(MuleLogger.getOutStream(), MessageFormatter.format((String)message, (Object)arg1).getMessage());
        }
    }

    public void trace(String message, Object ... arg1) {
        if (this.isTraceEnabled()) {
            this.defaultLog(MuleLogger.getOutStream(), MessageFormatter.arrayFormat((String)message, (Object[])arg1).getMessage());
        }
    }

    public void trace(String message, Throwable arg1) {
        if (this.isTraceEnabled()) {
            this.defaultLog(MuleLogger.getOutStream(), MessageFormatter.format((String)message, (Object)this.print(arg1)).getMessage());
        }
    }

    public void trace(String message, Object arg1, Object arg2) {
        if (this.isTraceEnabled()) {
            this.defaultLog(MuleLogger.getOutStream(), MessageFormatter.format((String)message, (Object)arg1, (Object)arg2).getMessage());
        }
    }
}

