/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.processor.chain;

import jakarta.inject.Inject;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.mule.runtime.api.alert.AlertingSupport;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.notification.MessageProcessorNotification;
import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.api.profiling.ProfilingDataProducer;
import org.mule.runtime.api.profiling.ProfilingEventContext;
import org.mule.runtime.api.profiling.type.RuntimeProfilingEventTypes;
import org.mule.runtime.api.profiling.type.context.ComponentThreadingProfilingEventContext;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.context.notification.MuleContextListener;
import org.mule.runtime.core.api.context.notification.ServerNotificationHandler;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.event.EventContextService;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.execution.ExceptionContextProvider;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.lifecycle.StartException;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.internal.artifact.ArtifactClassLoaderFinder;
import org.mule.runtime.core.internal.context.DefaultMuleContext;
import org.mule.runtime.core.internal.event.DefaultEventContextService;
import org.mule.runtime.core.internal.event.NullEventFactory;
import org.mule.runtime.core.internal.exception.GlobalErrorHandler;
import org.mule.runtime.core.internal.exception.MessagingExceptionResolver;
import org.mule.runtime.core.internal.interception.InterceptorManager;
import org.mule.runtime.core.internal.interception.ReactiveInterceptor;
import org.mule.runtime.core.internal.processor.chain.InterceptedReactiveProcessor;
import org.mule.runtime.core.internal.processor.interceptor.ProcessorInterceptorFactoryAdapter;
import org.mule.runtime.core.internal.processor.interceptor.ReactiveInterceptorAdapter;
import org.mule.runtime.core.internal.processor.strategy.util.ProfilingUtils;
import org.mule.runtime.core.internal.profiling.InternalProfilingService;
import org.mule.runtime.core.internal.profiling.context.DefaultComponentThreadingProfilingEventContext;
import org.mule.runtime.core.internal.profiling.tracing.event.span.condition.NotNullSpanAssertion;
import org.mule.runtime.core.internal.rx.FluxSinkRecorder;
import org.mule.runtime.core.internal.streaming.IdentifiableCursorProvider;
import org.mule.runtime.core.internal.streaming.IdentifiableCursorProviderDecorator;
import org.mule.runtime.core.internal.streaming.StreamingUtils;
import org.mule.runtime.core.internal.util.rx.RxUtils;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.runtime.core.privileged.exception.ErrorTypeLocator;
import org.mule.runtime.core.privileged.exception.EventProcessingException;
import org.mule.runtime.core.privileged.exception.MessagingException;
import org.mule.runtime.core.privileged.processor.AbstractExecutableComponent;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.chain.ChainErrorHandlingUtils;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.core.privileged.processor.chain.UnnamedComponent;
import org.mule.runtime.metrics.api.MeterProvider;
import org.mule.runtime.metrics.api.error.ErrorMetrics;
import org.mule.runtime.metrics.api.error.ErrorMetricsFactory;
import org.mule.runtime.tracer.api.EventTracer;
import org.mule.runtime.tracer.api.component.ComponentTracer;
import org.mule.runtime.tracer.api.component.ComponentTracerFactory;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import reactor.core.CoreSubscriber;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Hooks;
import reactor.core.publisher.Operators;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

abstract class AbstractMessageProcessorChain
extends AbstractExecutableComponent
implements MessageProcessorChain {
    private static final String REACTOR_ON_OPERATOR_ERROR_LOCAL = "reactor.onOperatorError.local";
    private static final String UNEXPECTED_ERROR_HANDLER_STATE_MESSAGE = "Unexpected state. Error handler should be invoked with either an Event instance or a MessagingException. This may lead to an event getting stuck, or even a processor may stop responding.";
    public static final String UNKNOWN = "unknown";
    private static final Logger MULE_CTX_LOGGER = LoggerFactory.getLogger(DefaultMuleContext.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMessageProcessorChain.class);
    private static final Map<ClassLoader, AlertingSupport> ALERTS_PER_DEPLOYMENT = new WeakHashMap<ClassLoader, AlertingSupport>();
    private static final Map<ClassLoader, EventContextService> EVENT_CONTEXT_SERVICES_PER_DEPLOYMENT = new WeakHashMap<ClassLoader, EventContextService>();
    private final String name;
    private final List<Processor> processors;
    private final FlowExceptionHandler messagingExceptionHandler;
    private final ProcessingStrategy processingStrategy;
    private final List<ReactiveInterceptorAdapter> additionalInterceptors = new LinkedList<ReactiveInterceptorAdapter>();
    private boolean canProcessMessage = true;
    @Inject
    private ServerNotificationHandler serverNotificationHandler;
    @Inject
    private ErrorTypeLocator errorTypeLocator;
    @Inject
    private Collection<ExceptionContextProvider> exceptionContextProviders;
    @Inject
    private InterceptorManager processorInterceptorManager;
    @Inject
    private StreamingManager streamingManager;
    @Inject
    private InternalProfilingService profilingService;
    @Inject
    private SchedulerService schedulerService;
    @Inject
    private ComponentTracerFactory<CoreEvent> componentTracerFactory;
    @Inject
    private EventContextService eventContextService;
    private ProfilingDataProducer<ComponentThreadingProfilingEventContext, CoreEvent> startingOperationExecutionDataProducer;
    private ProfilingDataProducer<ComponentThreadingProfilingEventContext, CoreEvent> endOperationExecutionDataProducer;
    private LazyValue<Scheduler> switchOnErrorScheduler;
    private EventTracer<CoreEvent> muleEventTracer;
    private ComponentTracer<CoreEvent> chainComponentTracer;
    private MuleContextListener stopListener;
    private boolean chainSpanCreated = false;
    private static final Component UNKNOWN_COMPONENT;
    @Inject
    private AlertingSupport alertingSupport;
    @Inject
    private MeterProvider meterProvider;
    @Inject
    private ErrorMetricsFactory errorMetricsFactory;
    private ErrorMetrics errorMetrics;

    public static void configureReactorHooks() {
        Hooks.onErrorDropped(error -> {
            MULE_CTX_LOGGER.debug("ERROR DROPPED", error);
            LOGGER.warn("ERROR DROPPED", error);
            EventContextService eventContextService = EVENT_CONTEXT_SERVICES_PER_DEPLOYMENT.get(AbstractMessageProcessorChain.resolveRegionContextClassLoader().orElseGet(() -> Thread.currentThread().getContextClassLoader()));
            if (eventContextService instanceof DefaultEventContextService) {
                DefaultEventContextService defaultService = (DefaultEventContextService)eventContextService;
                defaultService.recordDroppedError((Throwable)error);
            }
            ALERTS_PER_DEPLOYMENT.get(AbstractMessageProcessorChain.resolveRegionContextClassLoader().orElseGet(() -> Thread.currentThread().getContextClassLoader())).triggerAlert("REACTOR_DROPPED_ERROR", (Object)AbstractMessageProcessorChain.getFullStackTrace(error));
        });
        Hooks.onNextDropped(event -> {
            String string;
            MULE_CTX_LOGGER.debug("EVENT DROPPED {}", event);
            LOGGER.warn("EVENT DROPPED {}", event);
            EventContextService eventContextService = EVENT_CONTEXT_SERVICES_PER_DEPLOYMENT.get(AbstractMessageProcessorChain.resolveRegionContextClassLoader().orElseGet(() -> Thread.currentThread().getContextClassLoader()));
            if (eventContextService instanceof DefaultEventContextService) {
                DefaultEventContextService defaultService = (DefaultEventContextService)eventContextService;
                if (event instanceof Event) {
                    Event e = (Event)event;
                    defaultService.recordDroppedEvent(e.getContext().getId());
                }
            }
            if (event instanceof Event) {
                Event e = (Event)event;
                string = e.getCorrelationId();
            } else {
                string = event.toString();
            }
            ALERTS_PER_DEPLOYMENT.get(AbstractMessageProcessorChain.resolveRegionContextClassLoader().orElseGet(() -> Thread.currentThread().getContextClassLoader())).triggerAlert("REACTOR_DROPPED_EVENT", (Object)string);
        });
    }

    AbstractMessageProcessorChain(String name, Optional<ProcessingStrategy> processingStrategyOptional, List<Processor> processors, FlowExceptionHandler messagingExceptionHandler) {
        this.name = name;
        this.processingStrategy = processingStrategyOptional.orElse(null);
        this.processors = processors;
        this.messagingExceptionHandler = messagingExceptionHandler;
    }

    @Override
    public CoreEvent process(CoreEvent event) throws MuleException {
        return MessageProcessors.processToApply(event, this);
    }

    @Override
    public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
        List<ReactiveInterceptor> interceptors = this.resolveInterceptors();
        if (this.getMessagingExceptionHandler() != null) {
            FluxSinkRecorder errorSwitchSinkSinkRef = new FluxSinkRecorder();
            return Flux.deferContextual(ctx -> this.contextualPublisher(publisher, interceptors, errorSwitchSinkSinkRef, (ContextView)ctx));
        }
        return this.doApply(publisher, interceptors, (context, throwable) -> {
            CoreEvent coreEvent = ((MessagingException)((Object)((Object)throwable))).getEvent();
            this.muleEventTracer.recordErrorAtCurrentSpan((Event)coreEvent, true);
            this.muleEventTracer.endCurrentSpan((Event)coreEvent, NotNullSpanAssertion.getNotNullSpanTracingCondition());
            this.muleEventTracer.recordErrorAtCurrentSpan((Event)coreEvent, true);
            this.chainComponentTracer.endCurrentSpan((Event)coreEvent);
            this.errorMetrics.measure((Throwable)throwable);
            context.error((Throwable)throwable);
        });
    }

    private Publisher<CoreEvent> contextualPublisher(Publisher<CoreEvent> publisher, List<ReactiveInterceptor> interceptors, FluxSinkRecorder<Either<MessagingException, CoreEvent>> errorSwitchSinkSinkRef, ContextView ctx) {
        AtomicInteger inflightEvents = new AtomicInteger();
        Consumer<Exception> errorRouter = this.getRouter(() -> this.getMessagingExceptionHandler().router(pub -> Flux.from((Publisher)pub).contextWrite(ctx), handled -> {
            if (this.chainSpanCreated) {
                this.chainComponentTracer.endCurrentSpan((Event)handled);
            }
            errorSwitchSinkSinkRef.next(Either.right((Object)handled));
        }, rethrown -> {
            CoreEvent coreEvent = ((EventProcessingException)((Object)((Object)((Object)rethrown)))).getEvent();
            if (this.chainSpanCreated) {
                this.muleEventTracer.recordErrorAtCurrentSpan((Event)coreEvent, () -> ChainErrorHandlingUtils.resolveError((EventProcessingException)((Object)((Object)((Object)((Object)rethrown)))), this.errorTypeLocator), true);
                this.chainComponentTracer.endCurrentSpan((Event)coreEvent);
            }
            errorSwitchSinkSinkRef.next(Either.left((Object)((Object)((MessagingException)((Object)((Object)((Object)rethrown))))), CoreEvent.class));
        }), this.recreateRouter(ctx));
        Flux upstream = Flux.from(this.doApply(publisher, interceptors, (context, throwable) -> {
            inflightEvents.incrementAndGet();
            if (this.chainSpanCreated) {
                this.muleEventTracer.recordErrorAtCurrentSpan((Event)((MessagingException)((Object)((Object)throwable))).getEvent(), () -> ChainErrorHandlingUtils.resolveError((MessagingException)((Object)((Object)((Object)throwable))), this.errorTypeLocator), true);
                this.muleEventTracer.endCurrentSpan((Event)((MessagingException)((Object)((Object)throwable))).getEvent(), NotNullSpanAssertion.getNotNullSpanTracingCondition());
            }
            this.routeError(errorRouter, (Exception)throwable);
        }));
        return Flux.from(RxUtils.propagateCompletion(upstream, errorSwitchSinkSinkRef.flux(), pub -> Flux.from((Publisher)pub).map(event -> {
            Either result = Either.right(MessagingException.class, (Object)event);
            errorSwitchSinkSinkRef.next(result);
            return result;
        }), inflightEvents, () -> {
            errorSwitchSinkSinkRef.complete();
            LifecycleUtils.disposeIfNeeded(errorRouter, LOGGER);
            this.clearRouterInGlobalErrorHandler(this.getMessagingExceptionHandler());
        }, t -> {
            errorSwitchSinkSinkRef.error((Throwable)t);
            LifecycleUtils.disposeIfNeeded(errorRouter, LOGGER);
            this.clearRouterInGlobalErrorHandler(this.messagingExceptionHandler);
        })).map(RxUtils.propagateErrorResponseMapper());
    }

    private boolean recreateRouter(ContextView ctx) {
        return (Boolean)ctx.getOrDefault((Object)"recreateRouter", (Object)false) != false || TransactionCoordination.isTransactionActive();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Consumer<Exception> getRouter(Supplier<Consumer<Exception>> errorRouterSupplier, boolean recreateRouter) {
        FlowExceptionHandler flowExceptionHandler = this.getMessagingExceptionHandler();
        if (!(flowExceptionHandler instanceof GlobalErrorHandler)) return errorRouterSupplier.get();
        GlobalErrorHandler globalEH = (GlobalErrorHandler)flowExceptionHandler;
        if (recreateRouter) return errorRouterSupplier.get();
        return globalEH.routerForChain(this, errorRouterSupplier);
    }

    private void clearRouterInGlobalErrorHandler(FlowExceptionHandler messagingExceptionHandler) {
        if (messagingExceptionHandler instanceof GlobalErrorHandler) {
            GlobalErrorHandler globalEH = (GlobalErrorHandler)messagingExceptionHandler;
            globalEH.clearRouterForChain(this);
        }
    }

    private void routeError(Consumer<Exception> errorRouter, Exception throwable) {
        if (!TransactionCoordination.isTransactionActive() && !this.schedulerService.isCurrentThreadInWaitGroup()) {
            Map mdc = MDC.getCopyOfContextMap();
            ((Scheduler)this.switchOnErrorScheduler.get()).submit(() -> {
                try {
                    MDC.setContextMap((Map)mdc);
                    errorRouter.accept(throwable);
                }
                finally {
                    MDC.clear();
                }
            });
        } else {
            errorRouter.accept(throwable);
        }
    }

    @Deprecated
    public Publisher<CoreEvent> doApply(Publisher<CoreEvent> publisher, BiConsumer<BaseEventContext, ? super Exception> errorBubbler) {
        return this.doApply(publisher, this.resolveInterceptors(), errorBubbler);
    }

    private Publisher<CoreEvent> doApply(Publisher<CoreEvent> publisher, List<ReactiveInterceptor> interceptors, BiConsumer<BaseEventContext, ? super Exception> errorBubbler) {
        Flux stream = Flux.from(publisher);
        stream = stream.doOnNext(event -> this.chainComponentTracer.startSpan((Event)event).ifPresent(span -> {
            this.chainSpanCreated = true;
        }));
        for (Processor processor : this.getProcessorsToExecute()) {
            stream = stream.transform((Function)this.applyInterceptors(interceptors, processor)).contextWrite(context -> context.put((Object)REACTOR_ON_OPERATOR_ERROR_LOCAL, ChainErrorHandlingUtils.getLocalOperatorErrorHook(processor, this.errorTypeLocator, this.exceptionContextProviders))).onErrorContinue(exception -> !(exception instanceof LifecycleException), this.getContinueStrategyErrorHandler(processor, errorBubbler));
        }
        stream = stream.doOnNext(event -> this.chainComponentTracer.endCurrentSpan((Event)event));
        return stream;
    }

    private static Optional<ClassLoader> resolveRegionContextClassLoader() {
        return ArtifactClassLoaderFinder.artifactClassLoaderFinder().findRegionContextClassLoader();
    }

    private BiConsumer<Throwable, Object> getContinueStrategyErrorHandler(Processor processor, BiConsumer<BaseEventContext, ? super Exception> errorBubbler) {
        MessagingExceptionResolver messagingExceptionResolver;
        if (processor instanceof Component) {
            Component component = (Component)processor;
            messagingExceptionResolver = new MessagingExceptionResolver(component);
        } else {
            messagingExceptionResolver = null;
        }
        MessagingExceptionResolver exceptionResolver = messagingExceptionResolver;
        UnaryOperator<MessagingException> messagingExceptionMapper = ChainErrorHandlingUtils.resolveMessagingException(processor, e -> exceptionResolver.resolve((MessagingException)((Object)e), this.errorTypeLocator, this.exceptionContextProviders));
        return (throwable, object) -> this.handleErrorForContinueStrategy(processor, errorBubbler, exceptionResolver, messagingExceptionMapper, org.mule.runtime.core.api.rx.Exceptions.unwrap(throwable), object);
    }

    private void handleErrorForContinueStrategy(Processor processor, BiConsumer<BaseEventContext, ? super Exception> errorBubbler, MessagingExceptionResolver exceptionResolver, UnaryOperator<MessagingException> messagingExceptionMapper, Throwable throwable, Object object) {
        if (!(object instanceof CoreEvent) && !(throwable instanceof MessagingException)) {
            LOGGER.error(UNEXPECTED_ERROR_HANDLER_STATE_MESSAGE, throwable);
            throwable = new MessagingException(NullEventFactory.getNullEvent(), (Throwable)throwable);
        }
        if (object != null && !(object instanceof CoreEvent)) {
            this.notifyError(processor, (BaseEventContext)((MessagingException)((Object)throwable)).getEvent().getContext(), (MessagingException)((Object)messagingExceptionMapper.apply((MessagingException)((Object)throwable))), errorBubbler);
        } else {
            CoreEvent event = (CoreEvent)object;
            if (throwable instanceof MessagingException) {
                MessagingException msgException = (MessagingException)((Object)throwable);
                this.notifyError(processor, (BaseEventContext)(event != null ? event.getContext() : msgException.getEvent().getContext()), (MessagingException)((Object)messagingExceptionMapper.apply(msgException)), errorBubbler);
            } else {
                this.notifyError(processor, (BaseEventContext)event.getContext(), ChainErrorHandlingUtils.resolveException(processor, event, throwable, this.errorTypeLocator, this.exceptionContextProviders, exceptionResolver), errorBubbler);
            }
        }
    }

    private void notifyError(Processor processor, BaseEventContext context, MessagingException resolvedException, BiConsumer<BaseEventContext, ? super Exception> errorBubbler) {
        this.errorNotification(processor).andThen((? super T t) -> errorBubbler.accept(context, (Exception)t)).accept((Exception)((Object)resolvedException));
    }

    private ReactiveProcessor applyInterceptors(List<ReactiveInterceptor> interceptorsToBeExecuted, Processor processor) {
        ReactiveProcessor interceptorWrapperProcessorFunction = processor;
        for (ReactiveInterceptor interceptor : interceptorsToBeExecuted) {
            interceptorWrapperProcessorFunction = (ReactiveProcessor)interceptor.apply(processor, interceptorWrapperProcessorFunction);
        }
        return interceptorWrapperProcessorFunction;
    }

    private List<ReactiveInterceptor> resolveInterceptors() {
        ArrayList<ReactiveInterceptor> interceptors = new ArrayList<ReactiveInterceptor>();
        interceptors.add((processor, next) -> stream -> Flux.from((Publisher)stream).transform(this.doOnNext((ReactiveProcessor)next, (Processor)processor)).doOnDiscard(CoreEvent.class, event -> this.alertingSupport.triggerAlert("REACTOR_DISCARDED_EVENT", (Object)event.getCorrelationId())));
        if (this.processingStrategy != null) {
            interceptors.add((processor, next) -> this.processingStrategy.onProcessor(new InterceptedReactiveProcessor((ReactiveProcessor)processor, (ReactiveProcessor)next)));
        }
        interceptors.add(this.wrapCursorProviderWithIdentifiableDecorator());
        interceptors.addAll(this.additionalInterceptors);
        interceptors.add((processor, next) -> {
            String processorPath = AbstractMessageProcessorChain.getProcessorPath((Processor)processor);
            ComponentTracer<CoreEvent> coreComponentTracer = this.getComponentTracer((ReactiveProcessor)processor, this.chainComponentTracer);
            return stream -> Flux.from((Publisher)stream).doOnNext(event -> this.beforeComponentProcessingStrategy((Processor)processor, processorPath, (CoreEvent)event, coreComponentTracer)).transform((Function)next).map(result -> this.afterComponentProcessingStrategy((Processor)processor, processorPath, (CoreEvent)result));
        });
        return interceptors;
    }

    private ReactiveInterceptor wrapCursorProviderWithIdentifiableDecorator() {
        return (processor, next) -> stream -> Flux.from((Publisher)stream).transform((Function)next).map(result -> {
            IdentifiableCursorProviderDecorator identifiableProvider;
            CursorProvider cp;
            TypedValue payload = result.getMessage().getPayload();
            Object payloadValue = payload.getValue();
            if (payloadValue instanceof CursorProvider && !((cp = (CursorProvider)payloadValue) instanceof IdentifiableCursorProvider) && (identifiableProvider = IdentifiableCursorProviderDecorator.of(cp)) != cp) {
                Message message = Message.builder((Message)result.getMessage()).payload(new TypedValue(identifiableProvider, payload.getDataType(), payload.getByteLength())).build();
                return CoreEvent.builder(result).message(message).build();
            }
            return result;
        });
    }

    private void beforeProcessorInSameThread(CoreEvent event, Processor processor) {
        DefaultMuleContext.currentMuleContext.set(this.muleContext);
        PrivilegedEvent.setCurrentEvent((PrivilegedEvent)event);
    }

    private void afterProcessorInSameThread(CoreEvent event, Processor processor) {
        this.triggerOperationExecuted(event, AbstractMessageProcessorChain.getLocationIfComponent(processor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoreEvent afterComponentProcessingStrategy(Processor processor, String processorPath, CoreEvent result) {
        try {
            this.postNotification(processor).accept(result);
            PrivilegedEvent.setCurrentEvent((PrivilegedEvent)result);
            this.muleEventTracer.endCurrentSpan((Event)result);
            CoreEvent coreEvent = StreamingUtils.updateEventForStreaming(this.streamingManager).apply(result);
            return coreEvent;
        }
        finally {
            if (processorPath != null) {
                MDC.remove((String)"processorPath");
            }
        }
    }

    private ComponentTracer<CoreEvent> getComponentTracer(ReactiveProcessor processor, ComponentTracer<CoreEvent> parentComponentTracer) {
        if (processor instanceof Component) {
            Component component = (Component)processor;
            return this.componentTracerFactory.fromComponent(component, parentComponentTracer);
        }
        return this.componentTracerFactory.fromComponent(UNKNOWN_COMPONENT, UNKNOWN, "");
    }

    private void beforeComponentProcessingStrategy(Processor processor, String processorPath, CoreEvent event, ComponentTracer<CoreEvent> componentTracer) {
        componentTracer.startSpan((Event)event);
        if (!this.canProcessMessage) {
            throw Exceptions.propagate((Throwable)((Object)new MessagingException(event, (Throwable)new LifecycleException(CoreMessages.isStopped(this.name), (Object)event.getMessage()))));
        }
        if (processorPath != null) {
            MDC.put((String)"processorPath", (String)processorPath);
        }
        ComponentLocation componentLocation = AbstractMessageProcessorChain.getLocationIfComponent(processor);
        this.triggerStartingOperation(event, componentLocation);
        this.preNotification(event, processor);
    }

    private void triggerOperationExecuted(CoreEvent event, ComponentLocation componentLocation) {
        if (this.startingOperationExecutionDataProducer == null) {
            return;
        }
        this.endOperationExecutionDataProducer.triggerProfilingEvent((ProfilingEventContext)new DefaultComponentThreadingProfilingEventContext(event, componentLocation, Thread.currentThread().getName(), ProfilingUtils.getArtifactId(this.muleContext), ProfilingUtils.getArtifactType(this.muleContext), System.currentTimeMillis()));
    }

    private void triggerStartingOperation(CoreEvent event, ComponentLocation componentLocation) {
        if (this.startingOperationExecutionDataProducer == null) {
            return;
        }
        this.startingOperationExecutionDataProducer.triggerProfilingEvent((ProfilingEventContext)new DefaultComponentThreadingProfilingEventContext(event, componentLocation, Thread.currentThread().getName(), ProfilingUtils.getArtifactId(this.muleContext), ProfilingUtils.getArtifactType(this.muleContext), System.currentTimeMillis()));
    }

    private static ComponentLocation getLocationIfComponent(Processor processor) {
        Component component;
        if (processor instanceof Component && (component = (Component)processor).getLocation() != null) {
            return component.getLocation();
        }
        return null;
    }

    private static String getProcessorPath(Processor processor) {
        Component component;
        if (processor instanceof Component && (component = (Component)processor).getLocation() != null) {
            return component.getLocation().getLocation();
        }
        return null;
    }

    private void registerStopListener() {
        MuleContext muleContext = this.muleContext;
        if (muleContext instanceof DefaultMuleContext) {
            final DefaultMuleContext dmc = (DefaultMuleContext)muleContext;
            this.stopListener = new MuleContextListener(){

                @Override
                public void onCreation(MuleContext context) {
                }

                @Override
                public void onInitialization(MuleContext context, Registry registry) {
                }

                @Override
                public void onStart(MuleContext context, Registry registry) {
                }

                @Override
                public void onStop(MuleContext context, Registry registry) {
                    AbstractMessageProcessorChain.this.canProcessMessage = false;
                    dmc.removeListener(this);
                }
            };
            dmc.addListener(this.stopListener);
        }
    }

    private Function<? super Publisher<CoreEvent>, ? extends Publisher<CoreEvent>> doOnNext(ReactiveProcessor next, final Processor processor) {
        Function lifted = Operators.liftPublisher((publisher, subscriber) -> new CoreSubscriber<CoreEvent>(){

            public void onNext(CoreEvent event) {
                AbstractMessageProcessorChain.this.beforeProcessorInSameThread(event, processor);
                subscriber.onNext((Object)event);
                AbstractMessageProcessorChain.this.afterProcessorInSameThread(event, processor);
            }

            public void onError(Throwable throwable) {
                subscriber.onError(throwable);
            }

            public void onComplete() {
                subscriber.onComplete();
            }

            public Context currentContext() {
                return subscriber.currentContext();
            }

            public void onSubscribe(Subscription s) {
                subscriber.onSubscribe(s);
            }
        });
        return lifted.andThen(next);
    }

    private void preNotification(CoreEvent event, Processor processor) {
        if (((PrivilegedEvent)event).isNotificationsEnabled()) {
            this.fireNotification(event, processor, null, 1601);
        }
    }

    private Consumer<CoreEvent> postNotification(Processor processor) {
        return event -> {
            if (((PrivilegedEvent)event).isNotificationsEnabled()) {
                this.fireNotification((CoreEvent)event, processor, null, 1602);
            }
        };
    }

    private Consumer<Exception> errorNotification(Processor processor) {
        return exception -> {
            MessagingException msgException;
            if (exception instanceof MessagingException && ((PrivilegedEvent)(msgException = (MessagingException)((Object)((Object)exception))).getEvent()).isNotificationsEnabled()) {
                this.fireNotification(msgException.getEvent(), processor, msgException, 1602);
            }
        };
    }

    private void fireNotification(CoreEvent event, Processor processor, MessagingException exceptionThrown, int action) {
        Component component;
        if (this.serverNotificationHandler != null && processor instanceof Component && (component = (Component)processor).getLocation() != null) {
            this.serverNotificationHandler.fireNotification((Notification)MessageProcessorNotification.createFrom((Event)event, (ComponentLocation)component.getLocation(), (Component)component, (Exception)((Object)exceptionThrown), (int)action));
        }
    }

    protected List<Processor> getProcessorsToExecute() {
        return this.processors;
    }

    public String toString() {
        StringBuilder string = new StringBuilder();
        string.append(this.getClass().getSimpleName());
        if (!StringUtils.isBlank((CharSequence)this.name)) {
            string.append(String.format(" '%s' ", this.name));
        }
        Iterator<Processor> mpIterator = this.processors.iterator();
        String nl = String.format("%n", new Object[0]);
        if (mpIterator.hasNext()) {
            string.append(String.format("%n[ ", new Object[0]));
            while (mpIterator.hasNext()) {
                Processor mp = mpIterator.next();
                String indented = Strings.CS.replace(mp.toString(), nl, String.format("%n  ", new Object[0]));
                string.append(String.format("%n  %s", indented));
                if (!mpIterator.hasNext()) continue;
                string.append(", ");
            }
            string.append(String.format("%n]", new Object[0]));
        }
        return string.toString();
    }

    @Override
    public List<Processor> getMessageProcessors() {
        return this.processors;
    }

    protected List<Processor> getMessageProcessorsForLifecycle() {
        return this.processors;
    }

    @Override
    public void setMuleContext(MuleContext muleContext) {
        super.setMuleContext(muleContext);
        LifecycleUtils.setMuleContextIfNeeded(this.getMessageProcessorsForLifecycle(), muleContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialise() throws InitialisationException {
        this.additionalInterceptors.addAll(ReactiveInterceptorAdapter.createInterceptors(this.processorInterceptorManager.getInterceptorFactories().stream().map(ProcessorInterceptorFactoryAdapter::new).toList(), this.muleContext.getInjector()));
        LifecycleUtils.initialiseIfNeeded(this.getMessageProcessorsForLifecycle(), this.muleContext.getInjector());
        this.startingOperationExecutionDataProducer = this.profilingService.getProfilingDataProducer(RuntimeProfilingEventTypes.STARTING_OPERATION_EXECUTION);
        this.endOperationExecutionDataProducer = this.profilingService.getProfilingDataProducer(RuntimeProfilingEventTypes.OPERATION_EXECUTED);
        if (this.switchOnErrorScheduler == null) {
            this.switchOnErrorScheduler = new LazyValue(() -> this.schedulerService.cpuLightScheduler(SchedulerConfig.config().withName(Objects.requireNonNullElseGet(this.name, this::toString) + ".switchOnErrorScheduler")));
        }
        this.muleEventTracer = this.profilingService.getCoreEventTracer();
        if (this.chainComponentTracer == null) {
            this.chainComponentTracer = this.componentTracerFactory.fromComponent((Component)this);
        }
        this.errorMetrics = this.errorMetricsFactory.create(this.meterProvider.getMeterBuilder("Mule runtime error metrics").build());
        Map<ClassLoader, Object> map = ALERTS_PER_DEPLOYMENT;
        synchronized (map) {
            ALERTS_PER_DEPLOYMENT.putIfAbsent(AbstractMessageProcessorChain.resolveRegionContextClassLoader().orElseGet(() -> Thread.currentThread().getContextClassLoader()), this.alertingSupport);
        }
        map = EVENT_CONTEXT_SERVICES_PER_DEPLOYMENT;
        synchronized (map) {
            EVENT_CONTEXT_SERVICES_PER_DEPLOYMENT.putIfAbsent(AbstractMessageProcessorChain.resolveRegionContextClassLoader().orElseGet(() -> Thread.currentThread().getContextClassLoader()), this.eventContextService);
        }
    }

    public void start() throws MuleException {
        ArrayList<Processor> startedProcessors = new ArrayList<Processor>();
        try {
            for (Processor processor : this.getMessageProcessorsForLifecycle()) {
                if (!(processor instanceof Startable)) continue;
                Startable startableProcessor = (Startable)processor;
                this.startProcessor(startableProcessor);
                startedProcessors.add(processor);
            }
        }
        catch (MuleException e) {
            LifecycleUtils.stopIfNeeded(this.getMessageProcessorsForLifecycle());
            throw e;
        }
        this.registerStopListener();
        this.canProcessMessage = true;
    }

    private void startProcessor(Startable startableProcessor) throws StartException {
        try {
            startableProcessor.start();
        }
        catch (Exception e) {
            throw new StartException(I18nMessageFactory.createStaticMessage((String)"%s starting %s...", (Object[])new Object[]{e.getClass(), startableProcessor.toString()}), e, startableProcessor);
        }
    }

    public void stop() throws MuleException {
        this.canProcessMessage = false;
        LifecycleUtils.stopIfNeeded(this.getMessageProcessorsForLifecycle());
        if (this.stopListener != null) {
            ((DefaultMuleContext)this.muleContext).removeListener(this.stopListener);
        }
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.getMessageProcessorsForLifecycle(), LOGGER);
        if (this.switchOnErrorScheduler != null) {
            this.switchOnErrorScheduler.ifComputed(Scheduler::stop);
            this.switchOnErrorScheduler = null;
        }
    }

    static void clearAlertsPerDeploymentMap() {
        ALERTS_PER_DEPLOYMENT.clear();
    }

    static void clearEventContextServicesPerDeploymentMap() {
        EVENT_CONTEXT_SERVICES_PER_DEPLOYMENT.clear();
    }

    FlowExceptionHandler getMessagingExceptionHandler() {
        return this.messagingExceptionHandler;
    }

    public void setComponentTracer(ComponentTracer<CoreEvent> chainComponentTracer) {
        this.chainComponentTracer = chainComponentTracer;
    }

    public void setAlertingSupport(AlertingSupport alertingSupport) {
        this.alertingSupport = alertingSupport;
    }

    public void setEventContextService(EventContextService eventContextService) {
        this.eventContextService = eventContextService;
    }

    private static String getFullStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        return sw.toString();
    }

    static {
        AbstractMessageProcessorChain.configureReactorHooks();
        UNKNOWN_COMPONENT = UnnamedComponent.getUnnamedComponent();
    }
}

