/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.execution;

import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.execution.ExecutionCallback;
import org.mule.runtime.core.api.execution.ExecutionTemplate;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.internal.execution.BeginAndResolveTransactionInterceptor;
import org.mule.runtime.core.internal.execution.ExecuteCallbackInterceptor;
import org.mule.runtime.core.internal.execution.ExecutionContext;
import org.mule.runtime.core.internal.execution.ExecutionInterceptor;
import org.mule.runtime.core.internal.execution.IsolateCurrentTransactionInterceptor;
import org.mule.runtime.core.internal.execution.SuspendXaTransactionInterceptor;
import org.mule.runtime.core.internal.execution.ValidateTransactionalStateInterceptor;
import org.mule.runtime.core.internal.execution.compatibility.ResolvePreviousTransactionInterceptor;
import org.mule.runtime.core.internal.transaction.MuleTransactionConfig;
import org.mule.runtime.core.privileged.registry.RegistrationException;
import org.mule.runtime.core.privileged.transaction.TransactionConfig;
import org.mule.runtime.core.privileged.transaction.TransactionFactory;

public final class TransactionalExecutionTemplate<T>
implements ExecutionTemplate<T> {
    private ExecutionInterceptor<T> executionInterceptor;

    private TransactionalExecutionTemplate(String applicationName, NotificationDispatcher notificationDispatcher, TransactionConfig transactionConfig) {
        this(applicationName, notificationDispatcher, transactionConfig, true, false, true);
    }

    private TransactionalExecutionTemplate(String applicationName, NotificationDispatcher notificationDispatcher, TransactionConfig transactionConfig, boolean resolveAnyTransaction, boolean resolvePreviousTx, boolean errorAtTimeout) {
        if (transactionConfig == null) {
            transactionConfig = new MuleTransactionConfig();
        }
        boolean processTransactionOnException = true;
        ExecutionInterceptor tempExecutionInterceptor = new ExecuteCallbackInterceptor();
        tempExecutionInterceptor = new BeginAndResolveTransactionInterceptor(tempExecutionInterceptor, transactionConfig, applicationName, notificationDispatcher, true, resolveAnyTransaction, errorAtTimeout);
        if (resolvePreviousTx) {
            tempExecutionInterceptor = new ResolvePreviousTransactionInterceptor(tempExecutionInterceptor, transactionConfig);
        }
        tempExecutionInterceptor = new SuspendXaTransactionInterceptor(tempExecutionInterceptor, transactionConfig, true);
        tempExecutionInterceptor = new ValidateTransactionalStateInterceptor(tempExecutionInterceptor, transactionConfig, resolvePreviousTx);
        this.executionInterceptor = new IsolateCurrentTransactionInterceptor(tempExecutionInterceptor, transactionConfig);
    }

    public static <T> TransactionalExecutionTemplate<T> createTransactionalExecutionTemplate(Registry registry, byte txAction, TransactionFactory factory) {
        MuleContext muleContext = (MuleContext)registry.lookupByType(MuleContext.class).orElseThrow();
        MuleTransactionConfig transactionConfig = new MuleTransactionConfig(txAction);
        transactionConfig.setFactory(factory);
        return new TransactionalExecutionTemplate<T>(TransactionalExecutionTemplate.getApplicationName(muleContext), TransactionalExecutionTemplate.getNotificationDispatcher((MuleContextWithRegistry)muleContext), transactionConfig);
    }

    public static <T> TransactionalExecutionTemplate<T> createTransactionalExecutionTemplate(MuleConfiguration muleConfiguration, NotificationDispatcher notificationDispatcher, TransactionConfig transactionConfig) {
        return new TransactionalExecutionTemplate<T>(TransactionalExecutionTemplate.getApplicationName(muleConfiguration), notificationDispatcher, transactionConfig);
    }

    private static NotificationDispatcher getNotificationDispatcher(MuleContextWithRegistry muleContext) {
        try {
            return muleContext.getRegistry().lookupObject(NotificationDispatcher.class);
        }
        catch (RegistrationException e) {
            throw new MuleRuntimeException((Throwable)((Object)e));
        }
    }

    private static String getApplicationName(MuleContext muleContext) {
        return muleContext.getConfiguration().getId();
    }

    private static String getApplicationName(MuleConfiguration muleConfiguration) {
        return muleConfiguration.getId();
    }

    public static <T> TransactionalExecutionTemplate<T> createScopeTransactionalExecutionTemplate(MuleConfiguration muleConfiguration, NotificationDispatcher notificationDispatcher, TransactionConfig transactionConfig) {
        return new TransactionalExecutionTemplate<T>(TransactionalExecutionTemplate.getApplicationName(muleConfiguration), notificationDispatcher, transactionConfig, false, false, true);
    }

    public static <T> TransactionalExecutionTemplate<T> createScopeTransactionalExecutionTemplate(MuleConfiguration muleConfiguration, NotificationDispatcher notificationDispatcher, TransactionConfig transactionConfig, boolean errorAfterTimeout) {
        return new TransactionalExecutionTemplate<T>(TransactionalExecutionTemplate.getApplicationName(muleConfiguration), notificationDispatcher, transactionConfig, false, false, errorAfterTimeout);
    }

    @Override
    public T execute(ExecutionCallback<T> executionCallback) throws Exception {
        return this.executionInterceptor.execute(executionCallback, new ExecutionContext());
    }
}

