/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.version;

import com.vdurmont.semver4j.Semver;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class VersionRange {
    public static final String VERSION_RANGE = "([\\[(])([^,\\[\\]()]*),([^,\\[\\]()]*)([\\])])";
    public static final String LOWER_BOUND_INCLUSIVE = "[";
    public static final String LOWER_BOUND_EXCLUSIVE = "(";
    public static final String UPPER_BOUND_INCLUSIVE = "]";
    public static final String UPPER_BOUND_EXCLUSIVE = ")";
    public static final Pattern VERSION_RANGES = Pattern.compile("(([\\[(])([^,\\[\\]()]*),([^,\\[\\]()]*)([\\])])),?");
    public static final Pattern VALID_VERSION_RANGES = Pattern.compile("^(?:([\\[(])([^,\\[\\]()]*),([^,\\[\\]()]*)([\\])]),?)+$");
    private boolean isLowerBoundInclusive = false;
    private boolean isUpperBoundInclusive = false;
    private String lowerVersion;
    private String upperVersion;

    public static List<VersionRange> createVersionRanges(String versionsString) {
        if (!VALID_VERSION_RANGES.matcher(versionsString).matches()) {
            throw new IllegalArgumentException("Version range doesn't match pattern: " + VALID_VERSION_RANGES.pattern());
        }
        ArrayList<VersionRange> versions = new ArrayList<VersionRange>();
        Matcher m = VERSION_RANGES.matcher(versionsString);
        while (m.find()) {
            versions.add(new VersionRange(m.group(1)));
        }
        return versions;
    }

    public VersionRange(String versionRange) {
        Matcher m = VERSION_RANGES.matcher(versionRange);
        if (!m.matches()) {
            throw new IllegalArgumentException("Version range doesn't match pattern: " + VERSION_RANGES.pattern());
        }
        if (LOWER_BOUND_INCLUSIVE.equals(m.group(2))) {
            this.isLowerBoundInclusive = true;
        }
        if (UPPER_BOUND_INCLUSIVE.equals(m.group(5))) {
            this.isUpperBoundInclusive = true;
        }
        this.lowerVersion = m.group(3);
        this.upperVersion = m.group(4);
    }

    public String getLowerVersion() {
        return this.lowerVersion;
    }

    public String getUpperVersion() {
        return this.upperVersion;
    }

    public boolean isLowerBoundInclusive() {
        return this.isLowerBoundInclusive;
    }

    public boolean isUpperBoundInclusive() {
        return this.isUpperBoundInclusive;
    }

    public boolean contains(String version) {
        boolean maxWithin;
        boolean minWithin;
        Semver current = new Semver(version, Semver.SemverType.LOOSE);
        if (StringUtils.isBlank((CharSequence)this.getLowerVersion())) {
            minWithin = true;
        } else {
            Semver minMuleVersion = new Semver(this.getLowerVersion(), Semver.SemverType.LOOSE);
            boolean bl = minWithin = this.isLowerBoundInclusive() ? minMuleVersion.isLowerThanOrEqualTo(current) : minMuleVersion.isLowerThan(current);
        }
        if (StringUtils.isBlank((CharSequence)this.getUpperVersion())) {
            maxWithin = true;
        } else {
            Semver maxMuleVersion = new Semver(this.getUpperVersion(), Semver.SemverType.LOOSE);
            maxWithin = this.isUpperBoundInclusive() ? maxMuleVersion.isGreaterThanOrEqualTo(current) : maxMuleVersion.isGreaterThan(current);
        }
        return minWithin && maxWithin;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.isLowerBoundInclusive() ? LOWER_BOUND_INCLUSIVE : LOWER_BOUND_EXCLUSIVE);
        sb.append(this.getLowerVersion());
        sb.append(",");
        sb.append(this.getUpperVersion());
        sb.append(this.isUpperBoundInclusive() ? UPPER_BOUND_INCLUSIVE : UPPER_BOUND_EXCLUSIVE);
        return sb.toString();
    }
}

